package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_MERCHANT_DAILY_STATEMENT *
 * @author genrator
 */
public class EbMerchantDailyStatement_mapper extends EbMerchantDailyStatement implements BaseMapper<EbMerchantDailyStatement> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbMerchantDailyStatement> ROW_MAPPER = new EbMerchantDailyStatementRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String MerId = "mer_id";
    public static final String OrderPayAmount = "order_pay_amount";
    public static final String OrderNum = "order_num";
    public static final String OrderIncomeAmount = "order_income_amount";
    public static final String HandlingFee = "handling_fee";
    public static final String FirstBrokerage = "first_brokerage";
    public static final String SecondBrokerage = "second_brokerage";
    public static final String PayoutAmount = "payout_amount";
    public static final String PayoutNum = "payout_num";
    public static final String RefundAmount = "refund_amount";
    public static final String RefundNum = "refund_num";
    public static final String IncomeExpenditure = "income_expenditure";
    public static final String DataDate = "data_date";

    /**
     * 默认构造函数
     */
    public EbMerchantDailyStatement_mapper(EbMerchantDailyStatement ebMerchantDailyStatement) {
        if (ebMerchantDailyStatement == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebMerchantDailyStatement.isset_id) {
            this.setId(ebMerchantDailyStatement.getId());
        }
        //普通属性
        if (ebMerchantDailyStatement.isset_merId) {
            this.setMerId(ebMerchantDailyStatement.getMerId());
        }
        if (ebMerchantDailyStatement.isset_orderPayAmount) {
            this.setOrderPayAmount(ebMerchantDailyStatement.getOrderPayAmount());
        }
        if (ebMerchantDailyStatement.isset_orderNum) {
            this.setOrderNum(ebMerchantDailyStatement.getOrderNum());
        }
        if (ebMerchantDailyStatement.isset_orderIncomeAmount) {
            this.setOrderIncomeAmount(ebMerchantDailyStatement.getOrderIncomeAmount());
        }
        if (ebMerchantDailyStatement.isset_handlingFee) {
            this.setHandlingFee(ebMerchantDailyStatement.getHandlingFee());
        }
        if (ebMerchantDailyStatement.isset_firstBrokerage) {
            this.setFirstBrokerage(ebMerchantDailyStatement.getFirstBrokerage());
        }
        if (ebMerchantDailyStatement.isset_secondBrokerage) {
            this.setSecondBrokerage(ebMerchantDailyStatement.getSecondBrokerage());
        }
        if (ebMerchantDailyStatement.isset_payoutAmount) {
            this.setPayoutAmount(ebMerchantDailyStatement.getPayoutAmount());
        }
        if (ebMerchantDailyStatement.isset_payoutNum) {
            this.setPayoutNum(ebMerchantDailyStatement.getPayoutNum());
        }
        if (ebMerchantDailyStatement.isset_refundAmount) {
            this.setRefundAmount(ebMerchantDailyStatement.getRefundAmount());
        }
        if (ebMerchantDailyStatement.isset_refundNum) {
            this.setRefundNum(ebMerchantDailyStatement.getRefundNum());
        }
        if (ebMerchantDailyStatement.isset_incomeExpenditure) {
            this.setIncomeExpenditure(ebMerchantDailyStatement.getIncomeExpenditure());
        }
        if (ebMerchantDailyStatement.isset_dataDate) {
            this.setDataDate(ebMerchantDailyStatement.getDataDate());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_merchant_daily_statement.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_merchant_daily_statement";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(OrderPayAmount, this.getOrderPayAmount(), this.isset_orderPayAmount);
        ib.set(OrderNum, this.getOrderNum(), this.isset_orderNum);
        ib.set(OrderIncomeAmount, this.getOrderIncomeAmount(), this.isset_orderIncomeAmount);
        ib.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ib.set(FirstBrokerage, this.getFirstBrokerage(), this.isset_firstBrokerage);
        ib.set(SecondBrokerage, this.getSecondBrokerage(), this.isset_secondBrokerage);
        ib.set(PayoutAmount, this.getPayoutAmount(), this.isset_payoutAmount);
        ib.set(PayoutNum, this.getPayoutNum(), this.isset_payoutNum);
        ib.set(RefundAmount, this.getRefundAmount(), this.isset_refundAmount);
        ib.set(RefundNum, this.getRefundNum(), this.isset_refundNum);
        ib.set(IncomeExpenditure, this.getIncomeExpenditure(), this.isset_incomeExpenditure);
        ib.set(DataDate, this.getDataDate(), this.isset_dataDate);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(OrderPayAmount, this.getOrderPayAmount(), this.isset_orderPayAmount);
        ub.set(OrderNum, this.getOrderNum(), this.isset_orderNum);
        ub.set(OrderIncomeAmount, this.getOrderIncomeAmount(), this.isset_orderIncomeAmount);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(FirstBrokerage, this.getFirstBrokerage(), this.isset_firstBrokerage);
        ub.set(SecondBrokerage, this.getSecondBrokerage(), this.isset_secondBrokerage);
        ub.set(PayoutAmount, this.getPayoutAmount(), this.isset_payoutAmount);
        ub.set(PayoutNum, this.getPayoutNum(), this.isset_payoutNum);
        ub.set(RefundAmount, this.getRefundAmount(), this.isset_refundAmount);
        ub.set(RefundNum, this.getRefundNum(), this.isset_refundNum);
        ub.set(IncomeExpenditure, this.getIncomeExpenditure(), this.isset_incomeExpenditure);
        ub.set(DataDate, this.getDataDate(), this.isset_dataDate);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(OrderPayAmount, this.getOrderPayAmount(), this.isset_orderPayAmount);
        ub.set(OrderNum, this.getOrderNum(), this.isset_orderNum);
        ub.set(OrderIncomeAmount, this.getOrderIncomeAmount(), this.isset_orderIncomeAmount);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(FirstBrokerage, this.getFirstBrokerage(), this.isset_firstBrokerage);
        ub.set(SecondBrokerage, this.getSecondBrokerage(), this.isset_secondBrokerage);
        ub.set(PayoutAmount, this.getPayoutAmount(), this.isset_payoutAmount);
        ub.set(PayoutNum, this.getPayoutNum(), this.isset_payoutNum);
        ub.set(RefundAmount, this.getRefundAmount(), this.isset_refundAmount);
        ub.set(RefundNum, this.getRefundNum(), this.isset_refundNum);
        ub.set(IncomeExpenditure, this.getIncomeExpenditure(), this.isset_incomeExpenditure);
        ub.set(DataDate, this.getDataDate(), this.isset_dataDate);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(OrderPayAmount, this.getOrderPayAmount(), this.isset_orderPayAmount);
        ub.set(OrderNum, this.getOrderNum(), this.isset_orderNum);
        ub.set(OrderIncomeAmount, this.getOrderIncomeAmount(), this.isset_orderIncomeAmount);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(FirstBrokerage, this.getFirstBrokerage(), this.isset_firstBrokerage);
        ub.set(SecondBrokerage, this.getSecondBrokerage(), this.isset_secondBrokerage);
        ub.set(PayoutAmount, this.getPayoutAmount(), this.isset_payoutAmount);
        ub.set(PayoutNum, this.getPayoutNum(), this.isset_payoutNum);
        ub.set(RefundAmount, this.getRefundAmount(), this.isset_refundAmount);
        ub.set(RefundNum, this.getRefundNum(), this.isset_refundNum);
        ub.set(IncomeExpenditure, this.getIncomeExpenditure(), this.isset_incomeExpenditure);
        ub.set(DataDate, this.getDataDate(), this.isset_dataDate);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, mer_id, order_pay_amount, order_num, order_income_amount, handling_fee, first_brokerage, second_brokerage, payout_amount, payout_num, refund_amount, refund_num, income_expenditure, data_date from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, mer_id, order_pay_amount, order_num, order_income_amount, handling_fee, first_brokerage, second_brokerage, payout_amount, payout_num, refund_amount, refund_num, income_expenditure, data_date from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbMerchantDailyStatement mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbMerchantDailyStatement toEbMerchantDailyStatement() {
        return super.$clone();
    }
}

/**
 * eb_merchant_daily_statement RowMapper
 *
 * @author genrator
 */
class EbMerchantDailyStatementRowMapper implements RowMapper<EbMerchantDailyStatement> {

    @Override
    public EbMerchantDailyStatement mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbMerchantDailyStatement eb_merchant_daily_statement = new EbMerchantDailyStatement();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.Id);
        if (columnIndex > 0) {
            eb_merchant_daily_statement.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setMerId(null);
            } else {
                eb_merchant_daily_statement.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.OrderPayAmount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setOrderPayAmount(null);
            } else {
                eb_merchant_daily_statement.setOrderPayAmount(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.OrderNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setOrderNum(null);
            } else {
                eb_merchant_daily_statement.setOrderNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.OrderIncomeAmount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setOrderIncomeAmount(null);
            } else {
                eb_merchant_daily_statement.setOrderIncomeAmount(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.HandlingFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setHandlingFee(null);
            } else {
                eb_merchant_daily_statement.setHandlingFee(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.FirstBrokerage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setFirstBrokerage(null);
            } else {
                eb_merchant_daily_statement.setFirstBrokerage(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.SecondBrokerage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setSecondBrokerage(null);
            } else {
                eb_merchant_daily_statement.setSecondBrokerage(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.PayoutAmount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setPayoutAmount(null);
            } else {
                eb_merchant_daily_statement.setPayoutAmount(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.PayoutNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setPayoutNum(null);
            } else {
                eb_merchant_daily_statement.setPayoutNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.RefundAmount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setRefundAmount(null);
            } else {
                eb_merchant_daily_statement.setRefundAmount(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.RefundNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setRefundNum(null);
            } else {
                eb_merchant_daily_statement.setRefundNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.IncomeExpenditure);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_daily_statement.setIncomeExpenditure(null);
            } else {
                eb_merchant_daily_statement.setIncomeExpenditure(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantDailyStatement_mapper.DataDate);
        if (columnIndex > 0) {
            eb_merchant_daily_statement.setDataDate(rs.getString(columnIndex));
        }
        return eb_merchant_daily_statement;
    }
}
