package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_MERCHANT_INFO *
 * @author genrator
 */
public class EbMerchantInfo_mapper extends EbMerchantInfo implements BaseMapper<EbMerchantInfo> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbMerchantInfo> ROW_MAPPER = new EbMerchantInfoRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String MerId = "mer_id";
    public static final String SettlementType = "settlement_type";
    public static final String BankUserName = "bank_user_name";
    public static final String BankName = "bank_name";
    public static final String BankCard = "bank_card";
    public static final String BankAddress = "bank_address";
    public static final String WechatCode = "wechat_code";
    public static final String WechatQrcodeUrl = "wechat_qrcode_url";
    public static final String AlipayCode = "alipay_code";
    public static final String AlipayQrcodeUrl = "alipay_qrcode_url";
    public static final String AlertStock = "alert_stock";
    public static final String ServiceType = "service_type";
    public static final String ServiceLink = "service_link";
    public static final String ServicePhone = "service_phone";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";
    public static final String RealName = "real_name";

    /**
     * 默认构造函数
     */
    public EbMerchantInfo_mapper(EbMerchantInfo ebMerchantInfo) {
        if (ebMerchantInfo == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebMerchantInfo.isset_id) {
            this.setId(ebMerchantInfo.getId());
        }
        //普通属性
        if (ebMerchantInfo.isset_merId) {
            this.setMerId(ebMerchantInfo.getMerId());
        }
        if (ebMerchantInfo.isset_settlementType) {
            this.setSettlementType(ebMerchantInfo.getSettlementType());
        }
        if (ebMerchantInfo.isset_bankUserName) {
            this.setBankUserName(ebMerchantInfo.getBankUserName());
        }
        if (ebMerchantInfo.isset_bankName) {
            this.setBankName(ebMerchantInfo.getBankName());
        }
        if (ebMerchantInfo.isset_bankCard) {
            this.setBankCard(ebMerchantInfo.getBankCard());
        }
        if (ebMerchantInfo.isset_bankAddress) {
            this.setBankAddress(ebMerchantInfo.getBankAddress());
        }
        if (ebMerchantInfo.isset_wechatCode) {
            this.setWechatCode(ebMerchantInfo.getWechatCode());
        }
        if (ebMerchantInfo.isset_wechatQrcodeUrl) {
            this.setWechatQrcodeUrl(ebMerchantInfo.getWechatQrcodeUrl());
        }
        if (ebMerchantInfo.isset_alipayCode) {
            this.setAlipayCode(ebMerchantInfo.getAlipayCode());
        }
        if (ebMerchantInfo.isset_alipayQrcodeUrl) {
            this.setAlipayQrcodeUrl(ebMerchantInfo.getAlipayQrcodeUrl());
        }
        if (ebMerchantInfo.isset_alertStock) {
            this.setAlertStock(ebMerchantInfo.getAlertStock());
        }
        if (ebMerchantInfo.isset_serviceType) {
            this.setServiceType(ebMerchantInfo.getServiceType());
        }
        if (ebMerchantInfo.isset_serviceLink) {
            this.setServiceLink(ebMerchantInfo.getServiceLink());
        }
        if (ebMerchantInfo.isset_servicePhone) {
            this.setServicePhone(ebMerchantInfo.getServicePhone());
        }
        if (ebMerchantInfo.isset_createTime) {
            this.setCreateTime(ebMerchantInfo.getCreateTime());
        }
        if (ebMerchantInfo.isset_updateTime) {
            this.setUpdateTime(ebMerchantInfo.getUpdateTime());
        }
        if (ebMerchantInfo.isset_realName) {
            this.setRealName(ebMerchantInfo.getRealName());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_merchant_info.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_merchant_info";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(SettlementType, this.getSettlementType(), this.isset_settlementType);
        ib.set(BankUserName, this.getBankUserName(), this.isset_bankUserName);
        ib.set(BankName, this.getBankName(), this.isset_bankName);
        ib.set(BankCard, this.getBankCard(), this.isset_bankCard);
        ib.set(BankAddress, this.getBankAddress(), this.isset_bankAddress);
        ib.set(WechatCode, this.getWechatCode(), this.isset_wechatCode);
        ib.set(WechatQrcodeUrl, this.getWechatQrcodeUrl(), this.isset_wechatQrcodeUrl);
        ib.set(AlipayCode, this.getAlipayCode(), this.isset_alipayCode);
        ib.set(AlipayQrcodeUrl, this.getAlipayQrcodeUrl(), this.isset_alipayQrcodeUrl);
        ib.set(AlertStock, this.getAlertStock(), this.isset_alertStock);
        ib.set(ServiceType, this.getServiceType(), this.isset_serviceType);
        ib.set(ServiceLink, this.getServiceLink(), this.isset_serviceLink);
        ib.set(ServicePhone, this.getServicePhone(), this.isset_servicePhone);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ib.set(RealName, this.getRealName(), this.isset_realName);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(SettlementType, this.getSettlementType(), this.isset_settlementType);
        ub.set(BankUserName, this.getBankUserName(), this.isset_bankUserName);
        ub.set(BankName, this.getBankName(), this.isset_bankName);
        ub.set(BankCard, this.getBankCard(), this.isset_bankCard);
        ub.set(BankAddress, this.getBankAddress(), this.isset_bankAddress);
        ub.set(WechatCode, this.getWechatCode(), this.isset_wechatCode);
        ub.set(WechatQrcodeUrl, this.getWechatQrcodeUrl(), this.isset_wechatQrcodeUrl);
        ub.set(AlipayCode, this.getAlipayCode(), this.isset_alipayCode);
        ub.set(AlipayQrcodeUrl, this.getAlipayQrcodeUrl(), this.isset_alipayQrcodeUrl);
        ub.set(AlertStock, this.getAlertStock(), this.isset_alertStock);
        ub.set(ServiceType, this.getServiceType(), this.isset_serviceType);
        ub.set(ServiceLink, this.getServiceLink(), this.isset_serviceLink);
        ub.set(ServicePhone, this.getServicePhone(), this.isset_servicePhone);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(SettlementType, this.getSettlementType(), this.isset_settlementType);
        ub.set(BankUserName, this.getBankUserName(), this.isset_bankUserName);
        ub.set(BankName, this.getBankName(), this.isset_bankName);
        ub.set(BankCard, this.getBankCard(), this.isset_bankCard);
        ub.set(BankAddress, this.getBankAddress(), this.isset_bankAddress);
        ub.set(WechatCode, this.getWechatCode(), this.isset_wechatCode);
        ub.set(WechatQrcodeUrl, this.getWechatQrcodeUrl(), this.isset_wechatQrcodeUrl);
        ub.set(AlipayCode, this.getAlipayCode(), this.isset_alipayCode);
        ub.set(AlipayQrcodeUrl, this.getAlipayQrcodeUrl(), this.isset_alipayQrcodeUrl);
        ub.set(AlertStock, this.getAlertStock(), this.isset_alertStock);
        ub.set(ServiceType, this.getServiceType(), this.isset_serviceType);
        ub.set(ServiceLink, this.getServiceLink(), this.isset_serviceLink);
        ub.set(ServicePhone, this.getServicePhone(), this.isset_servicePhone);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(SettlementType, this.getSettlementType(), this.isset_settlementType);
        ub.set(BankUserName, this.getBankUserName(), this.isset_bankUserName);
        ub.set(BankName, this.getBankName(), this.isset_bankName);
        ub.set(BankCard, this.getBankCard(), this.isset_bankCard);
        ub.set(BankAddress, this.getBankAddress(), this.isset_bankAddress);
        ub.set(WechatCode, this.getWechatCode(), this.isset_wechatCode);
        ub.set(WechatQrcodeUrl, this.getWechatQrcodeUrl(), this.isset_wechatQrcodeUrl);
        ub.set(AlipayCode, this.getAlipayCode(), this.isset_alipayCode);
        ub.set(AlipayQrcodeUrl, this.getAlipayQrcodeUrl(), this.isset_alipayQrcodeUrl);
        ub.set(AlertStock, this.getAlertStock(), this.isset_alertStock);
        ub.set(ServiceType, this.getServiceType(), this.isset_serviceType);
        ub.set(ServiceLink, this.getServiceLink(), this.isset_serviceLink);
        ub.set(ServicePhone, this.getServicePhone(), this.isset_servicePhone);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, mer_id, settlement_type, bank_user_name, bank_name, bank_card, bank_address, wechat_code, wechat_qrcode_url, alipay_code, alipay_qrcode_url, alert_stock, service_type, service_link, service_phone, create_time, update_time, real_name from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, mer_id, settlement_type, bank_user_name, bank_name, bank_card, bank_address, wechat_code, wechat_qrcode_url, alipay_code, alipay_qrcode_url, alert_stock, service_type, service_link, service_phone, create_time, update_time, real_name from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbMerchantInfo mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbMerchantInfo toEbMerchantInfo() {
        return super.$clone();
    }
}

/**
 * eb_merchant_info RowMapper
 *
 * @author genrator
 */
class EbMerchantInfoRowMapper implements RowMapper<EbMerchantInfo> {

    @Override
    public EbMerchantInfo mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbMerchantInfo eb_merchant_info = new EbMerchantInfo();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.Id);
        if (columnIndex > 0) {
            eb_merchant_info.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_info.setMerId(null);
            } else {
                eb_merchant_info.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.SettlementType);
        if (columnIndex > 0) {
            eb_merchant_info.setSettlementType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.BankUserName);
        if (columnIndex > 0) {
            eb_merchant_info.setBankUserName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.BankName);
        if (columnIndex > 0) {
            eb_merchant_info.setBankName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.BankCard);
        if (columnIndex > 0) {
            eb_merchant_info.setBankCard(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.BankAddress);
        if (columnIndex > 0) {
            eb_merchant_info.setBankAddress(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.WechatCode);
        if (columnIndex > 0) {
            eb_merchant_info.setWechatCode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.WechatQrcodeUrl);
        if (columnIndex > 0) {
            eb_merchant_info.setWechatQrcodeUrl(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.AlipayCode);
        if (columnIndex > 0) {
            eb_merchant_info.setAlipayCode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.AlipayQrcodeUrl);
        if (columnIndex > 0) {
            eb_merchant_info.setAlipayQrcodeUrl(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.AlertStock);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_info.setAlertStock(null);
            } else {
                eb_merchant_info.setAlertStock(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.ServiceType);
        if (columnIndex > 0) {
            eb_merchant_info.setServiceType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.ServiceLink);
        if (columnIndex > 0) {
            eb_merchant_info.setServiceLink(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.ServicePhone);
        if (columnIndex > 0) {
            eb_merchant_info.setServicePhone(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_info.setCreateTime(null);
            } else {
                eb_merchant_info.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_info.setUpdateTime(null);
            } else {
                eb_merchant_info.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantInfo_mapper.RealName);
        if (columnIndex > 0) {
            eb_merchant_info.setRealName(rs.getString(columnIndex));
        }
        return eb_merchant_info;
    }
}
