
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_MERCHANT_PRODUCT_GUARANTEE_GROUP *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbMerchantProductGuaranteeGroup extends BasePo<EbMerchantProductGuaranteeGroup> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbMerchantProductGuaranteeGroup ROW_MAPPER = new EbMerchantProductGuaranteeGroup();

    // 主键
    private String id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Integer groupId = null;
    @JsonIgnore
    protected boolean isset_groupId = false;

    private Integer gid = null;
    @JsonIgnore
    protected boolean isset_gid = false;

    private Integer isShow = null;
    @JsonIgnore
    protected boolean isset_isShow = false;

    /**
     * 默认构造函数
     */
    public EbMerchantProductGuaranteeGroup() {
    }

    /**
     * 根据主键构造对象
     */
    public EbMerchantProductGuaranteeGroup(String id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((String) value);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null || this.id.length() == 0;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
        this.isset_groupId = true;
    }

    @JsonIgnore
    public boolean isEmptyGroupId() {
        return this.groupId == null;
    }

    public Integer getGid() {
        return this.gid;
    }

    public void setGid(Integer gid) {
        this.gid = gid;
        this.isset_gid = true;
    }

    @JsonIgnore
    public boolean isEmptyGid() {
        return this.gid == null;
    }

    public Integer getIsShow() {
        return this.isShow;
    }

    public void setIsShow(Integer isShow) {
        this.isShow = isShow;
        this.isset_isShow = true;
    }

    @JsonIgnore
    public boolean isEmptyIsShow() {
        return this.isShow == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("groupId=").append(this.groupId)
                .append("gid=").append(this.gid)
                .append("isShow=").append(this.isShow)
                .toString();
    }

    /**
     * 克隆
     */
    public EbMerchantProductGuaranteeGroup $clone() {
        EbMerchantProductGuaranteeGroup eb_merchant_product_guarantee_group = new EbMerchantProductGuaranteeGroup();

        // 数据库名称
        //eb_merchant_product_guarantee_group.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_merchant_product_guarantee_group.setId(this.getId());
        }
        // 普通属性
        if (this.isset_groupId) {
            eb_merchant_product_guarantee_group.setGroupId(this.getGroupId());
        }
        if (this.isset_gid) {
            eb_merchant_product_guarantee_group.setGid(this.getGid());
        }
        if (this.isset_isShow) {
            eb_merchant_product_guarantee_group.setIsShow(this.getIsShow());
        }
        return eb_merchant_product_guarantee_group;
    }
}
