package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_MERCHANT *
 * @author genrator
 */
public class EbMerchant_mapper extends EbMerchant implements BaseMapper<EbMerchant> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbMerchant> ROW_MAPPER = new EbMerchantRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Name = "name";
    public static final String CategoryId = "category_id";
    public static final String TypeId = "type_id";
    public static final String RealName = "real_name";
    public static final String Email = "email";
    public static final String Phone = "phone";
    public static final String HandlingFee = "handling_fee";
    public static final String Keywords = "keywords";
    public static final String Province = "province";
    public static final String City = "city";
    public static final String District = "district";
    public static final String AddressDetail = "address_detail";
    public static final String Latitude = "latitude";
    public static final String Longitude = "longitude";
    public static final String IsSelf = "is_self";
    public static final String IsRecommend = "is_recommend";
    public static final String IsSwitch = "is_switch";
    public static final String ProductSwitch = "product_switch";
    public static final String IsTakeTheir = "is_take_their";
    public static final String Remark = "remark";
    public static final String QualificationPicture = "qualification_picture";
    public static final String BackImage = "back_image";
    public static final String Avatar = "avatar";
    public static final String RectangleLogo = "rectangle_logo";
    public static final String CoverImage = "cover_image";
    public static final String StreetBackImage = "street_back_image";
    public static final String Intro = "intro";
    public static final String CopyProductNum = "copy_product_num";
    public static final String Balance = "balance";
    public static final String StarLevel = "star_level";
    public static final String PcBanner = "pc_banner";
    public static final String PcBackImage = "pc_back_image";
    public static final String Sort = "sort";
    public static final String CreateType = "create_type";
    public static final String CreateId = "create_id";
    public static final String AdminId = "admin_id";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";
    public static final String Uuid = "uuid";

    /**
     * 默认构造函数
     */
    public EbMerchant_mapper(EbMerchant ebMerchant) {
        if (ebMerchant == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebMerchant.isset_id) {
            this.setId(ebMerchant.getId());
        }
        //普通属性
        if (ebMerchant.isset_name) {
            this.setName(ebMerchant.getName());
        }
        if (ebMerchant.isset_categoryId) {
            this.setCategoryId(ebMerchant.getCategoryId());
        }
        if (ebMerchant.isset_typeId) {
            this.setTypeId(ebMerchant.getTypeId());
        }
        if (ebMerchant.isset_realName) {
            this.setRealName(ebMerchant.getRealName());
        }
        if (ebMerchant.isset_email) {
            this.setEmail(ebMerchant.getEmail());
        }
        if (ebMerchant.isset_phone) {
            this.setPhone(ebMerchant.getPhone());
        }
        if (ebMerchant.isset_handlingFee) {
            this.setHandlingFee(ebMerchant.getHandlingFee());
        }
        if (ebMerchant.isset_keywords) {
            this.setKeywords(ebMerchant.getKeywords());
        }
        if (ebMerchant.isset_province) {
            this.setProvince(ebMerchant.getProvince());
        }
        if (ebMerchant.isset_city) {
            this.setCity(ebMerchant.getCity());
        }
        if (ebMerchant.isset_district) {
            this.setDistrict(ebMerchant.getDistrict());
        }
        if (ebMerchant.isset_addressDetail) {
            this.setAddressDetail(ebMerchant.getAddressDetail());
        }
        if (ebMerchant.isset_latitude) {
            this.setLatitude(ebMerchant.getLatitude());
        }
        if (ebMerchant.isset_longitude) {
            this.setLongitude(ebMerchant.getLongitude());
        }
        if (ebMerchant.isset_isSelf) {
            this.setIsSelf(ebMerchant.getIsSelf());
        }
        if (ebMerchant.isset_isRecommend) {
            this.setIsRecommend(ebMerchant.getIsRecommend());
        }
        if (ebMerchant.isset_isSwitch) {
            this.setIsSwitch(ebMerchant.getIsSwitch());
        }
        if (ebMerchant.isset_productSwitch) {
            this.setProductSwitch(ebMerchant.getProductSwitch());
        }
        if (ebMerchant.isset_isTakeTheir) {
            this.setIsTakeTheir(ebMerchant.getIsTakeTheir());
        }
        if (ebMerchant.isset_remark) {
            this.setRemark(ebMerchant.getRemark());
        }
        if (ebMerchant.isset_qualificationPicture) {
            this.setQualificationPicture(ebMerchant.getQualificationPicture());
        }
        if (ebMerchant.isset_backImage) {
            this.setBackImage(ebMerchant.getBackImage());
        }
        if (ebMerchant.isset_avatar) {
            this.setAvatar(ebMerchant.getAvatar());
        }
        if (ebMerchant.isset_rectangleLogo) {
            this.setRectangleLogo(ebMerchant.getRectangleLogo());
        }
        if (ebMerchant.isset_coverImage) {
            this.setCoverImage(ebMerchant.getCoverImage());
        }
        if (ebMerchant.isset_streetBackImage) {
            this.setStreetBackImage(ebMerchant.getStreetBackImage());
        }
        if (ebMerchant.isset_intro) {
            this.setIntro(ebMerchant.getIntro());
        }
        if (ebMerchant.isset_copyProductNum) {
            this.setCopyProductNum(ebMerchant.getCopyProductNum());
        }
        if (ebMerchant.isset_balance) {
            this.setBalance(ebMerchant.getBalance());
        }
        if (ebMerchant.isset_starLevel) {
            this.setStarLevel(ebMerchant.getStarLevel());
        }
        if (ebMerchant.isset_pcBanner) {
            this.setPcBanner(ebMerchant.getPcBanner());
        }
        if (ebMerchant.isset_pcBackImage) {
            this.setPcBackImage(ebMerchant.getPcBackImage());
        }
        if (ebMerchant.isset_sort) {
            this.setSort(ebMerchant.getSort());
        }
        if (ebMerchant.isset_createType) {
            this.setCreateType(ebMerchant.getCreateType());
        }
        if (ebMerchant.isset_createId) {
            this.setCreateId(ebMerchant.getCreateId());
        }
        if (ebMerchant.isset_adminId) {
            this.setAdminId(ebMerchant.getAdminId());
        }
        if (ebMerchant.isset_isDel) {
            this.setIsDel(ebMerchant.getIsDel());
        }
        if (ebMerchant.isset_createTime) {
            this.setCreateTime(ebMerchant.getCreateTime());
        }
        if (ebMerchant.isset_updateTime) {
            this.setUpdateTime(ebMerchant.getUpdateTime());
        }
        if (ebMerchant.isset_uuid) {
            this.setUuid(ebMerchant.getUuid());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_merchant.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_merchant";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ib.set(TypeId, this.getTypeId(), this.isset_typeId);
        ib.set(RealName, this.getRealName(), this.isset_realName);
        ib.set(Email, this.getEmail(), this.isset_email);
        ib.set(Phone, this.getPhone(), this.isset_phone);
        ib.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ib.set(Keywords, this.getKeywords(), this.isset_keywords);
        ib.set(Province, this.getProvince(), this.isset_province);
        ib.set(City, this.getCity(), this.isset_city);
        ib.set(District, this.getDistrict(), this.isset_district);
        ib.set(AddressDetail, this.getAddressDetail(), this.isset_addressDetail);
        ib.set(Latitude, this.getLatitude(), this.isset_latitude);
        ib.set(Longitude, this.getLongitude(), this.isset_longitude);
        ib.set(IsSelf, this.getIsSelf(), this.isset_isSelf);
        ib.set(IsRecommend, this.getIsRecommend(), this.isset_isRecommend);
        ib.set(IsSwitch, this.getIsSwitch(), this.isset_isSwitch);
        ib.set(ProductSwitch, this.getProductSwitch(), this.isset_productSwitch);
        ib.set(IsTakeTheir, this.getIsTakeTheir(), this.isset_isTakeTheir);
        ib.set(Remark, this.getRemark(), this.isset_remark);
        ib.set(QualificationPicture, this.getQualificationPicture(), this.isset_qualificationPicture);
        ib.set(BackImage, this.getBackImage(), this.isset_backImage);
        ib.set(Avatar, this.getAvatar(), this.isset_avatar);
        ib.set(RectangleLogo, this.getRectangleLogo(), this.isset_rectangleLogo);
        ib.set(CoverImage, this.getCoverImage(), this.isset_coverImage);
        ib.set(StreetBackImage, this.getStreetBackImage(), this.isset_streetBackImage);
        ib.set(Intro, this.getIntro(), this.isset_intro);
        ib.set(CopyProductNum, this.getCopyProductNum(), this.isset_copyProductNum);
        ib.set(Balance, this.getBalance(), this.isset_balance);
        ib.set(StarLevel, this.getStarLevel(), this.isset_starLevel);
        ib.set(PcBanner, this.getPcBanner(), this.isset_pcBanner);
        ib.set(PcBackImage, this.getPcBackImage(), this.isset_pcBackImage);
        ib.set(Sort, this.getSort(), this.isset_sort);
        ib.set(CreateType, this.getCreateType(), this.isset_createType);
        ib.set(CreateId, this.getCreateId(), this.isset_createId);
        ib.set(AdminId, this.getAdminId(), this.isset_adminId);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ib.set(Uuid, this.getUuid(), this.isset_uuid);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(TypeId, this.getTypeId(), this.isset_typeId);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Email, this.getEmail(), this.isset_email);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(Keywords, this.getKeywords(), this.isset_keywords);
        ub.set(Province, this.getProvince(), this.isset_province);
        ub.set(City, this.getCity(), this.isset_city);
        ub.set(District, this.getDistrict(), this.isset_district);
        ub.set(AddressDetail, this.getAddressDetail(), this.isset_addressDetail);
        ub.set(Latitude, this.getLatitude(), this.isset_latitude);
        ub.set(Longitude, this.getLongitude(), this.isset_longitude);
        ub.set(IsSelf, this.getIsSelf(), this.isset_isSelf);
        ub.set(IsRecommend, this.getIsRecommend(), this.isset_isRecommend);
        ub.set(IsSwitch, this.getIsSwitch(), this.isset_isSwitch);
        ub.set(ProductSwitch, this.getProductSwitch(), this.isset_productSwitch);
        ub.set(IsTakeTheir, this.getIsTakeTheir(), this.isset_isTakeTheir);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(QualificationPicture, this.getQualificationPicture(), this.isset_qualificationPicture);
        ub.set(BackImage, this.getBackImage(), this.isset_backImage);
        ub.set(Avatar, this.getAvatar(), this.isset_avatar);
        ub.set(RectangleLogo, this.getRectangleLogo(), this.isset_rectangleLogo);
        ub.set(CoverImage, this.getCoverImage(), this.isset_coverImage);
        ub.set(StreetBackImage, this.getStreetBackImage(), this.isset_streetBackImage);
        ub.set(Intro, this.getIntro(), this.isset_intro);
        ub.set(CopyProductNum, this.getCopyProductNum(), this.isset_copyProductNum);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(StarLevel, this.getStarLevel(), this.isset_starLevel);
        ub.set(PcBanner, this.getPcBanner(), this.isset_pcBanner);
        ub.set(PcBackImage, this.getPcBackImage(), this.isset_pcBackImage);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(CreateType, this.getCreateType(), this.isset_createType);
        ub.set(CreateId, this.getCreateId(), this.isset_createId);
        ub.set(AdminId, this.getAdminId(), this.isset_adminId);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(Uuid, this.getUuid(), this.isset_uuid);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(TypeId, this.getTypeId(), this.isset_typeId);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Email, this.getEmail(), this.isset_email);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(Keywords, this.getKeywords(), this.isset_keywords);
        ub.set(Province, this.getProvince(), this.isset_province);
        ub.set(City, this.getCity(), this.isset_city);
        ub.set(District, this.getDistrict(), this.isset_district);
        ub.set(AddressDetail, this.getAddressDetail(), this.isset_addressDetail);
        ub.set(Latitude, this.getLatitude(), this.isset_latitude);
        ub.set(Longitude, this.getLongitude(), this.isset_longitude);
        ub.set(IsSelf, this.getIsSelf(), this.isset_isSelf);
        ub.set(IsRecommend, this.getIsRecommend(), this.isset_isRecommend);
        ub.set(IsSwitch, this.getIsSwitch(), this.isset_isSwitch);
        ub.set(ProductSwitch, this.getProductSwitch(), this.isset_productSwitch);
        ub.set(IsTakeTheir, this.getIsTakeTheir(), this.isset_isTakeTheir);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(QualificationPicture, this.getQualificationPicture(), this.isset_qualificationPicture);
        ub.set(BackImage, this.getBackImage(), this.isset_backImage);
        ub.set(Avatar, this.getAvatar(), this.isset_avatar);
        ub.set(RectangleLogo, this.getRectangleLogo(), this.isset_rectangleLogo);
        ub.set(CoverImage, this.getCoverImage(), this.isset_coverImage);
        ub.set(StreetBackImage, this.getStreetBackImage(), this.isset_streetBackImage);
        ub.set(Intro, this.getIntro(), this.isset_intro);
        ub.set(CopyProductNum, this.getCopyProductNum(), this.isset_copyProductNum);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(StarLevel, this.getStarLevel(), this.isset_starLevel);
        ub.set(PcBanner, this.getPcBanner(), this.isset_pcBanner);
        ub.set(PcBackImage, this.getPcBackImage(), this.isset_pcBackImage);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(CreateType, this.getCreateType(), this.isset_createType);
        ub.set(CreateId, this.getCreateId(), this.isset_createId);
        ub.set(AdminId, this.getAdminId(), this.isset_adminId);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(Uuid, this.getUuid(), this.isset_uuid);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(TypeId, this.getTypeId(), this.isset_typeId);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Email, this.getEmail(), this.isset_email);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(Keywords, this.getKeywords(), this.isset_keywords);
        ub.set(Province, this.getProvince(), this.isset_province);
        ub.set(City, this.getCity(), this.isset_city);
        ub.set(District, this.getDistrict(), this.isset_district);
        ub.set(AddressDetail, this.getAddressDetail(), this.isset_addressDetail);
        ub.set(Latitude, this.getLatitude(), this.isset_latitude);
        ub.set(Longitude, this.getLongitude(), this.isset_longitude);
        ub.set(IsSelf, this.getIsSelf(), this.isset_isSelf);
        ub.set(IsRecommend, this.getIsRecommend(), this.isset_isRecommend);
        ub.set(IsSwitch, this.getIsSwitch(), this.isset_isSwitch);
        ub.set(ProductSwitch, this.getProductSwitch(), this.isset_productSwitch);
        ub.set(IsTakeTheir, this.getIsTakeTheir(), this.isset_isTakeTheir);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(QualificationPicture, this.getQualificationPicture(), this.isset_qualificationPicture);
        ub.set(BackImage, this.getBackImage(), this.isset_backImage);
        ub.set(Avatar, this.getAvatar(), this.isset_avatar);
        ub.set(RectangleLogo, this.getRectangleLogo(), this.isset_rectangleLogo);
        ub.set(CoverImage, this.getCoverImage(), this.isset_coverImage);
        ub.set(StreetBackImage, this.getStreetBackImage(), this.isset_streetBackImage);
        ub.set(Intro, this.getIntro(), this.isset_intro);
        ub.set(CopyProductNum, this.getCopyProductNum(), this.isset_copyProductNum);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(StarLevel, this.getStarLevel(), this.isset_starLevel);
        ub.set(PcBanner, this.getPcBanner(), this.isset_pcBanner);
        ub.set(PcBackImage, this.getPcBackImage(), this.isset_pcBackImage);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(CreateType, this.getCreateType(), this.isset_createType);
        ub.set(CreateId, this.getCreateId(), this.isset_createId);
        ub.set(AdminId, this.getAdminId(), this.isset_adminId);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(Uuid, this.getUuid(), this.isset_uuid);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, name, category_id, type_id, real_name, email, phone, handling_fee, keywords, province, city, district, address_detail, latitude, longitude, is_self, is_recommend, is_switch, product_switch, is_take_their, remark, qualification_picture, back_image, avatar, rectangle_logo, cover_image, street_back_image, intro, copy_product_num, balance, star_level, pc_banner, pc_back_image, sort, create_type, create_id, admin_id, is_del, create_time, update_time, uuid from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, name, category_id, type_id, real_name, email, phone, handling_fee, keywords, province, city, district, address_detail, latitude, longitude, is_self, is_recommend, is_switch, product_switch, is_take_their, remark, qualification_picture, back_image, avatar, rectangle_logo, cover_image, street_back_image, intro, copy_product_num, balance, star_level, pc_banner, pc_back_image, sort, create_type, create_id, admin_id, is_del, create_time, update_time, uuid from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbMerchant mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbMerchant toEbMerchant() {
        return super.$clone();
    }
}

/**
 * eb_merchant RowMapper
 *
 * @author genrator
 */
class EbMerchantRowMapper implements RowMapper<EbMerchant> {

    @Override
    public EbMerchant mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbMerchant eb_merchant = new EbMerchant();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Id);
        if (columnIndex > 0) {
            eb_merchant.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Name);
        if (columnIndex > 0) {
            eb_merchant.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.CategoryId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setCategoryId(null);
            } else {
                eb_merchant.setCategoryId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.TypeId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setTypeId(null);
            } else {
                eb_merchant.setTypeId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.RealName);
        if (columnIndex > 0) {
            eb_merchant.setRealName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Email);
        if (columnIndex > 0) {
            eb_merchant.setEmail(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Phone);
        if (columnIndex > 0) {
            eb_merchant.setPhone(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.HandlingFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setHandlingFee(null);
            } else {
                eb_merchant.setHandlingFee(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Keywords);
        if (columnIndex > 0) {
            eb_merchant.setKeywords(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Province);
        if (columnIndex > 0) {
            eb_merchant.setProvince(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.City);
        if (columnIndex > 0) {
            eb_merchant.setCity(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.District);
        if (columnIndex > 0) {
            eb_merchant.setDistrict(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.AddressDetail);
        if (columnIndex > 0) {
            eb_merchant.setAddressDetail(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Latitude);
        if (columnIndex > 0) {
            eb_merchant.setLatitude(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Longitude);
        if (columnIndex > 0) {
            eb_merchant.setLongitude(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.IsSelf);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setIsSelf(null);
            } else {
                eb_merchant.setIsSelf(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.IsRecommend);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setIsRecommend(null);
            } else {
                eb_merchant.setIsRecommend(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.IsSwitch);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setIsSwitch(null);
            } else {
                eb_merchant.setIsSwitch(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.ProductSwitch);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setProductSwitch(null);
            } else {
                eb_merchant.setProductSwitch(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.IsTakeTheir);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setIsTakeTheir(null);
            } else {
                eb_merchant.setIsTakeTheir(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Remark);
        if (columnIndex > 0) {
            eb_merchant.setRemark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.QualificationPicture);
        if (columnIndex > 0) {
            eb_merchant.setQualificationPicture(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.BackImage);
        if (columnIndex > 0) {
            eb_merchant.setBackImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Avatar);
        if (columnIndex > 0) {
            eb_merchant.setAvatar(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.RectangleLogo);
        if (columnIndex > 0) {
            eb_merchant.setRectangleLogo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.CoverImage);
        if (columnIndex > 0) {
            eb_merchant.setCoverImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.StreetBackImage);
        if (columnIndex > 0) {
            eb_merchant.setStreetBackImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Intro);
        if (columnIndex > 0) {
            eb_merchant.setIntro(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.CopyProductNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setCopyProductNum(null);
            } else {
                eb_merchant.setCopyProductNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Balance);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setBalance(null);
            } else {
                eb_merchant.setBalance(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.StarLevel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setStarLevel(null);
            } else {
                eb_merchant.setStarLevel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.PcBanner);
        if (columnIndex > 0) {
            eb_merchant.setPcBanner(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.PcBackImage);
        if (columnIndex > 0) {
            eb_merchant.setPcBackImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Sort);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setSort(null);
            } else {
                eb_merchant.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.CreateType);
        if (columnIndex > 0) {
            eb_merchant.setCreateType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.CreateId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setCreateId(null);
            } else {
                eb_merchant.setCreateId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.AdminId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setAdminId(null);
            } else {
                eb_merchant.setAdminId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setIsDel(null);
            } else {
                eb_merchant.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setCreateTime(null);
            } else {
                eb_merchant.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant.setUpdateTime(null);
            } else {
                eb_merchant.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchant_mapper.Uuid);
        if (columnIndex > 0) {
            eb_merchant.setUuid(rs.getString(columnIndex));
        }
        return eb_merchant;
    }
}
