package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_ORDER_DETAIL *
 * @author genrator
 */
public class EbOrderDetail_mapper extends EbOrderDetail implements BaseMapper<EbOrderDetail> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbOrderDetail> ROW_MAPPER = new EbOrderDetailRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String OrderNo = "order_no";
    public static final String MerId = "mer_id";
    public static final String Uid = "uid";
    public static final String ProductId = "product_id";
    public static final String ProductName = "product_name";
    public static final String Image = "image";
    public static final String AttrValueId = "attr_value_id";
    public static final String Sku = "sku";
    public static final String Price = "price";
    public static final String VipPrice = "vip_price";
    public static final String PayPrice = "pay_price";
    public static final String PayNum = "pay_num";
    public static final String Weight = "weight";
    public static final String Volume = "volume";
    public static final String IsReply = "is_reply";
    public static final String IsReceipt = "is_receipt";
    public static final String SubBrokerageType = "sub_brokerage_type";
    public static final String Brokerage = "brokerage";
    public static final String BrokerageTwo = "brokerage_two";
    public static final String FreightFee = "freight_fee";
    public static final String CouponPrice = "coupon_price";
    public static final String UseIntegral = "use_integral";
    public static final String IntegralPrice = "integral_price";
    public static final String GainIntegral = "gain_integral";
    public static final String ProductType = "product_type";
    public static final String FirstBrokerageFee = "first_brokerage_fee";
    public static final String SecondBrokerageFee = "second_brokerage_fee";
    public static final String DeliveryNum = "delivery_num";
    public static final String ApplyRefundNum = "apply_refund_num";
    public static final String RefundNum = "refund_num";
    public static final String RefundPrice = "refund_price";
    public static final String RefundUseIntegral = "refund_use_integral";
    public static final String RefundIntegralPrice = "refund_integral_price";
    public static final String RefundGainIntegral = "refund_gain_integral";
    public static final String RefundFirstBrokerageFee = "refund_first_brokerage_fee";
    public static final String RefundSecondBrokerageFee = "refund_second_brokerage_fee";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbOrderDetail_mapper(EbOrderDetail ebOrderDetail) {
        if (ebOrderDetail == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebOrderDetail.isset_id) {
            this.setId(ebOrderDetail.getId());
        }
        //普通属性
        if (ebOrderDetail.isset_orderNo) {
            this.setOrderNo(ebOrderDetail.getOrderNo());
        }
        if (ebOrderDetail.isset_merId) {
            this.setMerId(ebOrderDetail.getMerId());
        }
        if (ebOrderDetail.isset_uid) {
            this.setUid(ebOrderDetail.getUid());
        }
        if (ebOrderDetail.isset_productId) {
            this.setProductId(ebOrderDetail.getProductId());
        }
        if (ebOrderDetail.isset_productName) {
            this.setProductName(ebOrderDetail.getProductName());
        }
        if (ebOrderDetail.isset_image) {
            this.setImage(ebOrderDetail.getImage());
        }
        if (ebOrderDetail.isset_attrValueId) {
            this.setAttrValueId(ebOrderDetail.getAttrValueId());
        }
        if (ebOrderDetail.isset_sku) {
            this.setSku(ebOrderDetail.getSku());
        }
        if (ebOrderDetail.isset_price) {
            this.setPrice(ebOrderDetail.getPrice());
        }
        if (ebOrderDetail.isset_vipPrice) {
            this.setVipPrice(ebOrderDetail.getVipPrice());
        }
        if (ebOrderDetail.isset_payPrice) {
            this.setPayPrice(ebOrderDetail.getPayPrice());
        }
        if (ebOrderDetail.isset_payNum) {
            this.setPayNum(ebOrderDetail.getPayNum());
        }
        if (ebOrderDetail.isset_weight) {
            this.setWeight(ebOrderDetail.getWeight());
        }
        if (ebOrderDetail.isset_volume) {
            this.setVolume(ebOrderDetail.getVolume());
        }
        if (ebOrderDetail.isset_isReply) {
            this.setIsReply(ebOrderDetail.getIsReply());
        }
        if (ebOrderDetail.isset_isReceipt) {
            this.setIsReceipt(ebOrderDetail.getIsReceipt());
        }
        if (ebOrderDetail.isset_subBrokerageType) {
            this.setSubBrokerageType(ebOrderDetail.getSubBrokerageType());
        }
        if (ebOrderDetail.isset_brokerage) {
            this.setBrokerage(ebOrderDetail.getBrokerage());
        }
        if (ebOrderDetail.isset_brokerageTwo) {
            this.setBrokerageTwo(ebOrderDetail.getBrokerageTwo());
        }
        if (ebOrderDetail.isset_freightFee) {
            this.setFreightFee(ebOrderDetail.getFreightFee());
        }
        if (ebOrderDetail.isset_couponPrice) {
            this.setCouponPrice(ebOrderDetail.getCouponPrice());
        }
        if (ebOrderDetail.isset_useIntegral) {
            this.setUseIntegral(ebOrderDetail.getUseIntegral());
        }
        if (ebOrderDetail.isset_integralPrice) {
            this.setIntegralPrice(ebOrderDetail.getIntegralPrice());
        }
        if (ebOrderDetail.isset_gainIntegral) {
            this.setGainIntegral(ebOrderDetail.getGainIntegral());
        }
        if (ebOrderDetail.isset_productType) {
            this.setProductType(ebOrderDetail.getProductType());
        }
        if (ebOrderDetail.isset_firstBrokerageFee) {
            this.setFirstBrokerageFee(ebOrderDetail.getFirstBrokerageFee());
        }
        if (ebOrderDetail.isset_secondBrokerageFee) {
            this.setSecondBrokerageFee(ebOrderDetail.getSecondBrokerageFee());
        }
        if (ebOrderDetail.isset_deliveryNum) {
            this.setDeliveryNum(ebOrderDetail.getDeliveryNum());
        }
        if (ebOrderDetail.isset_applyRefundNum) {
            this.setApplyRefundNum(ebOrderDetail.getApplyRefundNum());
        }
        if (ebOrderDetail.isset_refundNum) {
            this.setRefundNum(ebOrderDetail.getRefundNum());
        }
        if (ebOrderDetail.isset_refundPrice) {
            this.setRefundPrice(ebOrderDetail.getRefundPrice());
        }
        if (ebOrderDetail.isset_refundUseIntegral) {
            this.setRefundUseIntegral(ebOrderDetail.getRefundUseIntegral());
        }
        if (ebOrderDetail.isset_refundIntegralPrice) {
            this.setRefundIntegralPrice(ebOrderDetail.getRefundIntegralPrice());
        }
        if (ebOrderDetail.isset_refundGainIntegral) {
            this.setRefundGainIntegral(ebOrderDetail.getRefundGainIntegral());
        }
        if (ebOrderDetail.isset_refundFirstBrokerageFee) {
            this.setRefundFirstBrokerageFee(ebOrderDetail.getRefundFirstBrokerageFee());
        }
        if (ebOrderDetail.isset_refundSecondBrokerageFee) {
            this.setRefundSecondBrokerageFee(ebOrderDetail.getRefundSecondBrokerageFee());
        }
        if (ebOrderDetail.isset_createTime) {
            this.setCreateTime(ebOrderDetail.getCreateTime());
        }
        if (ebOrderDetail.isset_updateTime) {
            this.setUpdateTime(ebOrderDetail.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_order_detail.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_order_detail";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(ProductName, this.getProductName(), this.isset_productName);
        ib.set(Image, this.getImage(), this.isset_image);
        ib.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ib.set(Sku, this.getSku(), this.isset_sku);
        ib.set(Price, this.getPrice(), this.isset_price);
        ib.set(VipPrice, this.getVipPrice(), this.isset_vipPrice);
        ib.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ib.set(PayNum, this.getPayNum(), this.isset_payNum);
        ib.set(Weight, this.getWeight(), this.isset_weight);
        ib.set(Volume, this.getVolume(), this.isset_volume);
        ib.set(IsReply, this.getIsReply(), this.isset_isReply);
        ib.set(IsReceipt, this.getIsReceipt(), this.isset_isReceipt);
        ib.set(SubBrokerageType, this.getSubBrokerageType(), this.isset_subBrokerageType);
        ib.set(Brokerage, this.getBrokerage(), this.isset_brokerage);
        ib.set(BrokerageTwo, this.getBrokerageTwo(), this.isset_brokerageTwo);
        ib.set(FreightFee, this.getFreightFee(), this.isset_freightFee);
        ib.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ib.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ib.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ib.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ib.set(ProductType, this.getProductType(), this.isset_productType);
        ib.set(FirstBrokerageFee, this.getFirstBrokerageFee(), this.isset_firstBrokerageFee);
        ib.set(SecondBrokerageFee, this.getSecondBrokerageFee(), this.isset_secondBrokerageFee);
        ib.set(DeliveryNum, this.getDeliveryNum(), this.isset_deliveryNum);
        ib.set(ApplyRefundNum, this.getApplyRefundNum(), this.isset_applyRefundNum);
        ib.set(RefundNum, this.getRefundNum(), this.isset_refundNum);
        ib.set(RefundPrice, this.getRefundPrice(), this.isset_refundPrice);
        ib.set(RefundUseIntegral, this.getRefundUseIntegral(), this.isset_refundUseIntegral);
        ib.set(RefundIntegralPrice, this.getRefundIntegralPrice(), this.isset_refundIntegralPrice);
        ib.set(RefundGainIntegral, this.getRefundGainIntegral(), this.isset_refundGainIntegral);
        ib.set(RefundFirstBrokerageFee, this.getRefundFirstBrokerageFee(), this.isset_refundFirstBrokerageFee);
        ib.set(RefundSecondBrokerageFee, this.getRefundSecondBrokerageFee(), this.isset_refundSecondBrokerageFee);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(ProductName, this.getProductName(), this.isset_productName);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(VipPrice, this.getVipPrice(), this.isset_vipPrice);
        ub.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ub.set(PayNum, this.getPayNum(), this.isset_payNum);
        ub.set(Weight, this.getWeight(), this.isset_weight);
        ub.set(Volume, this.getVolume(), this.isset_volume);
        ub.set(IsReply, this.getIsReply(), this.isset_isReply);
        ub.set(IsReceipt, this.getIsReceipt(), this.isset_isReceipt);
        ub.set(SubBrokerageType, this.getSubBrokerageType(), this.isset_subBrokerageType);
        ub.set(Brokerage, this.getBrokerage(), this.isset_brokerage);
        ub.set(BrokerageTwo, this.getBrokerageTwo(), this.isset_brokerageTwo);
        ub.set(FreightFee, this.getFreightFee(), this.isset_freightFee);
        ub.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ub.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ub.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ub.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ub.set(ProductType, this.getProductType(), this.isset_productType);
        ub.set(FirstBrokerageFee, this.getFirstBrokerageFee(), this.isset_firstBrokerageFee);
        ub.set(SecondBrokerageFee, this.getSecondBrokerageFee(), this.isset_secondBrokerageFee);
        ub.set(DeliveryNum, this.getDeliveryNum(), this.isset_deliveryNum);
        ub.set(ApplyRefundNum, this.getApplyRefundNum(), this.isset_applyRefundNum);
        ub.set(RefundNum, this.getRefundNum(), this.isset_refundNum);
        ub.set(RefundPrice, this.getRefundPrice(), this.isset_refundPrice);
        ub.set(RefundUseIntegral, this.getRefundUseIntegral(), this.isset_refundUseIntegral);
        ub.set(RefundIntegralPrice, this.getRefundIntegralPrice(), this.isset_refundIntegralPrice);
        ub.set(RefundGainIntegral, this.getRefundGainIntegral(), this.isset_refundGainIntegral);
        ub.set(RefundFirstBrokerageFee, this.getRefundFirstBrokerageFee(), this.isset_refundFirstBrokerageFee);
        ub.set(RefundSecondBrokerageFee, this.getRefundSecondBrokerageFee(), this.isset_refundSecondBrokerageFee);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(ProductName, this.getProductName(), this.isset_productName);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(VipPrice, this.getVipPrice(), this.isset_vipPrice);
        ub.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ub.set(PayNum, this.getPayNum(), this.isset_payNum);
        ub.set(Weight, this.getWeight(), this.isset_weight);
        ub.set(Volume, this.getVolume(), this.isset_volume);
        ub.set(IsReply, this.getIsReply(), this.isset_isReply);
        ub.set(IsReceipt, this.getIsReceipt(), this.isset_isReceipt);
        ub.set(SubBrokerageType, this.getSubBrokerageType(), this.isset_subBrokerageType);
        ub.set(Brokerage, this.getBrokerage(), this.isset_brokerage);
        ub.set(BrokerageTwo, this.getBrokerageTwo(), this.isset_brokerageTwo);
        ub.set(FreightFee, this.getFreightFee(), this.isset_freightFee);
        ub.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ub.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ub.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ub.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ub.set(ProductType, this.getProductType(), this.isset_productType);
        ub.set(FirstBrokerageFee, this.getFirstBrokerageFee(), this.isset_firstBrokerageFee);
        ub.set(SecondBrokerageFee, this.getSecondBrokerageFee(), this.isset_secondBrokerageFee);
        ub.set(DeliveryNum, this.getDeliveryNum(), this.isset_deliveryNum);
        ub.set(ApplyRefundNum, this.getApplyRefundNum(), this.isset_applyRefundNum);
        ub.set(RefundNum, this.getRefundNum(), this.isset_refundNum);
        ub.set(RefundPrice, this.getRefundPrice(), this.isset_refundPrice);
        ub.set(RefundUseIntegral, this.getRefundUseIntegral(), this.isset_refundUseIntegral);
        ub.set(RefundIntegralPrice, this.getRefundIntegralPrice(), this.isset_refundIntegralPrice);
        ub.set(RefundGainIntegral, this.getRefundGainIntegral(), this.isset_refundGainIntegral);
        ub.set(RefundFirstBrokerageFee, this.getRefundFirstBrokerageFee(), this.isset_refundFirstBrokerageFee);
        ub.set(RefundSecondBrokerageFee, this.getRefundSecondBrokerageFee(), this.isset_refundSecondBrokerageFee);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(ProductName, this.getProductName(), this.isset_productName);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(VipPrice, this.getVipPrice(), this.isset_vipPrice);
        ub.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ub.set(PayNum, this.getPayNum(), this.isset_payNum);
        ub.set(Weight, this.getWeight(), this.isset_weight);
        ub.set(Volume, this.getVolume(), this.isset_volume);
        ub.set(IsReply, this.getIsReply(), this.isset_isReply);
        ub.set(IsReceipt, this.getIsReceipt(), this.isset_isReceipt);
        ub.set(SubBrokerageType, this.getSubBrokerageType(), this.isset_subBrokerageType);
        ub.set(Brokerage, this.getBrokerage(), this.isset_brokerage);
        ub.set(BrokerageTwo, this.getBrokerageTwo(), this.isset_brokerageTwo);
        ub.set(FreightFee, this.getFreightFee(), this.isset_freightFee);
        ub.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ub.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ub.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ub.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ub.set(ProductType, this.getProductType(), this.isset_productType);
        ub.set(FirstBrokerageFee, this.getFirstBrokerageFee(), this.isset_firstBrokerageFee);
        ub.set(SecondBrokerageFee, this.getSecondBrokerageFee(), this.isset_secondBrokerageFee);
        ub.set(DeliveryNum, this.getDeliveryNum(), this.isset_deliveryNum);
        ub.set(ApplyRefundNum, this.getApplyRefundNum(), this.isset_applyRefundNum);
        ub.set(RefundNum, this.getRefundNum(), this.isset_refundNum);
        ub.set(RefundPrice, this.getRefundPrice(), this.isset_refundPrice);
        ub.set(RefundUseIntegral, this.getRefundUseIntegral(), this.isset_refundUseIntegral);
        ub.set(RefundIntegralPrice, this.getRefundIntegralPrice(), this.isset_refundIntegralPrice);
        ub.set(RefundGainIntegral, this.getRefundGainIntegral(), this.isset_refundGainIntegral);
        ub.set(RefundFirstBrokerageFee, this.getRefundFirstBrokerageFee(), this.isset_refundFirstBrokerageFee);
        ub.set(RefundSecondBrokerageFee, this.getRefundSecondBrokerageFee(), this.isset_refundSecondBrokerageFee);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, order_no, mer_id, uid, product_id, product_name, image, attr_value_id, sku, price, vip_price, pay_price, pay_num, weight, volume, is_reply, is_receipt, sub_brokerage_type, brokerage, brokerage_two, freight_fee, coupon_price, use_integral, integral_price, gain_integral, product_type, first_brokerage_fee, second_brokerage_fee, delivery_num, apply_refund_num, refund_num, refund_price, refund_use_integral, refund_integral_price, refund_gain_integral, refund_first_brokerage_fee, refund_second_brokerage_fee, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, order_no, mer_id, uid, product_id, product_name, image, attr_value_id, sku, price, vip_price, pay_price, pay_num, weight, volume, is_reply, is_receipt, sub_brokerage_type, brokerage, brokerage_two, freight_fee, coupon_price, use_integral, integral_price, gain_integral, product_type, first_brokerage_fee, second_brokerage_fee, delivery_num, apply_refund_num, refund_num, refund_price, refund_use_integral, refund_integral_price, refund_gain_integral, refund_first_brokerage_fee, refund_second_brokerage_fee, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbOrderDetail mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbOrderDetail toEbOrderDetail() {
        return super.$clone();
    }
}

/**
 * eb_order_detail RowMapper
 *
 * @author genrator
 */
class EbOrderDetailRowMapper implements RowMapper<EbOrderDetail> {

    @Override
    public EbOrderDetail mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbOrderDetail eb_order_detail = new EbOrderDetail();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.Id);
        if (columnIndex > 0) {
            eb_order_detail.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.OrderNo);
        if (columnIndex > 0) {
            eb_order_detail.setOrderNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setMerId(null);
            } else {
                eb_order_detail.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setUid(null);
            } else {
                eb_order_detail.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.ProductId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setProductId(null);
            } else {
                eb_order_detail.setProductId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.ProductName);
        if (columnIndex > 0) {
            eb_order_detail.setProductName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.Image);
        if (columnIndex > 0) {
            eb_order_detail.setImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.AttrValueId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setAttrValueId(null);
            } else {
                eb_order_detail.setAttrValueId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.Sku);
        if (columnIndex > 0) {
            eb_order_detail.setSku(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.Price);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setPrice(null);
            } else {
                eb_order_detail.setPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.VipPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setVipPrice(null);
            } else {
                eb_order_detail.setVipPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.PayPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setPayPrice(null);
            } else {
                eb_order_detail.setPayPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.PayNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setPayNum(null);
            } else {
                eb_order_detail.setPayNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.Weight);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setWeight(null);
            } else {
                eb_order_detail.setWeight(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.Volume);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setVolume(null);
            } else {
                eb_order_detail.setVolume(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.IsReply);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setIsReply(null);
            } else {
                eb_order_detail.setIsReply(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.IsReceipt);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setIsReceipt(null);
            } else {
                eb_order_detail.setIsReceipt(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.SubBrokerageType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setSubBrokerageType(null);
            } else {
                eb_order_detail.setSubBrokerageType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.Brokerage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setBrokerage(null);
            } else {
                eb_order_detail.setBrokerage(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.BrokerageTwo);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setBrokerageTwo(null);
            } else {
                eb_order_detail.setBrokerageTwo(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.FreightFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setFreightFee(null);
            } else {
                eb_order_detail.setFreightFee(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.CouponPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setCouponPrice(null);
            } else {
                eb_order_detail.setCouponPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.UseIntegral);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setUseIntegral(null);
            } else {
                eb_order_detail.setUseIntegral(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.IntegralPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setIntegralPrice(null);
            } else {
                eb_order_detail.setIntegralPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.GainIntegral);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setGainIntegral(null);
            } else {
                eb_order_detail.setGainIntegral(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.ProductType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setProductType(null);
            } else {
                eb_order_detail.setProductType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.FirstBrokerageFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setFirstBrokerageFee(null);
            } else {
                eb_order_detail.setFirstBrokerageFee(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.SecondBrokerageFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setSecondBrokerageFee(null);
            } else {
                eb_order_detail.setSecondBrokerageFee(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.DeliveryNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setDeliveryNum(null);
            } else {
                eb_order_detail.setDeliveryNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.ApplyRefundNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setApplyRefundNum(null);
            } else {
                eb_order_detail.setApplyRefundNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.RefundNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setRefundNum(null);
            } else {
                eb_order_detail.setRefundNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.RefundPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setRefundPrice(null);
            } else {
                eb_order_detail.setRefundPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.RefundUseIntegral);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setRefundUseIntegral(null);
            } else {
                eb_order_detail.setRefundUseIntegral(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.RefundIntegralPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setRefundIntegralPrice(null);
            } else {
                eb_order_detail.setRefundIntegralPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.RefundGainIntegral);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setRefundGainIntegral(null);
            } else {
                eb_order_detail.setRefundGainIntegral(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.RefundFirstBrokerageFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setRefundFirstBrokerageFee(null);
            } else {
                eb_order_detail.setRefundFirstBrokerageFee(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.RefundSecondBrokerageFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setRefundSecondBrokerageFee(null);
            } else {
                eb_order_detail.setRefundSecondBrokerageFee(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setCreateTime(null);
            } else {
                eb_order_detail.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderDetail_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_detail.setUpdateTime(null);
            } else {
                eb_order_detail.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_order_detail;
    }
}
