package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_ORDER_INVOICE *
 * @author genrator
 */
public class EbOrderInvoice_mapper extends EbOrderInvoice implements BaseMapper<EbOrderInvoice> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbOrderInvoice> ROW_MAPPER = new EbOrderInvoiceRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String OrderNo = "order_no";
    public static final String MerId = "mer_id";
    public static final String Uid = "uid";
    public static final String TrackingNumber = "tracking_number";
    public static final String ExpressName = "express_name";
    public static final String ExpressCode = "express_code";
    public static final String TotalNum = "total_num";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbOrderInvoice_mapper(EbOrderInvoice ebOrderInvoice) {
        if (ebOrderInvoice == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebOrderInvoice.isset_id) {
            this.setId(ebOrderInvoice.getId());
        }
        //普通属性
        if (ebOrderInvoice.isset_orderNo) {
            this.setOrderNo(ebOrderInvoice.getOrderNo());
        }
        if (ebOrderInvoice.isset_merId) {
            this.setMerId(ebOrderInvoice.getMerId());
        }
        if (ebOrderInvoice.isset_uid) {
            this.setUid(ebOrderInvoice.getUid());
        }
        if (ebOrderInvoice.isset_trackingNumber) {
            this.setTrackingNumber(ebOrderInvoice.getTrackingNumber());
        }
        if (ebOrderInvoice.isset_expressName) {
            this.setExpressName(ebOrderInvoice.getExpressName());
        }
        if (ebOrderInvoice.isset_expressCode) {
            this.setExpressCode(ebOrderInvoice.getExpressCode());
        }
        if (ebOrderInvoice.isset_totalNum) {
            this.setTotalNum(ebOrderInvoice.getTotalNum());
        }
        if (ebOrderInvoice.isset_createTime) {
            this.setCreateTime(ebOrderInvoice.getCreateTime());
        }
        if (ebOrderInvoice.isset_updateTime) {
            this.setUpdateTime(ebOrderInvoice.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_order_invoice.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_order_invoice";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(TrackingNumber, this.getTrackingNumber(), this.isset_trackingNumber);
        ib.set(ExpressName, this.getExpressName(), this.isset_expressName);
        ib.set(ExpressCode, this.getExpressCode(), this.isset_expressCode);
        ib.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(TrackingNumber, this.getTrackingNumber(), this.isset_trackingNumber);
        ub.set(ExpressName, this.getExpressName(), this.isset_expressName);
        ub.set(ExpressCode, this.getExpressCode(), this.isset_expressCode);
        ub.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(TrackingNumber, this.getTrackingNumber(), this.isset_trackingNumber);
        ub.set(ExpressName, this.getExpressName(), this.isset_expressName);
        ub.set(ExpressCode, this.getExpressCode(), this.isset_expressCode);
        ub.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(TrackingNumber, this.getTrackingNumber(), this.isset_trackingNumber);
        ub.set(ExpressName, this.getExpressName(), this.isset_expressName);
        ub.set(ExpressCode, this.getExpressCode(), this.isset_expressCode);
        ub.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, order_no, mer_id, uid, tracking_number, express_name, express_code, total_num, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, order_no, mer_id, uid, tracking_number, express_name, express_code, total_num, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbOrderInvoice mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbOrderInvoice toEbOrderInvoice() {
        return super.$clone();
    }
}

/**
 * eb_order_invoice RowMapper
 *
 * @author genrator
 */
class EbOrderInvoiceRowMapper implements RowMapper<EbOrderInvoice> {

    @Override
    public EbOrderInvoice mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbOrderInvoice eb_order_invoice = new EbOrderInvoice();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.Id);
        if (columnIndex > 0) {
            eb_order_invoice.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.OrderNo);
        if (columnIndex > 0) {
            eb_order_invoice.setOrderNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice.setMerId(null);
            } else {
                eb_order_invoice.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice.setUid(null);
            } else {
                eb_order_invoice.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.TrackingNumber);
        if (columnIndex > 0) {
            eb_order_invoice.setTrackingNumber(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.ExpressName);
        if (columnIndex > 0) {
            eb_order_invoice.setExpressName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.ExpressCode);
        if (columnIndex > 0) {
            eb_order_invoice.setExpressCode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.TotalNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice.setTotalNum(null);
            } else {
                eb_order_invoice.setTotalNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice.setCreateTime(null);
            } else {
                eb_order_invoice.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoice_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice.setUpdateTime(null);
            } else {
                eb_order_invoice.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_order_invoice;
    }
}
