package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_PRODUCT_ATTR_VALUE *
 * @author genrator
 */
public class EbProductAttrValue_mapper extends EbProductAttrValue implements BaseMapper<EbProductAttrValue> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbProductAttrValue> ROW_MAPPER = new EbProductAttrValueRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String ProductId = "product_id";
    public static final String Sku = "sku";
    public static final String Stock = "stock";
    public static final String Sales = "sales";
    public static final String Price = "price";
    public static final String Image = "image";
    public static final String Cost = "cost";
    public static final String BarCode = "bar_code";
    public static final String OtPrice = "ot_price";
    public static final String Weight = "weight";
    public static final String Volume = "volume";
    public static final String Brokerage = "brokerage";
    public static final String BrokerageTwo = "brokerage_two";
    public static final String Type = "type";
    public static final String Quota = "quota";
    public static final String QuotaShow = "quota_show";
    public static final String AttrValue = "attr_value";
    public static final String IsDel = "is_del";
    public static final String Version = "version";
    public static final String MasterId = "master_id";
    public static final String IsCallback = "is_callback";

    /**
     * 默认构造函数
     */
    public EbProductAttrValue_mapper(EbProductAttrValue ebProductAttrValue) {
        if (ebProductAttrValue == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebProductAttrValue.isset_id) {
            this.setId(ebProductAttrValue.getId());
        }
        //普通属性
        if (ebProductAttrValue.isset_productId) {
            this.setProductId(ebProductAttrValue.getProductId());
        }
        if (ebProductAttrValue.isset_sku) {
            this.setSku(ebProductAttrValue.getSku());
        }
        if (ebProductAttrValue.isset_stock) {
            this.setStock(ebProductAttrValue.getStock());
        }
        if (ebProductAttrValue.isset_sales) {
            this.setSales(ebProductAttrValue.getSales());
        }
        if (ebProductAttrValue.isset_price) {
            this.setPrice(ebProductAttrValue.getPrice());
        }
        if (ebProductAttrValue.isset_image) {
            this.setImage(ebProductAttrValue.getImage());
        }
        if (ebProductAttrValue.isset_cost) {
            this.setCost(ebProductAttrValue.getCost());
        }
        if (ebProductAttrValue.isset_barCode) {
            this.setBarCode(ebProductAttrValue.getBarCode());
        }
        if (ebProductAttrValue.isset_otPrice) {
            this.setOtPrice(ebProductAttrValue.getOtPrice());
        }
        if (ebProductAttrValue.isset_weight) {
            this.setWeight(ebProductAttrValue.getWeight());
        }
        if (ebProductAttrValue.isset_volume) {
            this.setVolume(ebProductAttrValue.getVolume());
        }
        if (ebProductAttrValue.isset_brokerage) {
            this.setBrokerage(ebProductAttrValue.getBrokerage());
        }
        if (ebProductAttrValue.isset_brokerageTwo) {
            this.setBrokerageTwo(ebProductAttrValue.getBrokerageTwo());
        }
        if (ebProductAttrValue.isset_type) {
            this.setType(ebProductAttrValue.getType());
        }
        if (ebProductAttrValue.isset_quota) {
            this.setQuota(ebProductAttrValue.getQuota());
        }
        if (ebProductAttrValue.isset_quotaShow) {
            this.setQuotaShow(ebProductAttrValue.getQuotaShow());
        }
        if (ebProductAttrValue.isset_attrValue) {
            this.setAttrValue(ebProductAttrValue.getAttrValue());
        }
        if (ebProductAttrValue.isset_isDel) {
            this.setIsDel(ebProductAttrValue.getIsDel());
        }
        if (ebProductAttrValue.isset_version) {
            this.setVersion(ebProductAttrValue.getVersion());
        }
        if (ebProductAttrValue.isset_masterId) {
            this.setMasterId(ebProductAttrValue.getMasterId());
        }
        if (ebProductAttrValue.isset_isCallback) {
            this.setIsCallback(ebProductAttrValue.getIsCallback());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_product_attr_value.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_product_attr_value";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(Sku, this.getSku(), this.isset_sku);
        ib.set(Stock, this.getStock(), this.isset_stock);
        ib.set(Sales, this.getSales(), this.isset_sales);
        ib.set(Price, this.getPrice(), this.isset_price);
        ib.set(Image, this.getImage(), this.isset_image);
        ib.set(Cost, this.getCost(), this.isset_cost);
        ib.set(BarCode, this.getBarCode(), this.isset_barCode);
        ib.set(OtPrice, this.getOtPrice(), this.isset_otPrice);
        ib.set(Weight, this.getWeight(), this.isset_weight);
        ib.set(Volume, this.getVolume(), this.isset_volume);
        ib.set(Brokerage, this.getBrokerage(), this.isset_brokerage);
        ib.set(BrokerageTwo, this.getBrokerageTwo(), this.isset_brokerageTwo);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(Quota, this.getQuota(), this.isset_quota);
        ib.set(QuotaShow, this.getQuotaShow(), this.isset_quotaShow);
        ib.set(AttrValue, this.getAttrValue(), this.isset_attrValue);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(Version, this.getVersion(), this.isset_version);
        ib.set(MasterId, this.getMasterId(), this.isset_masterId);
        ib.set(IsCallback, this.getIsCallback(), this.isset_isCallback);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Stock, this.getStock(), this.isset_stock);
        ub.set(Sales, this.getSales(), this.isset_sales);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(Cost, this.getCost(), this.isset_cost);
        ub.set(BarCode, this.getBarCode(), this.isset_barCode);
        ub.set(OtPrice, this.getOtPrice(), this.isset_otPrice);
        ub.set(Weight, this.getWeight(), this.isset_weight);
        ub.set(Volume, this.getVolume(), this.isset_volume);
        ub.set(Brokerage, this.getBrokerage(), this.isset_brokerage);
        ub.set(BrokerageTwo, this.getBrokerageTwo(), this.isset_brokerageTwo);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Quota, this.getQuota(), this.isset_quota);
        ub.set(QuotaShow, this.getQuotaShow(), this.isset_quotaShow);
        ub.set(AttrValue, this.getAttrValue(), this.isset_attrValue);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(Version, this.getVersion(), this.isset_version);
        ub.set(MasterId, this.getMasterId(), this.isset_masterId);
        ub.set(IsCallback, this.getIsCallback(), this.isset_isCallback);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Stock, this.getStock(), this.isset_stock);
        ub.set(Sales, this.getSales(), this.isset_sales);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(Cost, this.getCost(), this.isset_cost);
        ub.set(BarCode, this.getBarCode(), this.isset_barCode);
        ub.set(OtPrice, this.getOtPrice(), this.isset_otPrice);
        ub.set(Weight, this.getWeight(), this.isset_weight);
        ub.set(Volume, this.getVolume(), this.isset_volume);
        ub.set(Brokerage, this.getBrokerage(), this.isset_brokerage);
        ub.set(BrokerageTwo, this.getBrokerageTwo(), this.isset_brokerageTwo);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Quota, this.getQuota(), this.isset_quota);
        ub.set(QuotaShow, this.getQuotaShow(), this.isset_quotaShow);
        ub.set(AttrValue, this.getAttrValue(), this.isset_attrValue);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(Version, this.getVersion(), this.isset_version);
        ub.set(MasterId, this.getMasterId(), this.isset_masterId);
        ub.set(IsCallback, this.getIsCallback(), this.isset_isCallback);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Stock, this.getStock(), this.isset_stock);
        ub.set(Sales, this.getSales(), this.isset_sales);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(Cost, this.getCost(), this.isset_cost);
        ub.set(BarCode, this.getBarCode(), this.isset_barCode);
        ub.set(OtPrice, this.getOtPrice(), this.isset_otPrice);
        ub.set(Weight, this.getWeight(), this.isset_weight);
        ub.set(Volume, this.getVolume(), this.isset_volume);
        ub.set(Brokerage, this.getBrokerage(), this.isset_brokerage);
        ub.set(BrokerageTwo, this.getBrokerageTwo(), this.isset_brokerageTwo);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Quota, this.getQuota(), this.isset_quota);
        ub.set(QuotaShow, this.getQuotaShow(), this.isset_quotaShow);
        ub.set(AttrValue, this.getAttrValue(), this.isset_attrValue);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(Version, this.getVersion(), this.isset_version);
        ub.set(MasterId, this.getMasterId(), this.isset_masterId);
        ub.set(IsCallback, this.getIsCallback(), this.isset_isCallback);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, product_id, sku, stock, sales, price, image, cost, bar_code, ot_price, weight, volume, brokerage, brokerage_two, type, quota, quota_show, attr_value, is_del, version, master_id, is_callback from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, product_id, sku, stock, sales, price, image, cost, bar_code, ot_price, weight, volume, brokerage, brokerage_two, type, quota, quota_show, attr_value, is_del, version, master_id, is_callback from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbProductAttrValue mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbProductAttrValue toEbProductAttrValue() {
        return super.$clone();
    }
}

/**
 * eb_product_attr_value RowMapper
 *
 * @author genrator
 */
class EbProductAttrValueRowMapper implements RowMapper<EbProductAttrValue> {

    @Override
    public EbProductAttrValue mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbProductAttrValue eb_product_attr_value = new EbProductAttrValue();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Id);
        if (columnIndex > 0) {
            eb_product_attr_value.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.ProductId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setProductId(null);
            } else {
                eb_product_attr_value.setProductId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Sku);
        if (columnIndex > 0) {
            eb_product_attr_value.setSku(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Stock);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setStock(null);
            } else {
                eb_product_attr_value.setStock(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Sales);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setSales(null);
            } else {
                eb_product_attr_value.setSales(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Price);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setPrice(null);
            } else {
                eb_product_attr_value.setPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Image);
        if (columnIndex > 0) {
            eb_product_attr_value.setImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Cost);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setCost(null);
            } else {
                eb_product_attr_value.setCost(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.BarCode);
        if (columnIndex > 0) {
            eb_product_attr_value.setBarCode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.OtPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setOtPrice(null);
            } else {
                eb_product_attr_value.setOtPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Weight);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setWeight(null);
            } else {
                eb_product_attr_value.setWeight(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Volume);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setVolume(null);
            } else {
                eb_product_attr_value.setVolume(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Brokerage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setBrokerage(null);
            } else {
                eb_product_attr_value.setBrokerage(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.BrokerageTwo);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setBrokerageTwo(null);
            } else {
                eb_product_attr_value.setBrokerageTwo(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setType(null);
            } else {
                eb_product_attr_value.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Quota);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setQuota(null);
            } else {
                eb_product_attr_value.setQuota(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.QuotaShow);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setQuotaShow(null);
            } else {
                eb_product_attr_value.setQuotaShow(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.AttrValue);
        if (columnIndex > 0) {
            eb_product_attr_value.setAttrValue(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setIsDel(null);
            } else {
                eb_product_attr_value.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.Version);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setVersion(null);
            } else {
                eb_product_attr_value.setVersion(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.MasterId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setMasterId(null);
            } else {
                eb_product_attr_value.setMasterId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttrValue_mapper.IsCallback);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr_value.setIsCallback(null);
            } else {
                eb_product_attr_value.setIsCallback(rs.getInt(columnIndex));
            }
        }
        return eb_product_attr_value;
    }
}
