package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_PRODUCT_ATTR *
 * @author genrator
 */
public class EbProductAttr_mapper extends EbProductAttr implements BaseMapper<EbProductAttr> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbProductAttr> ROW_MAPPER = new EbProductAttrRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String ProductId = "product_id";
    public static final String AttrName = "attr_name";
    public static final String AttrValues = "attr_values";
    public static final String Type = "type";
    public static final String IsDel = "is_del";

    /**
     * 默认构造函数
     */
    public EbProductAttr_mapper(EbProductAttr ebProductAttr) {
        if (ebProductAttr == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebProductAttr.isset_id) {
            this.setId(ebProductAttr.getId());
        }
        //普通属性
        if (ebProductAttr.isset_productId) {
            this.setProductId(ebProductAttr.getProductId());
        }
        if (ebProductAttr.isset_attrName) {
            this.setAttrName(ebProductAttr.getAttrName());
        }
        if (ebProductAttr.isset_attrValues) {
            this.setAttrValues(ebProductAttr.getAttrValues());
        }
        if (ebProductAttr.isset_type) {
            this.setType(ebProductAttr.getType());
        }
        if (ebProductAttr.isset_isDel) {
            this.setIsDel(ebProductAttr.getIsDel());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_product_attr.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_product_attr";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(AttrName, this.getAttrName(), this.isset_attrName);
        ib.set(AttrValues, this.getAttrValues(), this.isset_attrValues);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(AttrName, this.getAttrName(), this.isset_attrName);
        ub.set(AttrValues, this.getAttrValues(), this.isset_attrValues);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(AttrName, this.getAttrName(), this.isset_attrName);
        ub.set(AttrValues, this.getAttrValues(), this.isset_attrValues);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(AttrName, this.getAttrName(), this.isset_attrName);
        ub.set(AttrValues, this.getAttrValues(), this.isset_attrValues);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, product_id, attr_name, attr_values, type, is_del from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, product_id, attr_name, attr_values, type, is_del from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbProductAttr mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbProductAttr toEbProductAttr() {
        return super.$clone();
    }
}

/**
 * eb_product_attr RowMapper
 *
 * @author genrator
 */
class EbProductAttrRowMapper implements RowMapper<EbProductAttr> {

    @Override
    public EbProductAttr mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbProductAttr eb_product_attr = new EbProductAttr();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttr_mapper.Id);
        if (columnIndex > 0) {
            eb_product_attr.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttr_mapper.ProductId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr.setProductId(null);
            } else {
                eb_product_attr.setProductId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttr_mapper.AttrName);
        if (columnIndex > 0) {
            eb_product_attr.setAttrName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttr_mapper.AttrValues);
        if (columnIndex > 0) {
            eb_product_attr.setAttrValues(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttr_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr.setType(null);
            } else {
                eb_product_attr.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductAttr_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_attr.setIsDel(null);
            } else {
                eb_product_attr.setIsDel(rs.getInt(columnIndex));
            }
        }
        return eb_product_attr;
    }
}
