
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_PRODUCT_BRAND *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbProductBrand extends BasePo<EbProductBrand> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbProductBrand ROW_MAPPER = new EbProductBrand();

    // 主键
    private Integer id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String name = null;
    @JsonIgnore
    protected boolean isset_name = false;

    private String icon = null;
    @JsonIgnore
    protected boolean isset_icon = false;

    private Integer sort = null;
    @JsonIgnore
    protected boolean isset_sort = false;

    private Integer isShow = null;
    @JsonIgnore
    protected boolean isset_isShow = false;

    private Integer isDel = null;
    @JsonIgnore
    protected boolean isset_isDel = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbProductBrand() {
    }

    /**
     * 根据主键构造对象
     */
    public EbProductBrand(Integer id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Integer) value);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.isset_name = true;
    }

    @JsonIgnore
    public boolean isEmptyName() {
        return this.name == null || this.name.length() == 0;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.isset_icon = true;
    }

    @JsonIgnore
    public boolean isEmptyIcon() {
        return this.icon == null || this.icon.length() == 0;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
        this.isset_sort = true;
    }

    @JsonIgnore
    public boolean isEmptySort() {
        return this.sort == null;
    }

    public Integer getIsShow() {
        return this.isShow;
    }

    public void setIsShow(Integer isShow) {
        this.isShow = isShow;
        this.isset_isShow = true;
    }

    @JsonIgnore
    public boolean isEmptyIsShow() {
        return this.isShow == null;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
        this.isset_isDel = true;
    }

    @JsonIgnore
    public boolean isEmptyIsDel() {
        return this.isDel == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("name=").append(this.name)
                .append("icon=").append(this.icon)
                .append("sort=").append(this.sort)
                .append("isShow=").append(this.isShow)
                .append("isDel=").append(this.isDel)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbProductBrand $clone() {
        EbProductBrand eb_product_brand = new EbProductBrand();

        // 数据库名称
        //eb_product_brand.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_product_brand.setId(this.getId());
        }
        // 普通属性
        if (this.isset_name) {
            eb_product_brand.setName(this.getName());
        }
        if (this.isset_icon) {
            eb_product_brand.setIcon(this.getIcon());
        }
        if (this.isset_sort) {
            eb_product_brand.setSort(this.getSort());
        }
        if (this.isset_isShow) {
            eb_product_brand.setIsShow(this.getIsShow());
        }
        if (this.isset_isDel) {
            eb_product_brand.setIsDel(this.getIsDel());
        }
        if (this.isset_createTime) {
            eb_product_brand.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_product_brand.setUpdateTime(this.getUpdateTime());
        }
        return eb_product_brand;
    }
}
