package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_PRODUCT_BRAND *
 * @author genrator
 */
public class EbProductBrand_mapper extends EbProductBrand implements BaseMapper<EbProductBrand> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbProductBrand> ROW_MAPPER = new EbProductBrandRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Name = "name";
    public static final String Icon = "icon";
    public static final String Sort = "sort";
    public static final String IsShow = "is_show";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbProductBrand_mapper(EbProductBrand ebProductBrand) {
        if (ebProductBrand == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebProductBrand.isset_id) {
            this.setId(ebProductBrand.getId());
        }
        //普通属性
        if (ebProductBrand.isset_name) {
            this.setName(ebProductBrand.getName());
        }
        if (ebProductBrand.isset_icon) {
            this.setIcon(ebProductBrand.getIcon());
        }
        if (ebProductBrand.isset_sort) {
            this.setSort(ebProductBrand.getSort());
        }
        if (ebProductBrand.isset_isShow) {
            this.setIsShow(ebProductBrand.getIsShow());
        }
        if (ebProductBrand.isset_isDel) {
            this.setIsDel(ebProductBrand.getIsDel());
        }
        if (ebProductBrand.isset_createTime) {
            this.setCreateTime(ebProductBrand.getCreateTime());
        }
        if (ebProductBrand.isset_updateTime) {
            this.setUpdateTime(ebProductBrand.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_product_brand.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_product_brand";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(Icon, this.getIcon(), this.isset_icon);
        ib.set(Sort, this.getSort(), this.isset_sort);
        ib.set(IsShow, this.getIsShow(), this.isset_isShow);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Icon, this.getIcon(), this.isset_icon);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Icon, this.getIcon(), this.isset_icon);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Icon, this.getIcon(), this.isset_icon);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, name, icon, sort, is_show, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, name, icon, sort, is_show, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbProductBrand mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbProductBrand toEbProductBrand() {
        return super.$clone();
    }
}

/**
 * eb_product_brand RowMapper
 *
 * @author genrator
 */
class EbProductBrandRowMapper implements RowMapper<EbProductBrand> {

    @Override
    public EbProductBrand mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbProductBrand eb_product_brand = new EbProductBrand();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbProductBrand_mapper.Id);
        if (columnIndex > 0) {
            eb_product_brand.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbProductBrand_mapper.Name);
        if (columnIndex > 0) {
            eb_product_brand.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductBrand_mapper.Icon);
        if (columnIndex > 0) {
            eb_product_brand.setIcon(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductBrand_mapper.Sort);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_brand.setSort(null);
            } else {
                eb_product_brand.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductBrand_mapper.IsShow);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_brand.setIsShow(null);
            } else {
                eb_product_brand.setIsShow(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductBrand_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_brand.setIsDel(null);
            } else {
                eb_product_brand.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductBrand_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_brand.setCreateTime(null);
            } else {
                eb_product_brand.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductBrand_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_brand.setUpdateTime(null);
            } else {
                eb_product_brand.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_product_brand;
    }
}
