
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_PRODUCT_CATEGORY *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbProductCategory extends BasePo<EbProductCategory> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbProductCategory ROW_MAPPER = new EbProductCategory();

    // 主键
    private Integer id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Integer pid = null;
    @JsonIgnore
    protected boolean isset_pid = false;

    private String name = null;
    @JsonIgnore
    protected boolean isset_name = false;

    private String icon = null;
    @JsonIgnore
    protected boolean isset_icon = false;

    private Integer level = null;
    @JsonIgnore
    protected boolean isset_level = false;

    private Integer sort = null;
    @JsonIgnore
    protected boolean isset_sort = false;

    private Integer isShow = null;
    @JsonIgnore
    protected boolean isset_isShow = false;

    private Integer isDel = null;
    @JsonIgnore
    protected boolean isset_isDel = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbProductCategory() {
    }

    /**
     * 根据主键构造对象
     */
    public EbProductCategory(Integer id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Integer) value);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Integer getPid() {
        return this.pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
        this.isset_pid = true;
    }

    @JsonIgnore
    public boolean isEmptyPid() {
        return this.pid == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.isset_name = true;
    }

    @JsonIgnore
    public boolean isEmptyName() {
        return this.name == null || this.name.length() == 0;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
        this.isset_icon = true;
    }

    @JsonIgnore
    public boolean isEmptyIcon() {
        return this.icon == null || this.icon.length() == 0;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
        this.isset_level = true;
    }

    @JsonIgnore
    public boolean isEmptyLevel() {
        return this.level == null;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
        this.isset_sort = true;
    }

    @JsonIgnore
    public boolean isEmptySort() {
        return this.sort == null;
    }

    public Integer getIsShow() {
        return this.isShow;
    }

    public void setIsShow(Integer isShow) {
        this.isShow = isShow;
        this.isset_isShow = true;
    }

    @JsonIgnore
    public boolean isEmptyIsShow() {
        return this.isShow == null;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
        this.isset_isDel = true;
    }

    @JsonIgnore
    public boolean isEmptyIsDel() {
        return this.isDel == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("pid=").append(this.pid)
                .append("name=").append(this.name)
                .append("icon=").append(this.icon)
                .append("level=").append(this.level)
                .append("sort=").append(this.sort)
                .append("isShow=").append(this.isShow)
                .append("isDel=").append(this.isDel)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbProductCategory $clone() {
        EbProductCategory eb_product_category = new EbProductCategory();

        // 数据库名称
        //eb_product_category.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_product_category.setId(this.getId());
        }
        // 普通属性
        if (this.isset_pid) {
            eb_product_category.setPid(this.getPid());
        }
        if (this.isset_name) {
            eb_product_category.setName(this.getName());
        }
        if (this.isset_icon) {
            eb_product_category.setIcon(this.getIcon());
        }
        if (this.isset_level) {
            eb_product_category.setLevel(this.getLevel());
        }
        if (this.isset_sort) {
            eb_product_category.setSort(this.getSort());
        }
        if (this.isset_isShow) {
            eb_product_category.setIsShow(this.getIsShow());
        }
        if (this.isset_isDel) {
            eb_product_category.setIsDel(this.getIsDel());
        }
        if (this.isset_createTime) {
            eb_product_category.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_product_category.setUpdateTime(this.getUpdateTime());
        }
        return eb_product_category;
    }
}
