package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_PRODUCT_COUPON *
 * @author genrator
 */
public class EbProductCoupon_mapper extends EbProductCoupon implements BaseMapper<EbProductCoupon> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbProductCoupon> ROW_MAPPER = new EbProductCouponRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String ProductId = "product_id";
    public static final String CouponId = "coupon_id";
    public static final String AddTime = "add_time";

    /**
     * 默认构造函数
     */
    public EbProductCoupon_mapper(EbProductCoupon ebProductCoupon) {
        if (ebProductCoupon == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebProductCoupon.isset_id) {
            this.setId(ebProductCoupon.getId());
        }
        //普通属性
        if (ebProductCoupon.isset_productId) {
            this.setProductId(ebProductCoupon.getProductId());
        }
        if (ebProductCoupon.isset_couponId) {
            this.setCouponId(ebProductCoupon.getCouponId());
        }
        if (ebProductCoupon.isset_addTime) {
            this.setAddTime(ebProductCoupon.getAddTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_product_coupon.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_product_coupon";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(CouponId, this.getCouponId(), this.isset_couponId);
        ib.set(AddTime, this.getAddTime(), this.isset_addTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(CouponId, this.getCouponId(), this.isset_couponId);
        ub.set(AddTime, this.getAddTime(), this.isset_addTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(CouponId, this.getCouponId(), this.isset_couponId);
        ub.set(AddTime, this.getAddTime(), this.isset_addTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(CouponId, this.getCouponId(), this.isset_couponId);
        ub.set(AddTime, this.getAddTime(), this.isset_addTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, product_id, coupon_id, add_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, product_id, coupon_id, add_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbProductCoupon mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbProductCoupon toEbProductCoupon() {
        return super.$clone();
    }
}

/**
 * eb_product_coupon RowMapper
 *
 * @author genrator
 */
class EbProductCouponRowMapper implements RowMapper<EbProductCoupon> {

    @Override
    public EbProductCoupon mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbProductCoupon eb_product_coupon = new EbProductCoupon();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbProductCoupon_mapper.Id);
        if (columnIndex > 0) {
            eb_product_coupon.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbProductCoupon_mapper.ProductId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_coupon.setProductId(null);
            } else {
                eb_product_coupon.setProductId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductCoupon_mapper.CouponId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_coupon.setCouponId(null);
            } else {
                eb_product_coupon.setCouponId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductCoupon_mapper.AddTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_coupon.setAddTime(null);
            } else {
                eb_product_coupon.setAddTime(rs.getInt(columnIndex));
            }
        }
        return eb_product_coupon;
    }
}
