
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_PRODUCT_DESCRIPTION *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbProductDescription extends BasePo<EbProductDescription> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbProductDescription ROW_MAPPER = new EbProductDescription();

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Long productId = null;
    @JsonIgnore
    protected boolean isset_productId = false;

    private String description = null;
    @JsonIgnore
    protected boolean isset_description = false;

    private Integer type = null;
    @JsonIgnore
    protected boolean isset_type = false;

    /**
     * 默认构造函数
     */
    public EbProductDescription() {
    }

    /**
     * 根据主键构造对象
     */
    public EbProductDescription(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
        this.isset_productId = true;
    }

    @JsonIgnore
    public boolean isEmptyProductId() {
        return this.productId == null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.isset_description = true;
    }

    @JsonIgnore
    public boolean isEmptyDescription() {
        return this.description == null || this.description.length() == 0;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
        this.isset_type = true;
    }

    @JsonIgnore
    public boolean isEmptyType() {
        return this.type == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("productId=").append(this.productId)
                .append("description=").append(this.description)
                .append("type=").append(this.type)
                .toString();
    }

    /**
     * 克隆
     */
    public EbProductDescription $clone() {
        EbProductDescription eb_product_description = new EbProductDescription();

        // 数据库名称
        //eb_product_description.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_product_description.setId(this.getId());
        }
        // 普通属性
        if (this.isset_productId) {
            eb_product_description.setProductId(this.getProductId());
        }
        if (this.isset_description) {
            eb_product_description.setDescription(this.getDescription());
        }
        if (this.isset_type) {
            eb_product_description.setType(this.getType());
        }
        return eb_product_description;
    }
}
