package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_PRODUCT_REPLY *
 * @author genrator
 */
public class EbProductReply_mapper extends EbProductReply implements BaseMapper<EbProductReply> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbProductReply> ROW_MAPPER = new EbProductReplyRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Uid = "uid";
    public static final String MerId = "mer_id";
    public static final String OrderNo = "order_no";
    public static final String OrderDetailId = "order_detail_id";
    public static final String ProductId = "product_id";
    public static final String AttrValueId = "attr_value_id";
    public static final String Sku = "sku";
    public static final String Star = "star";
    public static final String Comment = "comment";
    public static final String Pics = "pics";
    public static final String MerchantReplyContent = "merchant_reply_content";
    public static final String MerchantReplyTime = "merchant_reply_time";
    public static final String IsDel = "is_del";
    public static final String IsReply = "is_reply";
    public static final String Nickname = "nickname";
    public static final String Avatar = "avatar";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbProductReply_mapper(EbProductReply ebProductReply) {
        if (ebProductReply == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebProductReply.isset_id) {
            this.setId(ebProductReply.getId());
        }
        //普通属性
        if (ebProductReply.isset_uid) {
            this.setUid(ebProductReply.getUid());
        }
        if (ebProductReply.isset_merId) {
            this.setMerId(ebProductReply.getMerId());
        }
        if (ebProductReply.isset_orderNo) {
            this.setOrderNo(ebProductReply.getOrderNo());
        }
        if (ebProductReply.isset_orderDetailId) {
            this.setOrderDetailId(ebProductReply.getOrderDetailId());
        }
        if (ebProductReply.isset_productId) {
            this.setProductId(ebProductReply.getProductId());
        }
        if (ebProductReply.isset_attrValueId) {
            this.setAttrValueId(ebProductReply.getAttrValueId());
        }
        if (ebProductReply.isset_sku) {
            this.setSku(ebProductReply.getSku());
        }
        if (ebProductReply.isset_star) {
            this.setStar(ebProductReply.getStar());
        }
        if (ebProductReply.isset_comment) {
            this.setComment(ebProductReply.getComment());
        }
        if (ebProductReply.isset_pics) {
            this.setPics(ebProductReply.getPics());
        }
        if (ebProductReply.isset_merchantReplyContent) {
            this.setMerchantReplyContent(ebProductReply.getMerchantReplyContent());
        }
        if (ebProductReply.isset_merchantReplyTime) {
            this.setMerchantReplyTime(ebProductReply.getMerchantReplyTime());
        }
        if (ebProductReply.isset_isDel) {
            this.setIsDel(ebProductReply.getIsDel());
        }
        if (ebProductReply.isset_isReply) {
            this.setIsReply(ebProductReply.getIsReply());
        }
        if (ebProductReply.isset_nickname) {
            this.setNickname(ebProductReply.getNickname());
        }
        if (ebProductReply.isset_avatar) {
            this.setAvatar(ebProductReply.getAvatar());
        }
        if (ebProductReply.isset_createTime) {
            this.setCreateTime(ebProductReply.getCreateTime());
        }
        if (ebProductReply.isset_updateTime) {
            this.setUpdateTime(ebProductReply.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_product_reply.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_product_reply";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ib.set(OrderDetailId, this.getOrderDetailId(), this.isset_orderDetailId);
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ib.set(Sku, this.getSku(), this.isset_sku);
        ib.set(Star, this.getStar(), this.isset_star);
        ib.set(Comment, this.getComment(), this.isset_comment);
        ib.set(Pics, this.getPics(), this.isset_pics);
        ib.set(MerchantReplyContent, this.getMerchantReplyContent(), this.isset_merchantReplyContent);
        ib.set(MerchantReplyTime, this.getMerchantReplyTime(), this.isset_merchantReplyTime);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(IsReply, this.getIsReply(), this.isset_isReply);
        ib.set(Nickname, this.getNickname(), this.isset_nickname);
        ib.set(Avatar, this.getAvatar(), this.isset_avatar);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(OrderDetailId, this.getOrderDetailId(), this.isset_orderDetailId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Star, this.getStar(), this.isset_star);
        ub.set(Comment, this.getComment(), this.isset_comment);
        ub.set(Pics, this.getPics(), this.isset_pics);
        ub.set(MerchantReplyContent, this.getMerchantReplyContent(), this.isset_merchantReplyContent);
        ub.set(MerchantReplyTime, this.getMerchantReplyTime(), this.isset_merchantReplyTime);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(IsReply, this.getIsReply(), this.isset_isReply);
        ub.set(Nickname, this.getNickname(), this.isset_nickname);
        ub.set(Avatar, this.getAvatar(), this.isset_avatar);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(OrderDetailId, this.getOrderDetailId(), this.isset_orderDetailId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Star, this.getStar(), this.isset_star);
        ub.set(Comment, this.getComment(), this.isset_comment);
        ub.set(Pics, this.getPics(), this.isset_pics);
        ub.set(MerchantReplyContent, this.getMerchantReplyContent(), this.isset_merchantReplyContent);
        ub.set(MerchantReplyTime, this.getMerchantReplyTime(), this.isset_merchantReplyTime);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(IsReply, this.getIsReply(), this.isset_isReply);
        ub.set(Nickname, this.getNickname(), this.isset_nickname);
        ub.set(Avatar, this.getAvatar(), this.isset_avatar);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(OrderDetailId, this.getOrderDetailId(), this.isset_orderDetailId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Star, this.getStar(), this.isset_star);
        ub.set(Comment, this.getComment(), this.isset_comment);
        ub.set(Pics, this.getPics(), this.isset_pics);
        ub.set(MerchantReplyContent, this.getMerchantReplyContent(), this.isset_merchantReplyContent);
        ub.set(MerchantReplyTime, this.getMerchantReplyTime(), this.isset_merchantReplyTime);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(IsReply, this.getIsReply(), this.isset_isReply);
        ub.set(Nickname, this.getNickname(), this.isset_nickname);
        ub.set(Avatar, this.getAvatar(), this.isset_avatar);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, uid, mer_id, order_no, order_detail_id, product_id, attr_value_id, sku, star, comment, pics, merchant_reply_content, merchant_reply_time, is_del, is_reply, nickname, avatar, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, uid, mer_id, order_no, order_detail_id, product_id, attr_value_id, sku, star, comment, pics, merchant_reply_content, merchant_reply_time, is_del, is_reply, nickname, avatar, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbProductReply mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbProductReply toEbProductReply() {
        return super.$clone();
    }
}

/**
 * eb_product_reply RowMapper
 *
 * @author genrator
 */
class EbProductReplyRowMapper implements RowMapper<EbProductReply> {

    @Override
    public EbProductReply mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbProductReply eb_product_reply = new EbProductReply();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.Id);
        if (columnIndex > 0) {
            eb_product_reply.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setUid(null);
            } else {
                eb_product_reply.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setMerId(null);
            } else {
                eb_product_reply.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.OrderNo);
        if (columnIndex > 0) {
            eb_product_reply.setOrderNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.OrderDetailId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setOrderDetailId(null);
            } else {
                eb_product_reply.setOrderDetailId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.ProductId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setProductId(null);
            } else {
                eb_product_reply.setProductId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.AttrValueId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setAttrValueId(null);
            } else {
                eb_product_reply.setAttrValueId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.Sku);
        if (columnIndex > 0) {
            eb_product_reply.setSku(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.Star);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setStar(null);
            } else {
                eb_product_reply.setStar(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.Comment);
        if (columnIndex > 0) {
            eb_product_reply.setComment(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.Pics);
        if (columnIndex > 0) {
            eb_product_reply.setPics(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.MerchantReplyContent);
        if (columnIndex > 0) {
            eb_product_reply.setMerchantReplyContent(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.MerchantReplyTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setMerchantReplyTime(null);
            } else {
                eb_product_reply.setMerchantReplyTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setIsDel(null);
            } else {
                eb_product_reply.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.IsReply);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setIsReply(null);
            } else {
                eb_product_reply.setIsReply(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.Nickname);
        if (columnIndex > 0) {
            eb_product_reply.setNickname(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.Avatar);
        if (columnIndex > 0) {
            eb_product_reply.setAvatar(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setCreateTime(null);
            } else {
                eb_product_reply.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductReply_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_reply.setUpdateTime(null);
            } else {
                eb_product_reply.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_product_reply;
    }
}
