
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_PRODUCT_RULE *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbProductRule extends BasePo<EbProductRule> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Integer merId = null;
    @JsonIgnore
    protected boolean isset_merId = false;

    private String ruleName = null;
    @JsonIgnore
    protected boolean isset_ruleName = false;

    private String ruleValue = null;
    @JsonIgnore
    protected boolean isset_ruleValue = false;

    /**
     * 默认构造函数
     */
    public EbProductRule() {
    }

    /**
     * 根据主键构造对象
     */
    public EbProductRule(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Integer getMerId() {
        return this.merId;
    }

    public void setMerId(Integer merId) {
        this.merId = merId;
        this.isset_merId = true;
    }

    @JsonIgnore
    public boolean isEmptyMerId() {
        return this.merId == null;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
        this.isset_ruleName = true;
    }

    @JsonIgnore
    public boolean isEmptyRuleName() {
        return this.ruleName == null || this.ruleName.length() == 0;
    }

    public String getRuleValue() {
        return this.ruleValue;
    }

    public void setRuleValue(String ruleValue) {
        this.ruleValue = ruleValue;
        this.isset_ruleValue = true;
    }

    @JsonIgnore
    public boolean isEmptyRuleValue() {
        return this.ruleValue == null || this.ruleValue.length() == 0;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("merId=").append(this.merId)
                .append("ruleName=").append(this.ruleName)
                .append("ruleValue=").append(this.ruleValue)
                .toString();
    }

    /**
     * 克隆
     */
    public EbProductRule $clone() {
        EbProductRule eb_product_rule = new EbProductRule();

        // 数据库名称
        //eb_product_rule.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_product_rule.setId(this.getId());
        }
        // 普通属性
        if (this.isset_merId) {
            eb_product_rule.setMerId(this.getMerId());
        }
        if (this.isset_ruleName) {
            eb_product_rule.setRuleName(this.getRuleName());
        }
        if (this.isset_ruleValue) {
            eb_product_rule.setRuleValue(this.getRuleValue());
        }
        return eb_product_rule;
    }
}
