
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_RECHARGE_ORDER *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbRechargeOrder extends BasePo<EbRechargeOrder> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Long uid = null;
    @JsonIgnore
    protected boolean isset_uid = false;

    private String orderNo = null;
    @JsonIgnore
    protected boolean isset_orderNo = false;

    private Double price = null;
    @JsonIgnore
    protected boolean isset_price = false;

    private Double givePrice = null;
    @JsonIgnore
    protected boolean isset_givePrice = false;

    private String payType = null;
    @JsonIgnore
    protected boolean isset_payType = false;

    private String payChannel = null;
    @JsonIgnore
    protected boolean isset_payChannel = false;

    private Integer paid = null;
    @JsonIgnore
    protected boolean isset_paid = false;

    private Long payTime = null;
    @JsonIgnore
    protected boolean isset_payTime = false;

    private String outTradeNo = null;
    @JsonIgnore
    protected boolean isset_outTradeNo = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbRechargeOrder() {
    }

    /**
     * 根据主键构造对象
     */
    public EbRechargeOrder(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
        this.isset_uid = true;
    }

    @JsonIgnore
    public boolean isEmptyUid() {
        return this.uid == null;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
        this.isset_orderNo = true;
    }

    @JsonIgnore
    public boolean isEmptyOrderNo() {
        return this.orderNo == null || this.orderNo.length() == 0;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
        this.isset_price = true;
    }

    @JsonIgnore
    public boolean isEmptyPrice() {
        return this.price == null;
    }

    public Double getGivePrice() {
        return this.givePrice;
    }

    public void setGivePrice(Double givePrice) {
        this.givePrice = givePrice;
        this.isset_givePrice = true;
    }

    @JsonIgnore
    public boolean isEmptyGivePrice() {
        return this.givePrice == null;
    }

    public String getPayType() {
        return this.payType;
    }

    public void setPayType(String payType) {
        this.payType = payType;
        this.isset_payType = true;
    }

    @JsonIgnore
    public boolean isEmptyPayType() {
        return this.payType == null || this.payType.length() == 0;
    }

    public String getPayChannel() {
        return this.payChannel;
    }

    public void setPayChannel(String payChannel) {
        this.payChannel = payChannel;
        this.isset_payChannel = true;
    }

    @JsonIgnore
    public boolean isEmptyPayChannel() {
        return this.payChannel == null || this.payChannel.length() == 0;
    }

    public Integer getPaid() {
        return this.paid;
    }

    public void setPaid(Integer paid) {
        this.paid = paid;
        this.isset_paid = true;
    }

    @JsonIgnore
    public boolean isEmptyPaid() {
        return this.paid == null;
    }

    public Long getPayTime() {
        return this.payTime;
    }

    public void setPayTime(Long payTime) {
        this.payTime = payTime;
        this.isset_payTime = true;
    }

    @JsonIgnore
    public boolean isEmptyPayTime() {
        return this.payTime == null;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
        this.isset_outTradeNo = true;
    }

    @JsonIgnore
    public boolean isEmptyOutTradeNo() {
        return this.outTradeNo == null || this.outTradeNo.length() == 0;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("uid=").append(this.uid)
                .append("orderNo=").append(this.orderNo)
                .append("price=").append(this.price)
                .append("givePrice=").append(this.givePrice)
                .append("payType=").append(this.payType)
                .append("payChannel=").append(this.payChannel)
                .append("paid=").append(this.paid)
                .append("payTime=").append(this.payTime)
                .append("outTradeNo=").append(this.outTradeNo)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbRechargeOrder $clone() {
        EbRechargeOrder eb_recharge_order = new EbRechargeOrder();

        // 数据库名称
        //eb_recharge_order.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_recharge_order.setId(this.getId());
        }
        // 普通属性
        if (this.isset_uid) {
            eb_recharge_order.setUid(this.getUid());
        }
        if (this.isset_orderNo) {
            eb_recharge_order.setOrderNo(this.getOrderNo());
        }
        if (this.isset_price) {
            eb_recharge_order.setPrice(this.getPrice());
        }
        if (this.isset_givePrice) {
            eb_recharge_order.setGivePrice(this.getGivePrice());
        }
        if (this.isset_payType) {
            eb_recharge_order.setPayType(this.getPayType());
        }
        if (this.isset_payChannel) {
            eb_recharge_order.setPayChannel(this.getPayChannel());
        }
        if (this.isset_paid) {
            eb_recharge_order.setPaid(this.getPaid());
        }
        if (this.isset_payTime) {
            eb_recharge_order.setPayTime(this.getPayTime());
        }
        if (this.isset_outTradeNo) {
            eb_recharge_order.setOutTradeNo(this.getOutTradeNo());
        }
        if (this.isset_createTime) {
            eb_recharge_order.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_recharge_order.setUpdateTime(this.getUpdateTime());
        }
        return eb_recharge_order;
    }
}
