package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_RECHARGE_ORDER *
 * @author genrator
 */
public class EbRechargeOrder_mapper extends EbRechargeOrder implements BaseMapper<EbRechargeOrder> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbRechargeOrder> ROW_MAPPER = new EbRechargeOrderRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Uid = "uid";
    public static final String OrderNo = "order_no";
    public static final String Price = "price";
    public static final String GivePrice = "give_price";
    public static final String PayType = "pay_type";
    public static final String PayChannel = "pay_channel";
    public static final String Paid = "paid";
    public static final String PayTime = "pay_time";
    public static final String OutTradeNo = "out_trade_no";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbRechargeOrder_mapper(EbRechargeOrder ebRechargeOrder) {
        if (ebRechargeOrder == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebRechargeOrder.isset_id) {
            this.setId(ebRechargeOrder.getId());
        }
        //普通属性
        if (ebRechargeOrder.isset_uid) {
            this.setUid(ebRechargeOrder.getUid());
        }
        if (ebRechargeOrder.isset_orderNo) {
            this.setOrderNo(ebRechargeOrder.getOrderNo());
        }
        if (ebRechargeOrder.isset_price) {
            this.setPrice(ebRechargeOrder.getPrice());
        }
        if (ebRechargeOrder.isset_givePrice) {
            this.setGivePrice(ebRechargeOrder.getGivePrice());
        }
        if (ebRechargeOrder.isset_payType) {
            this.setPayType(ebRechargeOrder.getPayType());
        }
        if (ebRechargeOrder.isset_payChannel) {
            this.setPayChannel(ebRechargeOrder.getPayChannel());
        }
        if (ebRechargeOrder.isset_paid) {
            this.setPaid(ebRechargeOrder.getPaid());
        }
        if (ebRechargeOrder.isset_payTime) {
            this.setPayTime(ebRechargeOrder.getPayTime());
        }
        if (ebRechargeOrder.isset_outTradeNo) {
            this.setOutTradeNo(ebRechargeOrder.getOutTradeNo());
        }
        if (ebRechargeOrder.isset_createTime) {
            this.setCreateTime(ebRechargeOrder.getCreateTime());
        }
        if (ebRechargeOrder.isset_updateTime) {
            this.setUpdateTime(ebRechargeOrder.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_recharge_order.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_recharge_order";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ib.set(Price, this.getPrice(), this.isset_price);
        ib.set(GivePrice, this.getGivePrice(), this.isset_givePrice);
        ib.set(PayType, this.getPayType(), this.isset_payType);
        ib.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ib.set(Paid, this.getPaid(), this.isset_paid);
        ib.set(PayTime, this.getPayTime(), this.isset_payTime);
        ib.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(GivePrice, this.getGivePrice(), this.isset_givePrice);
        ub.set(PayType, this.getPayType(), this.isset_payType);
        ub.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ub.set(Paid, this.getPaid(), this.isset_paid);
        ub.set(PayTime, this.getPayTime(), this.isset_payTime);
        ub.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(GivePrice, this.getGivePrice(), this.isset_givePrice);
        ub.set(PayType, this.getPayType(), this.isset_payType);
        ub.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ub.set(Paid, this.getPaid(), this.isset_paid);
        ub.set(PayTime, this.getPayTime(), this.isset_payTime);
        ub.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(GivePrice, this.getGivePrice(), this.isset_givePrice);
        ub.set(PayType, this.getPayType(), this.isset_payType);
        ub.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ub.set(Paid, this.getPaid(), this.isset_paid);
        ub.set(PayTime, this.getPayTime(), this.isset_payTime);
        ub.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, uid, order_no, price, give_price, pay_type, pay_channel, paid, pay_time, out_trade_no, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, uid, order_no, price, give_price, pay_type, pay_channel, paid, pay_time, out_trade_no, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbRechargeOrder mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbRechargeOrder toEbRechargeOrder() {
        return super.$clone();
    }
}

/**
 * eb_recharge_order RowMapper
 *
 * @author genrator
 */
class EbRechargeOrderRowMapper implements RowMapper<EbRechargeOrder> {

    @Override
    public EbRechargeOrder mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbRechargeOrder eb_recharge_order = new EbRechargeOrder();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.Id);
        if (columnIndex > 0) {
            eb_recharge_order.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_recharge_order.setUid(null);
            } else {
                eb_recharge_order.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.OrderNo);
        if (columnIndex > 0) {
            eb_recharge_order.setOrderNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.Price);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_recharge_order.setPrice(null);
            } else {
                eb_recharge_order.setPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.GivePrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_recharge_order.setGivePrice(null);
            } else {
                eb_recharge_order.setGivePrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.PayType);
        if (columnIndex > 0) {
            eb_recharge_order.setPayType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.PayChannel);
        if (columnIndex > 0) {
            eb_recharge_order.setPayChannel(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.Paid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_recharge_order.setPaid(null);
            } else {
                eb_recharge_order.setPaid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.PayTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_recharge_order.setPayTime(null);
            } else {
                eb_recharge_order.setPayTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.OutTradeNo);
        if (columnIndex > 0) {
            eb_recharge_order.setOutTradeNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_recharge_order.setCreateTime(null);
            } else {
                eb_recharge_order.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbRechargeOrder_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_recharge_order.setUpdateTime(null);
            } else {
                eb_recharge_order.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_recharge_order;
    }
}
