
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_SHIPPING_TEMPLATES_FREE *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbShippingTemplatesFree extends BasePo<EbShippingTemplatesFree> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbShippingTemplatesFree ROW_MAPPER = new EbShippingTemplatesFree();

    // 主键
    private Integer id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Integer tempId = null;
    @JsonIgnore
    protected boolean isset_tempId = false;

    private Integer cityId = null;
    @JsonIgnore
    protected boolean isset_cityId = false;

    private String title = null;
    @JsonIgnore
    protected boolean isset_title = false;

    private Double number = null;
    @JsonIgnore
    protected boolean isset_number = false;

    private Double price = null;
    @JsonIgnore
    protected boolean isset_price = false;

    private Integer type = null;
    @JsonIgnore
    protected boolean isset_type = false;

    private String uniqid = null;
    @JsonIgnore
    protected boolean isset_uniqid = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbShippingTemplatesFree() {
    }

    /**
     * 根据主键构造对象
     */
    public EbShippingTemplatesFree(Integer id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Integer) value);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Integer getTempId() {
        return this.tempId;
    }

    public void setTempId(Integer tempId) {
        this.tempId = tempId;
        this.isset_tempId = true;
    }

    @JsonIgnore
    public boolean isEmptyTempId() {
        return this.tempId == null;
    }

    public Integer getCityId() {
        return this.cityId;
    }

    public void setCityId(Integer cityId) {
        this.cityId = cityId;
        this.isset_cityId = true;
    }

    @JsonIgnore
    public boolean isEmptyCityId() {
        return this.cityId == null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.isset_title = true;
    }

    @JsonIgnore
    public boolean isEmptyTitle() {
        return this.title == null || this.title.length() == 0;
    }

    public Double getNumber() {
        return this.number;
    }

    public void setNumber(Double number) {
        this.number = number;
        this.isset_number = true;
    }

    @JsonIgnore
    public boolean isEmptyNumber() {
        return this.number == null;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
        this.isset_price = true;
    }

    @JsonIgnore
    public boolean isEmptyPrice() {
        return this.price == null;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
        this.isset_type = true;
    }

    @JsonIgnore
    public boolean isEmptyType() {
        return this.type == null;
    }

    public String getUniqid() {
        return this.uniqid;
    }

    public void setUniqid(String uniqid) {
        this.uniqid = uniqid;
        this.isset_uniqid = true;
    }

    @JsonIgnore
    public boolean isEmptyUniqid() {
        return this.uniqid == null || this.uniqid.length() == 0;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("tempId=").append(this.tempId)
                .append("cityId=").append(this.cityId)
                .append("title=").append(this.title)
                .append("number=").append(this.number)
                .append("price=").append(this.price)
                .append("type=").append(this.type)
                .append("uniqid=").append(this.uniqid)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbShippingTemplatesFree $clone() {
        EbShippingTemplatesFree eb_shipping_templates_free = new EbShippingTemplatesFree();

        // 数据库名称
        //eb_shipping_templates_free.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_shipping_templates_free.setId(this.getId());
        }
        // 普通属性
        if (this.isset_tempId) {
            eb_shipping_templates_free.setTempId(this.getTempId());
        }
        if (this.isset_cityId) {
            eb_shipping_templates_free.setCityId(this.getCityId());
        }
        if (this.isset_title) {
            eb_shipping_templates_free.setTitle(this.getTitle());
        }
        if (this.isset_number) {
            eb_shipping_templates_free.setNumber(this.getNumber());
        }
        if (this.isset_price) {
            eb_shipping_templates_free.setPrice(this.getPrice());
        }
        if (this.isset_type) {
            eb_shipping_templates_free.setType(this.getType());
        }
        if (this.isset_uniqid) {
            eb_shipping_templates_free.setUniqid(this.getUniqid());
        }
        if (this.isset_createTime) {
            eb_shipping_templates_free.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_shipping_templates_free.setUpdateTime(this.getUpdateTime());
        }
        return eb_shipping_templates_free;
    }
}
