package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_SHIPPING_TEMPLATES_FREE *
 * @author genrator
 */
public class EbShippingTemplatesFree_mapper extends EbShippingTemplatesFree implements BaseMapper<EbShippingTemplatesFree> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbShippingTemplatesFree> ROW_MAPPER = new EbShippingTemplatesFreeRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String TempId = "temp_id";
    public static final String CityId = "city_id";
    public static final String Title = "title";
    public static final String Number = "number";
    public static final String Price = "price";
    public static final String Type = "type";
    public static final String Uniqid = "uniqid";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbShippingTemplatesFree_mapper(EbShippingTemplatesFree ebShippingTemplatesFree) {
        if (ebShippingTemplatesFree == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebShippingTemplatesFree.isset_id) {
            this.setId(ebShippingTemplatesFree.getId());
        }
        //普通属性
        if (ebShippingTemplatesFree.isset_tempId) {
            this.setTempId(ebShippingTemplatesFree.getTempId());
        }
        if (ebShippingTemplatesFree.isset_cityId) {
            this.setCityId(ebShippingTemplatesFree.getCityId());
        }
        if (ebShippingTemplatesFree.isset_title) {
            this.setTitle(ebShippingTemplatesFree.getTitle());
        }
        if (ebShippingTemplatesFree.isset_number) {
            this.setNumber(ebShippingTemplatesFree.getNumber());
        }
        if (ebShippingTemplatesFree.isset_price) {
            this.setPrice(ebShippingTemplatesFree.getPrice());
        }
        if (ebShippingTemplatesFree.isset_type) {
            this.setType(ebShippingTemplatesFree.getType());
        }
        if (ebShippingTemplatesFree.isset_uniqid) {
            this.setUniqid(ebShippingTemplatesFree.getUniqid());
        }
        if (ebShippingTemplatesFree.isset_createTime) {
            this.setCreateTime(ebShippingTemplatesFree.getCreateTime());
        }
        if (ebShippingTemplatesFree.isset_updateTime) {
            this.setUpdateTime(ebShippingTemplatesFree.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_shipping_templates_free.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_shipping_templates_free";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(TempId, this.getTempId(), this.isset_tempId);
        ib.set(CityId, this.getCityId(), this.isset_cityId);
        ib.set(Title, this.getTitle(), this.isset_title);
        ib.set(Number, this.getNumber(), this.isset_number);
        ib.set(Price, this.getPrice(), this.isset_price);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(Uniqid, this.getUniqid(), this.isset_uniqid);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(CityId, this.getCityId(), this.isset_cityId);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(Number, this.getNumber(), this.isset_number);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Uniqid, this.getUniqid(), this.isset_uniqid);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(CityId, this.getCityId(), this.isset_cityId);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(Number, this.getNumber(), this.isset_number);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Uniqid, this.getUniqid(), this.isset_uniqid);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(CityId, this.getCityId(), this.isset_cityId);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(Number, this.getNumber(), this.isset_number);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Uniqid, this.getUniqid(), this.isset_uniqid);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, temp_id, city_id, title, number, price, type, uniqid, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, temp_id, city_id, title, number, price, type, uniqid, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbShippingTemplatesFree mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbShippingTemplatesFree toEbShippingTemplatesFree() {
        return super.$clone();
    }
}

/**
 * eb_shipping_templates_free RowMapper
 *
 * @author genrator
 */
class EbShippingTemplatesFreeRowMapper implements RowMapper<EbShippingTemplatesFree> {

    @Override
    public EbShippingTemplatesFree mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbShippingTemplatesFree eb_shipping_templates_free = new EbShippingTemplatesFree();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.Id);
        if (columnIndex > 0) {
            eb_shipping_templates_free.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.TempId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_free.setTempId(null);
            } else {
                eb_shipping_templates_free.setTempId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.CityId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_free.setCityId(null);
            } else {
                eb_shipping_templates_free.setCityId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.Title);
        if (columnIndex > 0) {
            eb_shipping_templates_free.setTitle(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.Number);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_free.setNumber(null);
            } else {
                eb_shipping_templates_free.setNumber(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.Price);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_free.setPrice(null);
            } else {
                eb_shipping_templates_free.setPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_free.setType(null);
            } else {
                eb_shipping_templates_free.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.Uniqid);
        if (columnIndex > 0) {
            eb_shipping_templates_free.setUniqid(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_free.setCreateTime(null);
            } else {
                eb_shipping_templates_free.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesFree_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_free.setUpdateTime(null);
            } else {
                eb_shipping_templates_free.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_shipping_templates_free;
    }
}
