package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_USER_ADDRESS *
 * @author genrator
 */
public class EbUserAddress_mapper extends EbUserAddress implements BaseMapper<EbUserAddress> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbUserAddress> ROW_MAPPER = new EbUserAddressRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Uid = "uid";
    public static final String RealName = "real_name";
    public static final String Phone = "phone";
    public static final String Province = "province";
    public static final String ProvinceId = "province_id";
    public static final String City = "city";
    public static final String CityId = "city_id";
    public static final String District = "district";
    public static final String DistrictId = "district_id";
    public static final String Street = "street";
    public static final String Detail = "detail";
    public static final String PostCode = "post_code";
    public static final String Longitude = "longitude";
    public static final String Latitude = "latitude";
    public static final String IsDefault = "is_default";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbUserAddress_mapper(EbUserAddress ebUserAddress) {
        if (ebUserAddress == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebUserAddress.isset_id) {
            this.setId(ebUserAddress.getId());
        }
        //普通属性
        if (ebUserAddress.isset_uid) {
            this.setUid(ebUserAddress.getUid());
        }
        if (ebUserAddress.isset_realName) {
            this.setRealName(ebUserAddress.getRealName());
        }
        if (ebUserAddress.isset_phone) {
            this.setPhone(ebUserAddress.getPhone());
        }
        if (ebUserAddress.isset_province) {
            this.setProvince(ebUserAddress.getProvince());
        }
        if (ebUserAddress.isset_provinceId) {
            this.setProvinceId(ebUserAddress.getProvinceId());
        }
        if (ebUserAddress.isset_city) {
            this.setCity(ebUserAddress.getCity());
        }
        if (ebUserAddress.isset_cityId) {
            this.setCityId(ebUserAddress.getCityId());
        }
        if (ebUserAddress.isset_district) {
            this.setDistrict(ebUserAddress.getDistrict());
        }
        if (ebUserAddress.isset_districtId) {
            this.setDistrictId(ebUserAddress.getDistrictId());
        }
        if (ebUserAddress.isset_street) {
            this.setStreet(ebUserAddress.getStreet());
        }
        if (ebUserAddress.isset_detail) {
            this.setDetail(ebUserAddress.getDetail());
        }
        if (ebUserAddress.isset_postCode) {
            this.setPostCode(ebUserAddress.getPostCode());
        }
        if (ebUserAddress.isset_longitude) {
            this.setLongitude(ebUserAddress.getLongitude());
        }
        if (ebUserAddress.isset_latitude) {
            this.setLatitude(ebUserAddress.getLatitude());
        }
        if (ebUserAddress.isset_isDefault) {
            this.setIsDefault(ebUserAddress.getIsDefault());
        }
        if (ebUserAddress.isset_isDel) {
            this.setIsDel(ebUserAddress.getIsDel());
        }
        if (ebUserAddress.isset_createTime) {
            this.setCreateTime(ebUserAddress.getCreateTime());
        }
        if (ebUserAddress.isset_updateTime) {
            this.setUpdateTime(ebUserAddress.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_user_address.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_user_address";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(RealName, this.getRealName(), this.isset_realName);
        ib.set(Phone, this.getPhone(), this.isset_phone);
        ib.set(Province, this.getProvince(), this.isset_province);
        ib.set(ProvinceId, this.getProvinceId(), this.isset_provinceId);
        ib.set(City, this.getCity(), this.isset_city);
        ib.set(CityId, this.getCityId(), this.isset_cityId);
        ib.set(District, this.getDistrict(), this.isset_district);
        ib.set(DistrictId, this.getDistrictId(), this.isset_districtId);
        ib.set(Street, this.getStreet(), this.isset_street);
        ib.set(Detail, this.getDetail(), this.isset_detail);
        ib.set(PostCode, this.getPostCode(), this.isset_postCode);
        ib.set(Longitude, this.getLongitude(), this.isset_longitude);
        ib.set(Latitude, this.getLatitude(), this.isset_latitude);
        ib.set(IsDefault, this.getIsDefault(), this.isset_isDefault);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(Province, this.getProvince(), this.isset_province);
        ub.set(ProvinceId, this.getProvinceId(), this.isset_provinceId);
        ub.set(City, this.getCity(), this.isset_city);
        ub.set(CityId, this.getCityId(), this.isset_cityId);
        ub.set(District, this.getDistrict(), this.isset_district);
        ub.set(DistrictId, this.getDistrictId(), this.isset_districtId);
        ub.set(Street, this.getStreet(), this.isset_street);
        ub.set(Detail, this.getDetail(), this.isset_detail);
        ub.set(PostCode, this.getPostCode(), this.isset_postCode);
        ub.set(Longitude, this.getLongitude(), this.isset_longitude);
        ub.set(Latitude, this.getLatitude(), this.isset_latitude);
        ub.set(IsDefault, this.getIsDefault(), this.isset_isDefault);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(Province, this.getProvince(), this.isset_province);
        ub.set(ProvinceId, this.getProvinceId(), this.isset_provinceId);
        ub.set(City, this.getCity(), this.isset_city);
        ub.set(CityId, this.getCityId(), this.isset_cityId);
        ub.set(District, this.getDistrict(), this.isset_district);
        ub.set(DistrictId, this.getDistrictId(), this.isset_districtId);
        ub.set(Street, this.getStreet(), this.isset_street);
        ub.set(Detail, this.getDetail(), this.isset_detail);
        ub.set(PostCode, this.getPostCode(), this.isset_postCode);
        ub.set(Longitude, this.getLongitude(), this.isset_longitude);
        ub.set(Latitude, this.getLatitude(), this.isset_latitude);
        ub.set(IsDefault, this.getIsDefault(), this.isset_isDefault);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(Province, this.getProvince(), this.isset_province);
        ub.set(ProvinceId, this.getProvinceId(), this.isset_provinceId);
        ub.set(City, this.getCity(), this.isset_city);
        ub.set(CityId, this.getCityId(), this.isset_cityId);
        ub.set(District, this.getDistrict(), this.isset_district);
        ub.set(DistrictId, this.getDistrictId(), this.isset_districtId);
        ub.set(Street, this.getStreet(), this.isset_street);
        ub.set(Detail, this.getDetail(), this.isset_detail);
        ub.set(PostCode, this.getPostCode(), this.isset_postCode);
        ub.set(Longitude, this.getLongitude(), this.isset_longitude);
        ub.set(Latitude, this.getLatitude(), this.isset_latitude);
        ub.set(IsDefault, this.getIsDefault(), this.isset_isDefault);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, uid, real_name, phone, province, province_id, city, city_id, district, district_id, street, detail, post_code, longitude, latitude, is_default, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, uid, real_name, phone, province, province_id, city, city_id, district, district_id, street, detail, post_code, longitude, latitude, is_default, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbUserAddress mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbUserAddress toEbUserAddress() {
        return super.$clone();
    }
}

/**
 * eb_user_address RowMapper
 *
 * @author genrator
 */
class EbUserAddressRowMapper implements RowMapper<EbUserAddress> {

    @Override
    public EbUserAddress mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbUserAddress eb_user_address = new EbUserAddress();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.Id);
        if (columnIndex > 0) {
            eb_user_address.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_address.setUid(null);
            } else {
                eb_user_address.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.RealName);
        if (columnIndex > 0) {
            eb_user_address.setRealName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.Phone);
        if (columnIndex > 0) {
            eb_user_address.setPhone(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.Province);
        if (columnIndex > 0) {
            eb_user_address.setProvince(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.ProvinceId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_address.setProvinceId(null);
            } else {
                eb_user_address.setProvinceId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.City);
        if (columnIndex > 0) {
            eb_user_address.setCity(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.CityId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_address.setCityId(null);
            } else {
                eb_user_address.setCityId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.District);
        if (columnIndex > 0) {
            eb_user_address.setDistrict(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.DistrictId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_address.setDistrictId(null);
            } else {
                eb_user_address.setDistrictId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.Street);
        if (columnIndex > 0) {
            eb_user_address.setStreet(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.Detail);
        if (columnIndex > 0) {
            eb_user_address.setDetail(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.PostCode);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_address.setPostCode(null);
            } else {
                eb_user_address.setPostCode(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.Longitude);
        if (columnIndex > 0) {
            eb_user_address.setLongitude(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.Latitude);
        if (columnIndex > 0) {
            eb_user_address.setLatitude(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.IsDefault);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_address.setIsDefault(null);
            } else {
                eb_user_address.setIsDefault(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_address.setIsDel(null);
            } else {
                eb_user_address.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_address.setCreateTime(null);
            } else {
                eb_user_address.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserAddress_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_address.setUpdateTime(null);
            } else {
                eb_user_address.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_user_address;
    }
}
