package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_USER_BALANCE_RECORD *
 * @author genrator
 */
public class EbUserBalanceRecord_mapper extends EbUserBalanceRecord implements BaseMapper<EbUserBalanceRecord> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbUserBalanceRecord> ROW_MAPPER = new EbUserBalanceRecordRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Uid = "uid";
    public static final String LinkId = "link_id";
    public static final String LinkType = "link_type";
    public static final String Type = "type";
    public static final String Amount = "amount";
    public static final String Balance = "balance";
    public static final String Remark = "remark";
    public static final String CreateTime = "create_time";
    public static final String Sign = "sign";
    public static final String Month = "month";

    /**
     * 默认构造函数
     */
    public EbUserBalanceRecord_mapper(EbUserBalanceRecord ebUserBalanceRecord) {
        if (ebUserBalanceRecord == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebUserBalanceRecord.isset_id) {
            this.setId(ebUserBalanceRecord.getId());
        }
        //普通属性
        if (ebUserBalanceRecord.isset_uid) {
            this.setUid(ebUserBalanceRecord.getUid());
        }
        if (ebUserBalanceRecord.isset_linkId) {
            this.setLinkId(ebUserBalanceRecord.getLinkId());
        }
        if (ebUserBalanceRecord.isset_linkType) {
            this.setLinkType(ebUserBalanceRecord.getLinkType());
        }
        if (ebUserBalanceRecord.isset_type) {
            this.setType(ebUserBalanceRecord.getType());
        }
        if (ebUserBalanceRecord.isset_amount) {
            this.setAmount(ebUserBalanceRecord.getAmount());
        }
        if (ebUserBalanceRecord.isset_balance) {
            this.setBalance(ebUserBalanceRecord.getBalance());
        }
        if (ebUserBalanceRecord.isset_remark) {
            this.setRemark(ebUserBalanceRecord.getRemark());
        }
        if (ebUserBalanceRecord.isset_createTime) {
            this.setCreateTime(ebUserBalanceRecord.getCreateTime());
        }
        if (ebUserBalanceRecord.isset_sign) {
            this.setSign(ebUserBalanceRecord.getSign());
        }
        if (ebUserBalanceRecord.isset_month) {
            this.setMonth(ebUserBalanceRecord.getMonth());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_user_balance_record.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_user_balance_record";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(LinkId, this.getLinkId(), this.isset_linkId);
        ib.set(LinkType, this.getLinkType(), this.isset_linkType);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(Amount, this.getAmount(), this.isset_amount);
        ib.set(Balance, this.getBalance(), this.isset_balance);
        ib.set(Remark, this.getRemark(), this.isset_remark);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(Sign, this.getSign(), this.isset_sign);
        ib.set(Month, this.getMonth(), this.isset_month);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(LinkId, this.getLinkId(), this.isset_linkId);
        ub.set(LinkType, this.getLinkType(), this.isset_linkType);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Amount, this.getAmount(), this.isset_amount);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(Sign, this.getSign(), this.isset_sign);
        ub.set(Month, this.getMonth(), this.isset_month);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(LinkId, this.getLinkId(), this.isset_linkId);
        ub.set(LinkType, this.getLinkType(), this.isset_linkType);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Amount, this.getAmount(), this.isset_amount);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(Sign, this.getSign(), this.isset_sign);
        ub.set(Month, this.getMonth(), this.isset_month);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(LinkId, this.getLinkId(), this.isset_linkId);
        ub.set(LinkType, this.getLinkType(), this.isset_linkType);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Amount, this.getAmount(), this.isset_amount);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(Sign, this.getSign(), this.isset_sign);
        ub.set(Month, this.getMonth(), this.isset_month);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, uid, link_id, link_type, type, amount, balance, remark, create_time, sign, month from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, uid, link_id, link_type, type, amount, balance, remark, create_time, sign, month from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbUserBalanceRecord mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbUserBalanceRecord toEbUserBalanceRecord() {
        return super.$clone();
    }
}

/**
 * eb_user_balance_record RowMapper
 *
 * @author genrator
 */
class EbUserBalanceRecordRowMapper implements RowMapper<EbUserBalanceRecord> {

    @Override
    public EbUserBalanceRecord mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbUserBalanceRecord eb_user_balance_record = new EbUserBalanceRecord();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.Id);
        if (columnIndex > 0) {
            eb_user_balance_record.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_balance_record.setUid(null);
            } else {
                eb_user_balance_record.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.LinkId);
        if (columnIndex > 0) {
            eb_user_balance_record.setLinkId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.LinkType);
        if (columnIndex > 0) {
            eb_user_balance_record.setLinkType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_balance_record.setType(null);
            } else {
                eb_user_balance_record.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.Amount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_balance_record.setAmount(null);
            } else {
                eb_user_balance_record.setAmount(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.Balance);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_balance_record.setBalance(null);
            } else {
                eb_user_balance_record.setBalance(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.Remark);
        if (columnIndex > 0) {
            eb_user_balance_record.setRemark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_balance_record.setCreateTime(null);
            } else {
                eb_user_balance_record.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.Sign);
        if (columnIndex > 0) {
            eb_user_balance_record.setSign(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBalanceRecord_mapper.Month);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_balance_record.setMonth(null);
            } else {
                eb_user_balance_record.setMonth(rs.getInt(columnIndex));
            }
        }
        return eb_user_balance_record;
    }
}
