package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_USER_CONFIG *
 * @author genrator
 */
public class EbUserConfig_mapper extends EbUserConfig implements BaseMapper<EbUserConfig> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbUserConfig> ROW_MAPPER = new EbUserConfigRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String PayPwd = "pay_pwd";
    public static final String Latitude = "latitude";
    public static final String Longitude = "longitude";
    public static final String ConsumeDistance = "consume_distance";
    public static final String ConsumeEnabled = "consume_enabled";
    public static final String ConsumeTimeDay = "consume_time_day";
    public static final String ConsumeTimeWeek = "consume_time_week";
    public static final String ConsumeTimeMonth = "consume_time_month";
    public static final String ConsumeMoneyPer = "consume_money_per";
    public static final String TransferEnabled = "transfer_enabled";
    public static final String TransferMoneyMin = "transfer_money_min";
    public static final String TransferMoneyMax = "transfer_money_max";
    public static final String PlateNumber = "plate_number";
    public static final String IdCard = "id_card";
    public static final String TipMessage = "tip_message";
    public static final String TipMessageTime = "tip_message_time";

    /**
     * 默认构造函数
     */
    public EbUserConfig_mapper(EbUserConfig ebUserConfig) {
        if (ebUserConfig == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebUserConfig.isset_id) {
            this.setId(ebUserConfig.getId());
        }
        //普通属性
        if (ebUserConfig.isset_payPwd) {
            this.setPayPwd(ebUserConfig.getPayPwd());
        }
        if (ebUserConfig.isset_latitude) {
            this.setLatitude(ebUserConfig.getLatitude());
        }
        if (ebUserConfig.isset_longitude) {
            this.setLongitude(ebUserConfig.getLongitude());
        }
        if (ebUserConfig.isset_consumeDistance) {
            this.setConsumeDistance(ebUserConfig.getConsumeDistance());
        }
        if (ebUserConfig.isset_consumeEnabled) {
            this.setConsumeEnabled(ebUserConfig.getConsumeEnabled());
        }
        if (ebUserConfig.isset_consumeTimeDay) {
            this.setConsumeTimeDay(ebUserConfig.getConsumeTimeDay());
        }
        if (ebUserConfig.isset_consumeTimeWeek) {
            this.setConsumeTimeWeek(ebUserConfig.getConsumeTimeWeek());
        }
        if (ebUserConfig.isset_consumeTimeMonth) {
            this.setConsumeTimeMonth(ebUserConfig.getConsumeTimeMonth());
        }
        if (ebUserConfig.isset_consumeMoneyPer) {
            this.setConsumeMoneyPer(ebUserConfig.getConsumeMoneyPer());
        }
        if (ebUserConfig.isset_transferEnabled) {
            this.setTransferEnabled(ebUserConfig.getTransferEnabled());
        }
        if (ebUserConfig.isset_transferMoneyMin) {
            this.setTransferMoneyMin(ebUserConfig.getTransferMoneyMin());
        }
        if (ebUserConfig.isset_transferMoneyMax) {
            this.setTransferMoneyMax(ebUserConfig.getTransferMoneyMax());
        }
        if (ebUserConfig.isset_plateNumber) {
            this.setPlateNumber(ebUserConfig.getPlateNumber());
        }
        if (ebUserConfig.isset_idCard) {
            this.setIdCard(ebUserConfig.getIdCard());
        }
        if (ebUserConfig.isset_tipMessage) {
            this.setTipMessage(ebUserConfig.getTipMessage());
        }
        if (ebUserConfig.isset_tipMessageTime) {
            this.setTipMessageTime(ebUserConfig.getTipMessageTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_user_config.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_user_config";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(PayPwd, this.getPayPwd(), this.isset_payPwd);
        ib.set(Latitude, this.getLatitude(), this.isset_latitude);
        ib.set(Longitude, this.getLongitude(), this.isset_longitude);
        ib.set(ConsumeDistance, this.getConsumeDistance(), this.isset_consumeDistance);
        ib.set(ConsumeEnabled, this.getConsumeEnabled(), this.isset_consumeEnabled);
        ib.set(ConsumeTimeDay, this.getConsumeTimeDay(), this.isset_consumeTimeDay);
        ib.set(ConsumeTimeWeek, this.getConsumeTimeWeek(), this.isset_consumeTimeWeek);
        ib.set(ConsumeTimeMonth, this.getConsumeTimeMonth(), this.isset_consumeTimeMonth);
        ib.set(ConsumeMoneyPer, this.getConsumeMoneyPer(), this.isset_consumeMoneyPer);
        ib.set(TransferEnabled, this.getTransferEnabled(), this.isset_transferEnabled);
        ib.set(TransferMoneyMin, this.getTransferMoneyMin(), this.isset_transferMoneyMin);
        ib.set(TransferMoneyMax, this.getTransferMoneyMax(), this.isset_transferMoneyMax);
        ib.set(PlateNumber, this.getPlateNumber(), this.isset_plateNumber);
        ib.set(IdCard, this.getIdCard(), this.isset_idCard);
        ib.set(TipMessage, this.getTipMessage(), this.isset_tipMessage);
        ib.set(TipMessageTime, this.getTipMessageTime(), this.isset_tipMessageTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PayPwd, this.getPayPwd(), this.isset_payPwd);
        ub.set(Latitude, this.getLatitude(), this.isset_latitude);
        ub.set(Longitude, this.getLongitude(), this.isset_longitude);
        ub.set(ConsumeDistance, this.getConsumeDistance(), this.isset_consumeDistance);
        ub.set(ConsumeEnabled, this.getConsumeEnabled(), this.isset_consumeEnabled);
        ub.set(ConsumeTimeDay, this.getConsumeTimeDay(), this.isset_consumeTimeDay);
        ub.set(ConsumeTimeWeek, this.getConsumeTimeWeek(), this.isset_consumeTimeWeek);
        ub.set(ConsumeTimeMonth, this.getConsumeTimeMonth(), this.isset_consumeTimeMonth);
        ub.set(ConsumeMoneyPer, this.getConsumeMoneyPer(), this.isset_consumeMoneyPer);
        ub.set(TransferEnabled, this.getTransferEnabled(), this.isset_transferEnabled);
        ub.set(TransferMoneyMin, this.getTransferMoneyMin(), this.isset_transferMoneyMin);
        ub.set(TransferMoneyMax, this.getTransferMoneyMax(), this.isset_transferMoneyMax);
        ub.set(PlateNumber, this.getPlateNumber(), this.isset_plateNumber);
        ub.set(IdCard, this.getIdCard(), this.isset_idCard);
        ub.set(TipMessage, this.getTipMessage(), this.isset_tipMessage);
        ub.set(TipMessageTime, this.getTipMessageTime(), this.isset_tipMessageTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PayPwd, this.getPayPwd(), this.isset_payPwd);
        ub.set(Latitude, this.getLatitude(), this.isset_latitude);
        ub.set(Longitude, this.getLongitude(), this.isset_longitude);
        ub.set(ConsumeDistance, this.getConsumeDistance(), this.isset_consumeDistance);
        ub.set(ConsumeEnabled, this.getConsumeEnabled(), this.isset_consumeEnabled);
        ub.set(ConsumeTimeDay, this.getConsumeTimeDay(), this.isset_consumeTimeDay);
        ub.set(ConsumeTimeWeek, this.getConsumeTimeWeek(), this.isset_consumeTimeWeek);
        ub.set(ConsumeTimeMonth, this.getConsumeTimeMonth(), this.isset_consumeTimeMonth);
        ub.set(ConsumeMoneyPer, this.getConsumeMoneyPer(), this.isset_consumeMoneyPer);
        ub.set(TransferEnabled, this.getTransferEnabled(), this.isset_transferEnabled);
        ub.set(TransferMoneyMin, this.getTransferMoneyMin(), this.isset_transferMoneyMin);
        ub.set(TransferMoneyMax, this.getTransferMoneyMax(), this.isset_transferMoneyMax);
        ub.set(PlateNumber, this.getPlateNumber(), this.isset_plateNumber);
        ub.set(IdCard, this.getIdCard(), this.isset_idCard);
        ub.set(TipMessage, this.getTipMessage(), this.isset_tipMessage);
        ub.set(TipMessageTime, this.getTipMessageTime(), this.isset_tipMessageTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(PayPwd, this.getPayPwd(), this.isset_payPwd);
        ub.set(Latitude, this.getLatitude(), this.isset_latitude);
        ub.set(Longitude, this.getLongitude(), this.isset_longitude);
        ub.set(ConsumeDistance, this.getConsumeDistance(), this.isset_consumeDistance);
        ub.set(ConsumeEnabled, this.getConsumeEnabled(), this.isset_consumeEnabled);
        ub.set(ConsumeTimeDay, this.getConsumeTimeDay(), this.isset_consumeTimeDay);
        ub.set(ConsumeTimeWeek, this.getConsumeTimeWeek(), this.isset_consumeTimeWeek);
        ub.set(ConsumeTimeMonth, this.getConsumeTimeMonth(), this.isset_consumeTimeMonth);
        ub.set(ConsumeMoneyPer, this.getConsumeMoneyPer(), this.isset_consumeMoneyPer);
        ub.set(TransferEnabled, this.getTransferEnabled(), this.isset_transferEnabled);
        ub.set(TransferMoneyMin, this.getTransferMoneyMin(), this.isset_transferMoneyMin);
        ub.set(TransferMoneyMax, this.getTransferMoneyMax(), this.isset_transferMoneyMax);
        ub.set(PlateNumber, this.getPlateNumber(), this.isset_plateNumber);
        ub.set(IdCard, this.getIdCard(), this.isset_idCard);
        ub.set(TipMessage, this.getTipMessage(), this.isset_tipMessage);
        ub.set(TipMessageTime, this.getTipMessageTime(), this.isset_tipMessageTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, pay_pwd, latitude, longitude, consume_distance, consume_enabled, consume_time_day, consume_time_week, consume_time_month, consume_money_per, transfer_enabled, transfer_money_min, transfer_money_max, plate_number, id_card, tip_message, tip_message_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, pay_pwd, latitude, longitude, consume_distance, consume_enabled, consume_time_day, consume_time_week, consume_time_month, consume_money_per, transfer_enabled, transfer_money_min, transfer_money_max, plate_number, id_card, tip_message, tip_message_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbUserConfig mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbUserConfig toEbUserConfig() {
        return super.$clone();
    }
}

/**
 * eb_user_config RowMapper
 *
 * @author genrator
 */
class EbUserConfigRowMapper implements RowMapper<EbUserConfig> {

    @Override
    public EbUserConfig mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbUserConfig eb_user_config = new EbUserConfig();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.Id);
        if (columnIndex > 0) {
            eb_user_config.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.PayPwd);
        if (columnIndex > 0) {
            eb_user_config.setPayPwd(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.Latitude);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setLatitude(null);
            } else {
                eb_user_config.setLatitude(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.Longitude);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setLongitude(null);
            } else {
                eb_user_config.setLongitude(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.ConsumeDistance);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setConsumeDistance(null);
            } else {
                eb_user_config.setConsumeDistance(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.ConsumeEnabled);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setConsumeEnabled(null);
            } else {
                eb_user_config.setConsumeEnabled(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.ConsumeTimeDay);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setConsumeTimeDay(null);
            } else {
                eb_user_config.setConsumeTimeDay(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.ConsumeTimeWeek);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setConsumeTimeWeek(null);
            } else {
                eb_user_config.setConsumeTimeWeek(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.ConsumeTimeMonth);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setConsumeTimeMonth(null);
            } else {
                eb_user_config.setConsumeTimeMonth(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.ConsumeMoneyPer);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setConsumeMoneyPer(null);
            } else {
                eb_user_config.setConsumeMoneyPer(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.TransferEnabled);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setTransferEnabled(null);
            } else {
                eb_user_config.setTransferEnabled(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.TransferMoneyMin);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setTransferMoneyMin(null);
            } else {
                eb_user_config.setTransferMoneyMin(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.TransferMoneyMax);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setTransferMoneyMax(null);
            } else {
                eb_user_config.setTransferMoneyMax(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.PlateNumber);
        if (columnIndex > 0) {
            eb_user_config.setPlateNumber(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.IdCard);
        if (columnIndex > 0) {
            eb_user_config.setIdCard(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.TipMessage);
        if (columnIndex > 0) {
            eb_user_config.setTipMessage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserConfig_mapper.TipMessageTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_config.setTipMessageTime(null);
            } else {
                eb_user_config.setTipMessageTime(rs.getLong(columnIndex));
            }
        }
        return eb_user_config;
    }
}
