package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_USER_LEVEL *
 * @author genrator
 */
public class EbUserLevel_mapper extends EbUserLevel implements BaseMapper<EbUserLevel> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbUserLevel> ROW_MAPPER = new EbUserLevelRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Uid = "uid";
    public static final String LevelId = "level_id";
    public static final String Grade = "grade";
    public static final String Discount = "discount";
    public static final String Mark = "mark";
    public static final String ExpiredTime = "expired_time";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbUserLevel_mapper(EbUserLevel ebUserLevel) {
        if (ebUserLevel == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebUserLevel.isset_id) {
            this.setId(ebUserLevel.getId());
        }
        //普通属性
        if (ebUserLevel.isset_uid) {
            this.setUid(ebUserLevel.getUid());
        }
        if (ebUserLevel.isset_levelId) {
            this.setLevelId(ebUserLevel.getLevelId());
        }
        if (ebUserLevel.isset_grade) {
            this.setGrade(ebUserLevel.getGrade());
        }
        if (ebUserLevel.isset_discount) {
            this.setDiscount(ebUserLevel.getDiscount());
        }
        if (ebUserLevel.isset_mark) {
            this.setMark(ebUserLevel.getMark());
        }
        if (ebUserLevel.isset_expiredTime) {
            this.setExpiredTime(ebUserLevel.getExpiredTime());
        }
        if (ebUserLevel.isset_isDel) {
            this.setIsDel(ebUserLevel.getIsDel());
        }
        if (ebUserLevel.isset_createTime) {
            this.setCreateTime(ebUserLevel.getCreateTime());
        }
        if (ebUserLevel.isset_updateTime) {
            this.setUpdateTime(ebUserLevel.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_user_level.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_user_level";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(LevelId, this.getLevelId(), this.isset_levelId);
        ib.set(Grade, this.getGrade(), this.isset_grade);
        ib.set(Discount, this.getDiscount(), this.isset_discount);
        ib.set(Mark, this.getMark(), this.isset_mark);
        ib.set(ExpiredTime, this.getExpiredTime(), this.isset_expiredTime);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(LevelId, this.getLevelId(), this.isset_levelId);
        ub.set(Grade, this.getGrade(), this.isset_grade);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(ExpiredTime, this.getExpiredTime(), this.isset_expiredTime);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(LevelId, this.getLevelId(), this.isset_levelId);
        ub.set(Grade, this.getGrade(), this.isset_grade);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(ExpiredTime, this.getExpiredTime(), this.isset_expiredTime);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(LevelId, this.getLevelId(), this.isset_levelId);
        ub.set(Grade, this.getGrade(), this.isset_grade);
        ub.set(Discount, this.getDiscount(), this.isset_discount);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(ExpiredTime, this.getExpiredTime(), this.isset_expiredTime);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, uid, level_id, grade, discount, mark, expired_time, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, uid, level_id, grade, discount, mark, expired_time, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbUserLevel mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbUserLevel toEbUserLevel() {
        return super.$clone();
    }
}

/**
 * eb_user_level RowMapper
 *
 * @author genrator
 */
class EbUserLevelRowMapper implements RowMapper<EbUserLevel> {

    @Override
    public EbUserLevel mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbUserLevel eb_user_level = new EbUserLevel();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.Id);
        if (columnIndex > 0) {
            eb_user_level.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_level.setUid(null);
            } else {
                eb_user_level.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.LevelId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_level.setLevelId(null);
            } else {
                eb_user_level.setLevelId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.Grade);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_level.setGrade(null);
            } else {
                eb_user_level.setGrade(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.Discount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_level.setDiscount(null);
            } else {
                eb_user_level.setDiscount(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.Mark);
        if (columnIndex > 0) {
            eb_user_level.setMark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.ExpiredTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_level.setExpiredTime(null);
            } else {
                eb_user_level.setExpiredTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_level.setIsDel(null);
            } else {
                eb_user_level.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_level.setCreateTime(null);
            } else {
                eb_user_level.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserLevel_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_level.setUpdateTime(null);
            } else {
                eb_user_level.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_user_level;
    }
}
