
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_USER_TOKEN *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbUserToken extends BasePo<EbUserToken> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Long uid = null;
    @JsonIgnore
    protected boolean isset_uid = false;

    private String token = null;
    @JsonIgnore
    protected boolean isset_token = false;

    private Integer type = null;
    @JsonIgnore
    protected boolean isset_type = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long expiresTime = null;
    @JsonIgnore
    protected boolean isset_expiresTime = false;

    private String loginIp = null;
    @JsonIgnore
    protected boolean isset_loginIp = false;

    private Integer isDel = null;
    @JsonIgnore
    protected boolean isset_isDel = false;

    /**
     * 默认构造函数
     */
    public EbUserToken() {
    }

    /**
     * 根据主键构造对象
     */
    public EbUserToken(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
        this.isset_uid = true;
    }

    @JsonIgnore
    public boolean isEmptyUid() {
        return this.uid == null;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
        this.isset_token = true;
    }

    @JsonIgnore
    public boolean isEmptyToken() {
        return this.token == null || this.token.length() == 0;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
        this.isset_type = true;
    }

    @JsonIgnore
    public boolean isEmptyType() {
        return this.type == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getExpiresTime() {
        return this.expiresTime;
    }

    public void setExpiresTime(Long expiresTime) {
        this.expiresTime = expiresTime;
        this.isset_expiresTime = true;
    }

    @JsonIgnore
    public boolean isEmptyExpiresTime() {
        return this.expiresTime == null;
    }

    public String getLoginIp() {
        return this.loginIp;
    }

    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
        this.isset_loginIp = true;
    }

    @JsonIgnore
    public boolean isEmptyLoginIp() {
        return this.loginIp == null || this.loginIp.length() == 0;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
        this.isset_isDel = true;
    }

    @JsonIgnore
    public boolean isEmptyIsDel() {
        return this.isDel == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("uid=").append(this.uid)
                .append("token=").append(this.token)
                .append("type=").append(this.type)
                .append("createTime=").append(this.createTime)
                .append("expiresTime=").append(this.expiresTime)
                .append("loginIp=").append(this.loginIp)
                .append("isDel=").append(this.isDel)
                .toString();
    }

    /**
     * 克隆
     */
    public EbUserToken $clone() {
        EbUserToken eb_user_token = new EbUserToken();

        // 数据库名称
        //eb_user_token.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_user_token.setId(this.getId());
        }
        // 普通属性
        if (this.isset_uid) {
            eb_user_token.setUid(this.getUid());
        }
        if (this.isset_token) {
            eb_user_token.setToken(this.getToken());
        }
        if (this.isset_type) {
            eb_user_token.setType(this.getType());
        }
        if (this.isset_createTime) {
            eb_user_token.setCreateTime(this.getCreateTime());
        }
        if (this.isset_expiresTime) {
            eb_user_token.setExpiresTime(this.getExpiresTime());
        }
        if (this.isset_loginIp) {
            eb_user_token.setLoginIp(this.getLoginIp());
        }
        if (this.isset_isDel) {
            eb_user_token.setIsDel(this.getIsDel());
        }
        return eb_user_token;
    }
}
