package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_USER *
 * @author genrator
 */
public class EbUser_mapper extends EbUser implements BaseMapper<EbUser> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbUser> ROW_MAPPER = new EbUserRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Account = "account";
    public static final String Pwd = "pwd";
    public static final String RealName = "real_name";
    public static final String Birthday = "birthday";
    public static final String IdentityCardNo = "identity_card_no";
    public static final String TagId = "tag_id";
    public static final String Nickname = "nickname";
    public static final String Avatar = "avatar";
    public static final String Phone = "phone";
    public static final String Country = "country";
    public static final String Province = "province";
    public static final String City = "city";
    public static final String District = "district";
    public static final String Address = "address";
    public static final String Sex = "sex";
    public static final String Integral = "integral";
    public static final String Experience = "experience";
    public static final String NowMoney = "now_money";
    public static final String BrokeragePrice = "brokerage_price";
    public static final String Level = "level";
    public static final String SignNum = "sign_num";
    public static final String IsWechatPublic = "is_wechat_public";
    public static final String IsWechatRoutine = "is_wechat_routine";
    public static final String PayCount = "pay_count";
    public static final String IsPromoter = "is_promoter";
    public static final String PromoterTime = "promoter_time";
    public static final String SpreadUid = "spread_uid";
    public static final String SpreadTime = "spread_time";
    public static final String SpreadCount = "spread_count";
    public static final String RegisterType = "register_type";
    public static final String AddIp = "add_ip";
    public static final String LastIp = "last_ip";
    public static final String LastLoginTime = "last_login_time";
    public static final String Status = "status";
    public static final String Mark = "mark";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";
    public static final String IsLogoff = "is_logoff";
    public static final String LogoffTime = "logoff_time";
    public static final String IsWechatIos = "is_wechat_ios";
    public static final String IsWechatAndroid = "is_wechat_android";
    public static final String IsBindingIos = "is_binding_ios";
    public static final String MoneySign = "money_sign";

    /**
     * 默认构造函数
     */
    public EbUser_mapper(EbUser ebUser) {
        if (ebUser == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebUser.isset_id) {
            this.setId(ebUser.getId());
        }
        //普通属性
        if (ebUser.isset_account) {
            this.setAccount(ebUser.getAccount());
        }
        if (ebUser.isset_pwd) {
            this.setPwd(ebUser.getPwd());
        }
        if (ebUser.isset_realName) {
            this.setRealName(ebUser.getRealName());
        }
        if (ebUser.isset_birthday) {
            this.setBirthday(ebUser.getBirthday());
        }
        if (ebUser.isset_identityCardNo) {
            this.setIdentityCardNo(ebUser.getIdentityCardNo());
        }
        if (ebUser.isset_tagId) {
            this.setTagId(ebUser.getTagId());
        }
        if (ebUser.isset_nickname) {
            this.setNickname(ebUser.getNickname());
        }
        if (ebUser.isset_avatar) {
            this.setAvatar(ebUser.getAvatar());
        }
        if (ebUser.isset_phone) {
            this.setPhone(ebUser.getPhone());
        }
        if (ebUser.isset_country) {
            this.setCountry(ebUser.getCountry());
        }
        if (ebUser.isset_province) {
            this.setProvince(ebUser.getProvince());
        }
        if (ebUser.isset_city) {
            this.setCity(ebUser.getCity());
        }
        if (ebUser.isset_district) {
            this.setDistrict(ebUser.getDistrict());
        }
        if (ebUser.isset_address) {
            this.setAddress(ebUser.getAddress());
        }
        if (ebUser.isset_sex) {
            this.setSex(ebUser.getSex());
        }
        if (ebUser.isset_integral) {
            this.setIntegral(ebUser.getIntegral());
        }
        if (ebUser.isset_experience) {
            this.setExperience(ebUser.getExperience());
        }
        if (ebUser.isset_nowMoney) {
            this.setNowMoney(ebUser.getNowMoney());
        }
        if (ebUser.isset_brokeragePrice) {
            this.setBrokeragePrice(ebUser.getBrokeragePrice());
        }
        if (ebUser.isset_level) {
            this.setLevel(ebUser.getLevel());
        }
        if (ebUser.isset_signNum) {
            this.setSignNum(ebUser.getSignNum());
        }
        if (ebUser.isset_isWechatPublic) {
            this.setIsWechatPublic(ebUser.getIsWechatPublic());
        }
        if (ebUser.isset_isWechatRoutine) {
            this.setIsWechatRoutine(ebUser.getIsWechatRoutine());
        }
        if (ebUser.isset_payCount) {
            this.setPayCount(ebUser.getPayCount());
        }
        if (ebUser.isset_isPromoter) {
            this.setIsPromoter(ebUser.getIsPromoter());
        }
        if (ebUser.isset_promoterTime) {
            this.setPromoterTime(ebUser.getPromoterTime());
        }
        if (ebUser.isset_spreadUid) {
            this.setSpreadUid(ebUser.getSpreadUid());
        }
        if (ebUser.isset_spreadTime) {
            this.setSpreadTime(ebUser.getSpreadTime());
        }
        if (ebUser.isset_spreadCount) {
            this.setSpreadCount(ebUser.getSpreadCount());
        }
        if (ebUser.isset_registerType) {
            this.setRegisterType(ebUser.getRegisterType());
        }
        if (ebUser.isset_addIp) {
            this.setAddIp(ebUser.getAddIp());
        }
        if (ebUser.isset_lastIp) {
            this.setLastIp(ebUser.getLastIp());
        }
        if (ebUser.isset_lastLoginTime) {
            this.setLastLoginTime(ebUser.getLastLoginTime());
        }
        if (ebUser.isset_status) {
            this.setStatus(ebUser.getStatus());
        }
        if (ebUser.isset_mark) {
            this.setMark(ebUser.getMark());
        }
        if (ebUser.isset_createTime) {
            this.setCreateTime(ebUser.getCreateTime());
        }
        if (ebUser.isset_updateTime) {
            this.setUpdateTime(ebUser.getUpdateTime());
        }
        if (ebUser.isset_isLogoff) {
            this.setIsLogoff(ebUser.getIsLogoff());
        }
        if (ebUser.isset_logoffTime) {
            this.setLogoffTime(ebUser.getLogoffTime());
        }
        if (ebUser.isset_isWechatIos) {
            this.setIsWechatIos(ebUser.getIsWechatIos());
        }
        if (ebUser.isset_isWechatAndroid) {
            this.setIsWechatAndroid(ebUser.getIsWechatAndroid());
        }
        if (ebUser.isset_isBindingIos) {
            this.setIsBindingIos(ebUser.getIsBindingIos());
        }
        if (ebUser.isset_moneySign) {
            this.setMoneySign(ebUser.getMoneySign());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_user.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_user";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Account, this.getAccount(), this.isset_account);
        ib.set(Pwd, this.getPwd(), this.isset_pwd);
        ib.set(RealName, this.getRealName(), this.isset_realName);
        ib.set(Birthday, this.getBirthday(), this.isset_birthday);
        ib.set(IdentityCardNo, this.getIdentityCardNo(), this.isset_identityCardNo);
        ib.set(TagId, this.getTagId(), this.isset_tagId);
        ib.set(Nickname, this.getNickname(), this.isset_nickname);
        ib.set(Avatar, this.getAvatar(), this.isset_avatar);
        ib.set(Phone, this.getPhone(), this.isset_phone);
        ib.set(Country, this.getCountry(), this.isset_country);
        ib.set(Province, this.getProvince(), this.isset_province);
        ib.set(City, this.getCity(), this.isset_city);
        ib.set(District, this.getDistrict(), this.isset_district);
        ib.set(Address, this.getAddress(), this.isset_address);
        ib.set(Sex, this.getSex(), this.isset_sex);
        ib.set(Integral, this.getIntegral(), this.isset_integral);
        ib.set(Experience, this.getExperience(), this.isset_experience);
        ib.set(NowMoney, this.getNowMoney(), this.isset_nowMoney);
        ib.set(BrokeragePrice, this.getBrokeragePrice(), this.isset_brokeragePrice);
        ib.set(Level, this.getLevel(), this.isset_level);
        ib.set(SignNum, this.getSignNum(), this.isset_signNum);
        ib.set(IsWechatPublic, this.getIsWechatPublic(), this.isset_isWechatPublic);
        ib.set(IsWechatRoutine, this.getIsWechatRoutine(), this.isset_isWechatRoutine);
        ib.set(PayCount, this.getPayCount(), this.isset_payCount);
        ib.set(IsPromoter, this.getIsPromoter(), this.isset_isPromoter);
        ib.set(PromoterTime, this.getPromoterTime(), this.isset_promoterTime);
        ib.set(SpreadUid, this.getSpreadUid(), this.isset_spreadUid);
        ib.set(SpreadTime, this.getSpreadTime(), this.isset_spreadTime);
        ib.set(SpreadCount, this.getSpreadCount(), this.isset_spreadCount);
        ib.set(RegisterType, this.getRegisterType(), this.isset_registerType);
        ib.set(AddIp, this.getAddIp(), this.isset_addIp);
        ib.set(LastIp, this.getLastIp(), this.isset_lastIp);
        ib.set(LastLoginTime, this.getLastLoginTime(), this.isset_lastLoginTime);
        ib.set(Status, this.getStatus(), this.isset_status);
        ib.set(Mark, this.getMark(), this.isset_mark);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ib.set(IsLogoff, this.getIsLogoff(), this.isset_isLogoff);
        ib.set(LogoffTime, this.getLogoffTime(), this.isset_logoffTime);
        ib.set(IsWechatIos, this.getIsWechatIos(), this.isset_isWechatIos);
        ib.set(IsWechatAndroid, this.getIsWechatAndroid(), this.isset_isWechatAndroid);
        ib.set(IsBindingIos, this.getIsBindingIos(), this.isset_isBindingIos);
        ib.set(MoneySign, this.getMoneySign(), this.isset_moneySign);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Account, this.getAccount(), this.isset_account);
        ub.set(Pwd, this.getPwd(), this.isset_pwd);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Birthday, this.getBirthday(), this.isset_birthday);
        ub.set(IdentityCardNo, this.getIdentityCardNo(), this.isset_identityCardNo);
        ub.set(TagId, this.getTagId(), this.isset_tagId);
        ub.set(Nickname, this.getNickname(), this.isset_nickname);
        ub.set(Avatar, this.getAvatar(), this.isset_avatar);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(Country, this.getCountry(), this.isset_country);
        ub.set(Province, this.getProvince(), this.isset_province);
        ub.set(City, this.getCity(), this.isset_city);
        ub.set(District, this.getDistrict(), this.isset_district);
        ub.set(Address, this.getAddress(), this.isset_address);
        ub.set(Sex, this.getSex(), this.isset_sex);
        ub.set(Integral, this.getIntegral(), this.isset_integral);
        ub.set(Experience, this.getExperience(), this.isset_experience);
        ub.set(NowMoney, this.getNowMoney(), this.isset_nowMoney);
        ub.set(BrokeragePrice, this.getBrokeragePrice(), this.isset_brokeragePrice);
        ub.set(Level, this.getLevel(), this.isset_level);
        ub.set(SignNum, this.getSignNum(), this.isset_signNum);
        ub.set(IsWechatPublic, this.getIsWechatPublic(), this.isset_isWechatPublic);
        ub.set(IsWechatRoutine, this.getIsWechatRoutine(), this.isset_isWechatRoutine);
        ub.set(PayCount, this.getPayCount(), this.isset_payCount);
        ub.set(IsPromoter, this.getIsPromoter(), this.isset_isPromoter);
        ub.set(PromoterTime, this.getPromoterTime(), this.isset_promoterTime);
        ub.set(SpreadUid, this.getSpreadUid(), this.isset_spreadUid);
        ub.set(SpreadTime, this.getSpreadTime(), this.isset_spreadTime);
        ub.set(SpreadCount, this.getSpreadCount(), this.isset_spreadCount);
        ub.set(RegisterType, this.getRegisterType(), this.isset_registerType);
        ub.set(AddIp, this.getAddIp(), this.isset_addIp);
        ub.set(LastIp, this.getLastIp(), this.isset_lastIp);
        ub.set(LastLoginTime, this.getLastLoginTime(), this.isset_lastLoginTime);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(IsLogoff, this.getIsLogoff(), this.isset_isLogoff);
        ub.set(LogoffTime, this.getLogoffTime(), this.isset_logoffTime);
        ub.set(IsWechatIos, this.getIsWechatIos(), this.isset_isWechatIos);
        ub.set(IsWechatAndroid, this.getIsWechatAndroid(), this.isset_isWechatAndroid);
        ub.set(IsBindingIos, this.getIsBindingIos(), this.isset_isBindingIos);
        ub.set(MoneySign, this.getMoneySign(), this.isset_moneySign);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Account, this.getAccount(), this.isset_account);
        ub.set(Pwd, this.getPwd(), this.isset_pwd);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Birthday, this.getBirthday(), this.isset_birthday);
        ub.set(IdentityCardNo, this.getIdentityCardNo(), this.isset_identityCardNo);
        ub.set(TagId, this.getTagId(), this.isset_tagId);
        ub.set(Nickname, this.getNickname(), this.isset_nickname);
        ub.set(Avatar, this.getAvatar(), this.isset_avatar);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(Country, this.getCountry(), this.isset_country);
        ub.set(Province, this.getProvince(), this.isset_province);
        ub.set(City, this.getCity(), this.isset_city);
        ub.set(District, this.getDistrict(), this.isset_district);
        ub.set(Address, this.getAddress(), this.isset_address);
        ub.set(Sex, this.getSex(), this.isset_sex);
        ub.set(Integral, this.getIntegral(), this.isset_integral);
        ub.set(Experience, this.getExperience(), this.isset_experience);
        ub.set(NowMoney, this.getNowMoney(), this.isset_nowMoney);
        ub.set(BrokeragePrice, this.getBrokeragePrice(), this.isset_brokeragePrice);
        ub.set(Level, this.getLevel(), this.isset_level);
        ub.set(SignNum, this.getSignNum(), this.isset_signNum);
        ub.set(IsWechatPublic, this.getIsWechatPublic(), this.isset_isWechatPublic);
        ub.set(IsWechatRoutine, this.getIsWechatRoutine(), this.isset_isWechatRoutine);
        ub.set(PayCount, this.getPayCount(), this.isset_payCount);
        ub.set(IsPromoter, this.getIsPromoter(), this.isset_isPromoter);
        ub.set(PromoterTime, this.getPromoterTime(), this.isset_promoterTime);
        ub.set(SpreadUid, this.getSpreadUid(), this.isset_spreadUid);
        ub.set(SpreadTime, this.getSpreadTime(), this.isset_spreadTime);
        ub.set(SpreadCount, this.getSpreadCount(), this.isset_spreadCount);
        ub.set(RegisterType, this.getRegisterType(), this.isset_registerType);
        ub.set(AddIp, this.getAddIp(), this.isset_addIp);
        ub.set(LastIp, this.getLastIp(), this.isset_lastIp);
        ub.set(LastLoginTime, this.getLastLoginTime(), this.isset_lastLoginTime);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(IsLogoff, this.getIsLogoff(), this.isset_isLogoff);
        ub.set(LogoffTime, this.getLogoffTime(), this.isset_logoffTime);
        ub.set(IsWechatIos, this.getIsWechatIos(), this.isset_isWechatIos);
        ub.set(IsWechatAndroid, this.getIsWechatAndroid(), this.isset_isWechatAndroid);
        ub.set(IsBindingIos, this.getIsBindingIos(), this.isset_isBindingIos);
        ub.set(MoneySign, this.getMoneySign(), this.isset_moneySign);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Account, this.getAccount(), this.isset_account);
        ub.set(Pwd, this.getPwd(), this.isset_pwd);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(Birthday, this.getBirthday(), this.isset_birthday);
        ub.set(IdentityCardNo, this.getIdentityCardNo(), this.isset_identityCardNo);
        ub.set(TagId, this.getTagId(), this.isset_tagId);
        ub.set(Nickname, this.getNickname(), this.isset_nickname);
        ub.set(Avatar, this.getAvatar(), this.isset_avatar);
        ub.set(Phone, this.getPhone(), this.isset_phone);
        ub.set(Country, this.getCountry(), this.isset_country);
        ub.set(Province, this.getProvince(), this.isset_province);
        ub.set(City, this.getCity(), this.isset_city);
        ub.set(District, this.getDistrict(), this.isset_district);
        ub.set(Address, this.getAddress(), this.isset_address);
        ub.set(Sex, this.getSex(), this.isset_sex);
        ub.set(Integral, this.getIntegral(), this.isset_integral);
        ub.set(Experience, this.getExperience(), this.isset_experience);
        ub.set(NowMoney, this.getNowMoney(), this.isset_nowMoney);
        ub.set(BrokeragePrice, this.getBrokeragePrice(), this.isset_brokeragePrice);
        ub.set(Level, this.getLevel(), this.isset_level);
        ub.set(SignNum, this.getSignNum(), this.isset_signNum);
        ub.set(IsWechatPublic, this.getIsWechatPublic(), this.isset_isWechatPublic);
        ub.set(IsWechatRoutine, this.getIsWechatRoutine(), this.isset_isWechatRoutine);
        ub.set(PayCount, this.getPayCount(), this.isset_payCount);
        ub.set(IsPromoter, this.getIsPromoter(), this.isset_isPromoter);
        ub.set(PromoterTime, this.getPromoterTime(), this.isset_promoterTime);
        ub.set(SpreadUid, this.getSpreadUid(), this.isset_spreadUid);
        ub.set(SpreadTime, this.getSpreadTime(), this.isset_spreadTime);
        ub.set(SpreadCount, this.getSpreadCount(), this.isset_spreadCount);
        ub.set(RegisterType, this.getRegisterType(), this.isset_registerType);
        ub.set(AddIp, this.getAddIp(), this.isset_addIp);
        ub.set(LastIp, this.getLastIp(), this.isset_lastIp);
        ub.set(LastLoginTime, this.getLastLoginTime(), this.isset_lastLoginTime);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(IsLogoff, this.getIsLogoff(), this.isset_isLogoff);
        ub.set(LogoffTime, this.getLogoffTime(), this.isset_logoffTime);
        ub.set(IsWechatIos, this.getIsWechatIos(), this.isset_isWechatIos);
        ub.set(IsWechatAndroid, this.getIsWechatAndroid(), this.isset_isWechatAndroid);
        ub.set(IsBindingIos, this.getIsBindingIos(), this.isset_isBindingIos);
        ub.set(MoneySign, this.getMoneySign(), this.isset_moneySign);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, account, pwd, real_name, birthday, identity_card_no, tag_id, nickname, avatar, phone, country, province, city, district, address, sex, integral, experience, now_money, brokerage_price, level, sign_num, is_wechat_public, is_wechat_routine, pay_count, is_promoter, promoter_time, spread_uid, spread_time, spread_count, register_type, add_ip, last_ip, last_login_time, status, mark, create_time, update_time, is_logoff, logoff_time, is_wechat_ios, is_wechat_android, is_binding_ios, money_sign from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, account, pwd, real_name, birthday, identity_card_no, tag_id, nickname, avatar, phone, country, province, city, district, address, sex, integral, experience, now_money, brokerage_price, level, sign_num, is_wechat_public, is_wechat_routine, pay_count, is_promoter, promoter_time, spread_uid, spread_time, spread_count, register_type, add_ip, last_ip, last_login_time, status, mark, create_time, update_time, is_logoff, logoff_time, is_wechat_ios, is_wechat_android, is_binding_ios, money_sign from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbUser mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbUser toEbUser() {
        return super.$clone();
    }
}

/**
 * eb_user RowMapper
 *
 * @author genrator
 */
class EbUserRowMapper implements RowMapper<EbUser> {

    @Override
    public EbUser mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbUser eb_user = new EbUser();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Id);
        if (columnIndex > 0) {
            eb_user.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Account);
        if (columnIndex > 0) {
            eb_user.setAccount(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Pwd);
        if (columnIndex > 0) {
            eb_user.setPwd(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.RealName);
        if (columnIndex > 0) {
            eb_user.setRealName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Birthday);
        if (columnIndex > 0) {
            eb_user.setBirthday(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.IdentityCardNo);
        if (columnIndex > 0) {
            eb_user.setIdentityCardNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.TagId);
        if (columnIndex > 0) {
            eb_user.setTagId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Nickname);
        if (columnIndex > 0) {
            eb_user.setNickname(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Avatar);
        if (columnIndex > 0) {
            eb_user.setAvatar(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Phone);
        if (columnIndex > 0) {
            eb_user.setPhone(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Country);
        if (columnIndex > 0) {
            eb_user.setCountry(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Province);
        if (columnIndex > 0) {
            eb_user.setProvince(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.City);
        if (columnIndex > 0) {
            eb_user.setCity(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.District);
        if (columnIndex > 0) {
            eb_user.setDistrict(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Address);
        if (columnIndex > 0) {
            eb_user.setAddress(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Sex);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setSex(null);
            } else {
                eb_user.setSex(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Integral);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setIntegral(null);
            } else {
                eb_user.setIntegral(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Experience);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setExperience(null);
            } else {
                eb_user.setExperience(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.NowMoney);
        if (columnIndex > 0) {
            eb_user.setNowMoney(rs.getDouble(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.BrokeragePrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setBrokeragePrice(null);
            } else {
                eb_user.setBrokeragePrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Level);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setLevel(null);
            } else {
                eb_user.setLevel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.SignNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setSignNum(null);
            } else {
                eb_user.setSignNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.IsWechatPublic);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setIsWechatPublic(null);
            } else {
                eb_user.setIsWechatPublic(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.IsWechatRoutine);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setIsWechatRoutine(null);
            } else {
                eb_user.setIsWechatRoutine(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.PayCount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setPayCount(null);
            } else {
                eb_user.setPayCount(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.IsPromoter);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setIsPromoter(null);
            } else {
                eb_user.setIsPromoter(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.PromoterTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setPromoterTime(null);
            } else {
                eb_user.setPromoterTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.SpreadUid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setSpreadUid(null);
            } else {
                eb_user.setSpreadUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.SpreadTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setSpreadTime(null);
            } else {
                eb_user.setSpreadTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.SpreadCount);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setSpreadCount(null);
            } else {
                eb_user.setSpreadCount(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.RegisterType);
        if (columnIndex > 0) {
            eb_user.setRegisterType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.AddIp);
        if (columnIndex > 0) {
            eb_user.setAddIp(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.LastIp);
        if (columnIndex > 0) {
            eb_user.setLastIp(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.LastLoginTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setLastLoginTime(null);
            } else {
                eb_user.setLastLoginTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setStatus(null);
            } else {
                eb_user.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.Mark);
        if (columnIndex > 0) {
            eb_user.setMark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setCreateTime(null);
            } else {
                eb_user.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setUpdateTime(null);
            } else {
                eb_user.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.IsLogoff);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setIsLogoff(null);
            } else {
                eb_user.setIsLogoff(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.LogoffTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setLogoffTime(null);
            } else {
                eb_user.setLogoffTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.IsWechatIos);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setIsWechatIos(null);
            } else {
                eb_user.setIsWechatIos(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.IsWechatAndroid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setIsWechatAndroid(null);
            } else {
                eb_user.setIsWechatAndroid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.IsBindingIos);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user.setIsBindingIos(null);
            } else {
                eb_user.setIsBindingIos(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUser_mapper.MoneySign);
        if (columnIndex > 0) {
            eb_user.setMoneySign(rs.getString(columnIndex));
        }
        return eb_user;
    }
}
