
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_WECHAT_CALLBACK *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbWechatCallback extends BasePo<EbWechatCallback> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String toUserName = null;
    @JsonIgnore
    protected boolean isset_toUserName = false;

    private String fromUserName = null;
    @JsonIgnore
    protected boolean isset_fromUserName = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private String msgType = null;
    @JsonIgnore
    protected boolean isset_msgType = false;

    private String event = null;
    @JsonIgnore
    protected boolean isset_event = false;

    private String content = null;
    @JsonIgnore
    protected boolean isset_content = false;

    private Long addTime = null;
    @JsonIgnore
    protected boolean isset_addTime = false;

    /**
     * 默认构造函数
     */
    public EbWechatCallback() {
    }

    /**
     * 根据主键构造对象
     */
    public EbWechatCallback(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public String getToUserName() {
        return this.toUserName;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
        this.isset_toUserName = true;
    }

    @JsonIgnore
    public boolean isEmptyToUserName() {
        return this.toUserName == null || this.toUserName.length() == 0;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
        this.isset_fromUserName = true;
    }

    @JsonIgnore
    public boolean isEmptyFromUserName() {
        return this.fromUserName == null || this.fromUserName.length() == 0;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
        this.isset_msgType = true;
    }

    @JsonIgnore
    public boolean isEmptyMsgType() {
        return this.msgType == null || this.msgType.length() == 0;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
        this.isset_event = true;
    }

    @JsonIgnore
    public boolean isEmptyEvent() {
        return this.event == null || this.event.length() == 0;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.isset_content = true;
    }

    @JsonIgnore
    public boolean isEmptyContent() {
        return this.content == null || this.content.length() == 0;
    }

    public Long getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Long addTime) {
        this.addTime = addTime;
        this.isset_addTime = true;
    }

    @JsonIgnore
    public boolean isEmptyAddTime() {
        return this.addTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("toUserName=").append(this.toUserName)
                .append("fromUserName=").append(this.fromUserName)
                .append("createTime=").append(this.createTime)
                .append("msgType=").append(this.msgType)
                .append("event=").append(this.event)
                .append("content=").append(this.content)
                .append("addTime=").append(this.addTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbWechatCallback $clone() {
        EbWechatCallback eb_wechat_callback = new EbWechatCallback();

        // 数据库名称
        //eb_wechat_callback.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_wechat_callback.setId(this.getId());
        }
        // 普通属性
        if (this.isset_toUserName) {
            eb_wechat_callback.setToUserName(this.getToUserName());
        }
        if (this.isset_fromUserName) {
            eb_wechat_callback.setFromUserName(this.getFromUserName());
        }
        if (this.isset_createTime) {
            eb_wechat_callback.setCreateTime(this.getCreateTime());
        }
        if (this.isset_msgType) {
            eb_wechat_callback.setMsgType(this.getMsgType());
        }
        if (this.isset_event) {
            eb_wechat_callback.setEvent(this.getEvent());
        }
        if (this.isset_content) {
            eb_wechat_callback.setContent(this.getContent());
        }
        if (this.isset_addTime) {
            eb_wechat_callback.setAddTime(this.getAddTime());
        }
        return eb_wechat_callback;
    }
}
