
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_WECHAT_EXCEPTIONS *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbWechatExceptions extends BasePo<EbWechatExceptions> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String errcode = null;
    @JsonIgnore
    protected boolean isset_errcode = false;

    private String errmsg = null;
    @JsonIgnore
    protected boolean isset_errmsg = false;

    private String data = null;
    @JsonIgnore
    protected boolean isset_data = false;

    private String remark = null;
    @JsonIgnore
    protected boolean isset_remark = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbWechatExceptions() {
    }

    /**
     * 根据主键构造对象
     */
    public EbWechatExceptions(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public String getErrcode() {
        return this.errcode;
    }

    public void setErrcode(String errcode) {
        this.errcode = errcode;
        this.isset_errcode = true;
    }

    @JsonIgnore
    public boolean isEmptyErrcode() {
        return this.errcode == null || this.errcode.length() == 0;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
        this.isset_errmsg = true;
    }

    @JsonIgnore
    public boolean isEmptyErrmsg() {
        return this.errmsg == null || this.errmsg.length() == 0;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
        this.isset_data = true;
    }

    @JsonIgnore
    public boolean isEmptyData() {
        return this.data == null || this.data.length() == 0;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
        this.isset_remark = true;
    }

    @JsonIgnore
    public boolean isEmptyRemark() {
        return this.remark == null || this.remark.length() == 0;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("errcode=").append(this.errcode)
                .append("errmsg=").append(this.errmsg)
                .append("data=").append(this.data)
                .append("remark=").append(this.remark)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbWechatExceptions $clone() {
        EbWechatExceptions eb_wechat_exceptions = new EbWechatExceptions();

        // 数据库名称
        //eb_wechat_exceptions.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_wechat_exceptions.setId(this.getId());
        }
        // 普通属性
        if (this.isset_errcode) {
            eb_wechat_exceptions.setErrcode(this.getErrcode());
        }
        if (this.isset_errmsg) {
            eb_wechat_exceptions.setErrmsg(this.getErrmsg());
        }
        if (this.isset_data) {
            eb_wechat_exceptions.setData(this.getData());
        }
        if (this.isset_remark) {
            eb_wechat_exceptions.setRemark(this.getRemark());
        }
        if (this.isset_createTime) {
            eb_wechat_exceptions.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_wechat_exceptions.setUpdateTime(this.getUpdateTime());
        }
        return eb_wechat_exceptions;
    }
}
