package com.ishop.model.vo;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

/**
 * 微信小程序用户授权返回数据
 * @author 时克英
 * @date 2023-09-14
 */
public class WechatMiniAuthorizeVo implements Serializable {

    public String getSessionKey() {
        return sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    //    @ApiModelProperty(value = "会话密钥")
    @JsonProperty("session_key")
    private String sessionKey;

//    @ApiModelProperty(value = "用户唯一标识")
    @JsonProperty("openid")
    private String openId;

//    @ApiModelProperty(value = "用户在开放平台的唯一标识符，若当前小程序已绑定到微信开放平台帐号下会返回")
    @JsonProperty("unionid")
    private String unionId;

//    @ApiModelProperty(value = "错误码")
    @JsonProperty("errcode")
    private String errCode;

//    @ApiModelProperty(value = "错误信息")
    @JsonProperty("errmsg")
    private String errMsg;

    @Override
    public String toString() {
        return "WechatMiniAuthorizeVo{" +
                "sessionKey='" + sessionKey + '\'' +
                ", openId='" + openId + '\'' +
                ", unionId='" + unionId + '\'' +
                ", errCode='" + errCode + '\'' +
                ", errMsg='" + errMsg + '\'' +
                '}';
    }
}
