package com.ishop.model.wechat;

import java.io.Serializable;

/**
 * 微信绑定手机号请求对象
 * @date 2023-08-07
 */
public class WechatBindingPhoneRequest implements Serializable {

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCaptcha() {
        return captcha;
    }

    public void setCaptcha(String captcha) {
        this.captcha = captcha;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getEncryptedData() {
        return encryptedData;
    }

    public void setEncryptedData(String encryptedData) {
        this.encryptedData = encryptedData;
    }

    public String getIv() {
        return iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    /**
     * 自定义添加属性，在绑定接收短信验证码时，需要传入之前的请求标识：uuid，查找验证码缓存。
     * @return
     * @date 2023-08-07
     */
    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    private String uuid;
    //    @ApiModelProperty(value = "手机号,公众号、app微信必传")
//    @Pattern(regexp = RegularConstants.PHONE_TWO, message = "请输入正确的手机号")
    private String phone;

//    @ApiModelProperty(value = "验证码，公众号、app微信必传")
//    @Pattern(regexp = RegularConstants.VALIDATE_CODE_NUM_SIX, message = "请输入6位验证码")
    private String captcha;

//    @ApiModelProperty(value = "类型:wechat-公众号，routine-小程序,iosWx-苹果微信，androidWx-安卓微信")
//    @NotBlank(message = "类型不能为空")
//    @StringContains(limitValues = {"wechat","routine","iosWx","androidWx"}, message = "未知的类型")
    private String type;

//    @ApiModelProperty(value = "新用户登录时返回的key")
//    @NotBlank(message = "key不能为空")
    private String key;

//    @ApiModelProperty(value = "小程序获取手机号加密数据，小程序必传")
    private String encryptedData;

//    @ApiModelProperty(value = "加密算法的初始向量，小程序必传")
    private String iv;

//    @ApiModelProperty(value = "小程序code，小程序必传")
    private String code;

    @Override
    public String toString() {
        return "WechatBindingPhoneRequest{" +
                "uuid='" + uuid + '\'' +
                ", phone='" + phone + '\'' +
                ", captcha='" + captcha + '\'' +
                ", type='" + type + '\'' +
                ", key='" + key + '\'' +
                ", encryptedData='" + encryptedData + '\'' +
                ", iv='" + iv + '\'' +
                ", code='" + code + '\'' +
                '}';
    }
}
