package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_CITY_REGION *
 * @author genrator
 */
public class EbCityRegion_mapper extends EbCityRegion implements BaseMapper<EbCityRegion> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbCityRegion> ROW_MAPPER = new EbCityRegionRowMapper();

    // 主键
    public static final String RegionId = "region_id";
    // 普通属性
    public static final String ParentId = "parent_id";
    public static final String RegionName = "region_name";
    public static final String RegionType = "region_type";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbCityRegion_mapper(EbCityRegion ebCityRegion) {
        if (ebCityRegion == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebCityRegion.isset_regionId) {
            this.setRegionId(ebCityRegion.getRegionId());
        }
        //普通属性
        if (ebCityRegion.isset_parentId) {
            this.setParentId(ebCityRegion.getParentId());
        }
        if (ebCityRegion.isset_regionName) {
            this.setRegionName(ebCityRegion.getRegionName());
        }
        if (ebCityRegion.isset_regionType) {
            this.setRegionType(ebCityRegion.getRegionType());
        }
        if (ebCityRegion.isset_createTime) {
            this.setCreateTime(ebCityRegion.getCreateTime());
        }
        if (ebCityRegion.isset_updateTime) {
            this.setUpdateTime(ebCityRegion.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_city_region.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_city_region";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return RegionId;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getRegionId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(RegionId, this.getRegionId());
        ib.set(ParentId, this.getParentId(), this.isset_parentId);
        ib.set(RegionName, this.getRegionName(), this.isset_regionName);
        ib.set(RegionType, this.getRegionType(), this.isset_regionType);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ParentId, this.getParentId(), this.isset_parentId);
        ub.set(RegionName, this.getRegionName(), this.isset_regionName);
        ub.set(RegionType, this.getRegionType(), this.isset_regionType);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ParentId, this.getParentId(), this.isset_parentId);
        ub.set(RegionName, this.getRegionName(), this.isset_regionName);
        ub.set(RegionType, this.getRegionType(), this.isset_regionType);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ParentId, this.getParentId(), this.isset_parentId);
        ub.set(RegionName, this.getRegionName(), this.isset_regionName);
        ub.set(RegionType, this.getRegionType(), this.isset_regionType);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select region_id, parent_id, region_name, region_type, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select region_id, parent_id, region_name, region_type, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbCityRegion mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbCityRegion toEbCityRegion() {
        return super.$clone();
    }
}

/**
 * eb_city_region RowMapper
 *
 * @author genrator
 */
class EbCityRegionRowMapper implements RowMapper<EbCityRegion> {

    @Override
    public EbCityRegion mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbCityRegion eb_city_region = new EbCityRegion();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbCityRegion_mapper.RegionId);
        if (columnIndex > 0) {
            eb_city_region.setRegionId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbCityRegion_mapper.ParentId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_city_region.setParentId(null);
            } else {
                eb_city_region.setParentId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCityRegion_mapper.RegionName);
        if (columnIndex > 0) {
            eb_city_region.setRegionName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCityRegion_mapper.RegionType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_city_region.setRegionType(null);
            } else {
                eb_city_region.setRegionType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCityRegion_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_city_region.setCreateTime(null);
            } else {
                eb_city_region.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbCityRegion_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_city_region.setUpdateTime(null);
            } else {
                eb_city_region.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_city_region;
    }
}
