package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_EXPRESS *
 * @author genrator
 */
public class EbExpress_mapper extends EbExpress implements BaseMapper<EbExpress> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbExpress> ROW_MAPPER = new EbExpressRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Code = "code";
    public static final String Name = "name";
    public static final String PartnerId = "partner_id";
    public static final String PartnerKey = "partner_key";
    public static final String Net = "net";
    public static final String Account = "account";
    public static final String Password = "password";
    public static final String NetName = "net_name";
    public static final String Sort = "sort";
    public static final String IsShow = "is_show";
    public static final String Status = "status";

    /**
     * 默认构造函数
     */
    public EbExpress_mapper(EbExpress ebExpress) {
        if (ebExpress == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebExpress.isset_id) {
            this.setId(ebExpress.getId());
        }
        //普通属性
        if (ebExpress.isset_code) {
            this.setCode(ebExpress.getCode());
        }
        if (ebExpress.isset_name) {
            this.setName(ebExpress.getName());
        }
        if (ebExpress.isset_partnerId) {
            this.setPartnerId(ebExpress.getPartnerId());
        }
        if (ebExpress.isset_partnerKey) {
            this.setPartnerKey(ebExpress.getPartnerKey());
        }
        if (ebExpress.isset_net) {
            this.setNet(ebExpress.getNet());
        }
        if (ebExpress.isset_account) {
            this.setAccount(ebExpress.getAccount());
        }
        if (ebExpress.isset_password) {
            this.setPassword(ebExpress.getPassword());
        }
        if (ebExpress.isset_netName) {
            this.setNetName(ebExpress.getNetName());
        }
        if (ebExpress.isset_sort) {
            this.setSort(ebExpress.getSort());
        }
        if (ebExpress.isset_isShow) {
            this.setIsShow(ebExpress.getIsShow());
        }
        if (ebExpress.isset_status) {
            this.setStatus(ebExpress.getStatus());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_express.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_express";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Code, this.getCode(), this.isset_code);
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(PartnerId, this.getPartnerId(), this.isset_partnerId);
        ib.set(PartnerKey, this.getPartnerKey(), this.isset_partnerKey);
        ib.set(Net, this.getNet(), this.isset_net);
        ib.set(Account, this.getAccount(), this.isset_account);
        ib.set(Password, this.getPassword(), this.isset_password);
        ib.set(NetName, this.getNetName(), this.isset_netName);
        ib.set(Sort, this.getSort(), this.isset_sort);
        ib.set(IsShow, this.getIsShow(), this.isset_isShow);
        ib.set(Status, this.getStatus(), this.isset_status);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Code, this.getCode(), this.isset_code);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(PartnerId, this.getPartnerId(), this.isset_partnerId);
        ub.set(PartnerKey, this.getPartnerKey(), this.isset_partnerKey);
        ub.set(Net, this.getNet(), this.isset_net);
        ub.set(Account, this.getAccount(), this.isset_account);
        ub.set(Password, this.getPassword(), this.isset_password);
        ub.set(NetName, this.getNetName(), this.isset_netName);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Code, this.getCode(), this.isset_code);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(PartnerId, this.getPartnerId(), this.isset_partnerId);
        ub.set(PartnerKey, this.getPartnerKey(), this.isset_partnerKey);
        ub.set(Net, this.getNet(), this.isset_net);
        ub.set(Account, this.getAccount(), this.isset_account);
        ub.set(Password, this.getPassword(), this.isset_password);
        ub.set(NetName, this.getNetName(), this.isset_netName);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(Status, this.getStatus(), this.isset_status);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Code, this.getCode(), this.isset_code);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(PartnerId, this.getPartnerId(), this.isset_partnerId);
        ub.set(PartnerKey, this.getPartnerKey(), this.isset_partnerKey);
        ub.set(Net, this.getNet(), this.isset_net);
        ub.set(Account, this.getAccount(), this.isset_account);
        ub.set(Password, this.getPassword(), this.isset_password);
        ub.set(NetName, this.getNetName(), this.isset_netName);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(Status, this.getStatus(), this.isset_status);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, code, name, partner_id, partner_key, net, account, password, net_name, sort, is_show, status from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, code, name, partner_id, partner_key, net, account, password, net_name, sort, is_show, status from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbExpress mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbExpress toEbExpress() {
        return super.$clone();
    }
}

/**
 * eb_express RowMapper
 *
 * @author genrator
 */
class EbExpressRowMapper implements RowMapper<EbExpress> {

    @Override
    public EbExpress mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbExpress eb_express = new EbExpress();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.Id);
        if (columnIndex > 0) {
            eb_express.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.Code);
        if (columnIndex > 0) {
            eb_express.setCode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.Name);
        if (columnIndex > 0) {
            eb_express.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.PartnerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_express.setPartnerId(null);
            } else {
                eb_express.setPartnerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.PartnerKey);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_express.setPartnerKey(null);
            } else {
                eb_express.setPartnerKey(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.Net);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_express.setNet(null);
            } else {
                eb_express.setNet(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.Account);
        if (columnIndex > 0) {
            eb_express.setAccount(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.Password);
        if (columnIndex > 0) {
            eb_express.setPassword(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.NetName);
        if (columnIndex > 0) {
            eb_express.setNetName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.Sort);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_express.setSort(null);
            } else {
                eb_express.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.IsShow);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_express.setIsShow(null);
            } else {
                eb_express.setIsShow(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbExpress_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_express.setStatus(null);
            } else {
                eb_express.setStatus(rs.getInt(columnIndex));
            }
        }
        return eb_express;
    }
}
