
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_MERCHANT_CATEGORY *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbMerchantCategory extends BasePo<EbMerchantCategory> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbMerchantCategory ROW_MAPPER = new EbMerchantCategory();

    // 主键
    private Integer id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String name = null;
    @JsonIgnore
    protected boolean isset_name = false;

    private Integer handlingFee = null;
    @JsonIgnore
    protected boolean isset_handlingFee = false;

    private Integer isDel = null;
    @JsonIgnore
    protected boolean isset_isDel = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbMerchantCategory() {
    }

    /**
     * 根据主键构造对象
     */
    public EbMerchantCategory(Integer id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Integer) value);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.isset_name = true;
    }

    @JsonIgnore
    public boolean isEmptyName() {
        return this.name == null || this.name.length() == 0;
    }

    public Integer getHandlingFee() {
        return this.handlingFee;
    }

    public void setHandlingFee(Integer handlingFee) {
        this.handlingFee = handlingFee;
        this.isset_handlingFee = true;
    }

    @JsonIgnore
    public boolean isEmptyHandlingFee() {
        return this.handlingFee == null;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
        this.isset_isDel = true;
    }

    @JsonIgnore
    public boolean isEmptyIsDel() {
        return this.isDel == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("name=").append(this.name)
                .append("handlingFee=").append(this.handlingFee)
                .append("isDel=").append(this.isDel)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbMerchantCategory $clone() {
        EbMerchantCategory eb_merchant_category = new EbMerchantCategory();

        // 数据库名称
        //eb_merchant_category.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_merchant_category.setId(this.getId());
        }
        // 普通属性
        if (this.isset_name) {
            eb_merchant_category.setName(this.getName());
        }
        if (this.isset_handlingFee) {
            eb_merchant_category.setHandlingFee(this.getHandlingFee());
        }
        if (this.isset_isDel) {
            eb_merchant_category.setIsDel(this.getIsDel());
        }
        if (this.isset_createTime) {
            eb_merchant_category.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_merchant_category.setUpdateTime(this.getUpdateTime());
        }
        return eb_merchant_category;
    }
}
