package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_MERCHANT_CATEGORY *
 * @author genrator
 */
public class EbMerchantCategory_mapper extends EbMerchantCategory implements BaseMapper<EbMerchantCategory> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbMerchantCategory> ROW_MAPPER = new EbMerchantCategoryRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Name = "name";
    public static final String HandlingFee = "handling_fee";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbMerchantCategory_mapper(EbMerchantCategory ebMerchantCategory) {
        if (ebMerchantCategory == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebMerchantCategory.isset_id) {
            this.setId(ebMerchantCategory.getId());
        }
        //普通属性
        if (ebMerchantCategory.isset_name) {
            this.setName(ebMerchantCategory.getName());
        }
        if (ebMerchantCategory.isset_handlingFee) {
            this.setHandlingFee(ebMerchantCategory.getHandlingFee());
        }
        if (ebMerchantCategory.isset_isDel) {
            this.setIsDel(ebMerchantCategory.getIsDel());
        }
        if (ebMerchantCategory.isset_createTime) {
            this.setCreateTime(ebMerchantCategory.getCreateTime());
        }
        if (ebMerchantCategory.isset_updateTime) {
            this.setUpdateTime(ebMerchantCategory.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_merchant_category.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_merchant_category";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(HandlingFee, this.getHandlingFee(), this.isset_handlingFee);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, name, handling_fee, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, name, handling_fee, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbMerchantCategory mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbMerchantCategory toEbMerchantCategory() {
        return super.$clone();
    }
}

/**
 * eb_merchant_category RowMapper
 *
 * @author genrator
 */
class EbMerchantCategoryRowMapper implements RowMapper<EbMerchantCategory> {

    @Override
    public EbMerchantCategory mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbMerchantCategory eb_merchant_category = new EbMerchantCategory();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantCategory_mapper.Id);
        if (columnIndex > 0) {
            eb_merchant_category.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantCategory_mapper.Name);
        if (columnIndex > 0) {
            eb_merchant_category.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantCategory_mapper.HandlingFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_category.setHandlingFee(null);
            } else {
                eb_merchant_category.setHandlingFee(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantCategory_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_category.setIsDel(null);
            } else {
                eb_merchant_category.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantCategory_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_category.setCreateTime(null);
            } else {
                eb_merchant_category.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantCategory_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_category.setUpdateTime(null);
            } else {
                eb_merchant_category.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_merchant_category;
    }
}
