
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_MERCHANT_MONTH_STATEMENT *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbMerchantMonthStatement extends BasePo<EbMerchantMonthStatement> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbMerchantMonthStatement ROW_MAPPER = new EbMerchantMonthStatement();

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Integer merId = null;
    @JsonIgnore
    protected boolean isset_merId = false;

    private Double orderPayAmount = null;
    @JsonIgnore
    protected boolean isset_orderPayAmount = false;

    private Integer orderNum = null;
    @JsonIgnore
    protected boolean isset_orderNum = false;

    private Double orderIncomeAmount = null;
    @JsonIgnore
    protected boolean isset_orderIncomeAmount = false;

    private Double handlingFee = null;
    @JsonIgnore
    protected boolean isset_handlingFee = false;

    private Double firstBrokerage = null;
    @JsonIgnore
    protected boolean isset_firstBrokerage = false;

    private Double secondBrokerage = null;
    @JsonIgnore
    protected boolean isset_secondBrokerage = false;

    private Double payoutAmount = null;
    @JsonIgnore
    protected boolean isset_payoutAmount = false;

    private Integer payoutNum = null;
    @JsonIgnore
    protected boolean isset_payoutNum = false;

    private Double refundAmount = null;
    @JsonIgnore
    protected boolean isset_refundAmount = false;

    private Integer refundNum = null;
    @JsonIgnore
    protected boolean isset_refundNum = false;

    private Double incomeExpenditure = null;
    @JsonIgnore
    protected boolean isset_incomeExpenditure = false;

    private String dataDate = null;
    @JsonIgnore
    protected boolean isset_dataDate = false;

    /**
     * 默认构造函数
     */
    public EbMerchantMonthStatement() {
    }

    /**
     * 根据主键构造对象
     */
    public EbMerchantMonthStatement(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Integer getMerId() {
        return this.merId;
    }

    public void setMerId(Integer merId) {
        this.merId = merId;
        this.isset_merId = true;
    }

    @JsonIgnore
    public boolean isEmptyMerId() {
        return this.merId == null;
    }

    public Double getOrderPayAmount() {
        return this.orderPayAmount;
    }

    public void setOrderPayAmount(Double orderPayAmount) {
        this.orderPayAmount = orderPayAmount;
        this.isset_orderPayAmount = true;
    }

    @JsonIgnore
    public boolean isEmptyOrderPayAmount() {
        return this.orderPayAmount == null;
    }

    public Integer getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(Integer orderNum) {
        this.orderNum = orderNum;
        this.isset_orderNum = true;
    }

    @JsonIgnore
    public boolean isEmptyOrderNum() {
        return this.orderNum == null;
    }

    public Double getOrderIncomeAmount() {
        return this.orderIncomeAmount;
    }

    public void setOrderIncomeAmount(Double orderIncomeAmount) {
        this.orderIncomeAmount = orderIncomeAmount;
        this.isset_orderIncomeAmount = true;
    }

    @JsonIgnore
    public boolean isEmptyOrderIncomeAmount() {
        return this.orderIncomeAmount == null;
    }

    public Double getHandlingFee() {
        return this.handlingFee;
    }

    public void setHandlingFee(Double handlingFee) {
        this.handlingFee = handlingFee;
        this.isset_handlingFee = true;
    }

    @JsonIgnore
    public boolean isEmptyHandlingFee() {
        return this.handlingFee == null;
    }

    public Double getFirstBrokerage() {
        return this.firstBrokerage;
    }

    public void setFirstBrokerage(Double firstBrokerage) {
        this.firstBrokerage = firstBrokerage;
        this.isset_firstBrokerage = true;
    }

    @JsonIgnore
    public boolean isEmptyFirstBrokerage() {
        return this.firstBrokerage == null;
    }

    public Double getSecondBrokerage() {
        return this.secondBrokerage;
    }

    public void setSecondBrokerage(Double secondBrokerage) {
        this.secondBrokerage = secondBrokerage;
        this.isset_secondBrokerage = true;
    }

    @JsonIgnore
    public boolean isEmptySecondBrokerage() {
        return this.secondBrokerage == null;
    }

    public Double getPayoutAmount() {
        return this.payoutAmount;
    }

    public void setPayoutAmount(Double payoutAmount) {
        this.payoutAmount = payoutAmount;
        this.isset_payoutAmount = true;
    }

    @JsonIgnore
    public boolean isEmptyPayoutAmount() {
        return this.payoutAmount == null;
    }

    public Integer getPayoutNum() {
        return this.payoutNum;
    }

    public void setPayoutNum(Integer payoutNum) {
        this.payoutNum = payoutNum;
        this.isset_payoutNum = true;
    }

    @JsonIgnore
    public boolean isEmptyPayoutNum() {
        return this.payoutNum == null;
    }

    public Double getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(Double refundAmount) {
        this.refundAmount = refundAmount;
        this.isset_refundAmount = true;
    }

    @JsonIgnore
    public boolean isEmptyRefundAmount() {
        return this.refundAmount == null;
    }

    public Integer getRefundNum() {
        return this.refundNum;
    }

    public void setRefundNum(Integer refundNum) {
        this.refundNum = refundNum;
        this.isset_refundNum = true;
    }

    @JsonIgnore
    public boolean isEmptyRefundNum() {
        return this.refundNum == null;
    }

    public Double getIncomeExpenditure() {
        return this.incomeExpenditure;
    }

    public void setIncomeExpenditure(Double incomeExpenditure) {
        this.incomeExpenditure = incomeExpenditure;
        this.isset_incomeExpenditure = true;
    }

    @JsonIgnore
    public boolean isEmptyIncomeExpenditure() {
        return this.incomeExpenditure == null;
    }

    public String getDataDate() {
        return this.dataDate;
    }

    public void setDataDate(String dataDate) {
        this.dataDate = dataDate;
        this.isset_dataDate = true;
    }

    @JsonIgnore
    public boolean isEmptyDataDate() {
        return this.dataDate == null || this.dataDate.length() == 0;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("merId=").append(this.merId)
                .append("orderPayAmount=").append(this.orderPayAmount)
                .append("orderNum=").append(this.orderNum)
                .append("orderIncomeAmount=").append(this.orderIncomeAmount)
                .append("handlingFee=").append(this.handlingFee)
                .append("firstBrokerage=").append(this.firstBrokerage)
                .append("secondBrokerage=").append(this.secondBrokerage)
                .append("payoutAmount=").append(this.payoutAmount)
                .append("payoutNum=").append(this.payoutNum)
                .append("refundAmount=").append(this.refundAmount)
                .append("refundNum=").append(this.refundNum)
                .append("incomeExpenditure=").append(this.incomeExpenditure)
                .append("dataDate=").append(this.dataDate)
                .toString();
    }

    /**
     * 克隆
     */
    public EbMerchantMonthStatement $clone() {
        EbMerchantMonthStatement eb_merchant_month_statement = new EbMerchantMonthStatement();

        // 数据库名称
        //eb_merchant_month_statement.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_merchant_month_statement.setId(this.getId());
        }
        // 普通属性
        if (this.isset_merId) {
            eb_merchant_month_statement.setMerId(this.getMerId());
        }
        if (this.isset_orderPayAmount) {
            eb_merchant_month_statement.setOrderPayAmount(this.getOrderPayAmount());
        }
        if (this.isset_orderNum) {
            eb_merchant_month_statement.setOrderNum(this.getOrderNum());
        }
        if (this.isset_orderIncomeAmount) {
            eb_merchant_month_statement.setOrderIncomeAmount(this.getOrderIncomeAmount());
        }
        if (this.isset_handlingFee) {
            eb_merchant_month_statement.setHandlingFee(this.getHandlingFee());
        }
        if (this.isset_firstBrokerage) {
            eb_merchant_month_statement.setFirstBrokerage(this.getFirstBrokerage());
        }
        if (this.isset_secondBrokerage) {
            eb_merchant_month_statement.setSecondBrokerage(this.getSecondBrokerage());
        }
        if (this.isset_payoutAmount) {
            eb_merchant_month_statement.setPayoutAmount(this.getPayoutAmount());
        }
        if (this.isset_payoutNum) {
            eb_merchant_month_statement.setPayoutNum(this.getPayoutNum());
        }
        if (this.isset_refundAmount) {
            eb_merchant_month_statement.setRefundAmount(this.getRefundAmount());
        }
        if (this.isset_refundNum) {
            eb_merchant_month_statement.setRefundNum(this.getRefundNum());
        }
        if (this.isset_incomeExpenditure) {
            eb_merchant_month_statement.setIncomeExpenditure(this.getIncomeExpenditure());
        }
        if (this.isset_dataDate) {
            eb_merchant_month_statement.setDataDate(this.getDataDate());
        }
        return eb_merchant_month_statement;
    }
}
