package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_MERCHANT_ORDER *
 * @author genrator
 */
public class EbMerchantOrder_mapper extends EbMerchantOrder implements BaseMapper<EbMerchantOrder> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbMerchantOrder> ROW_MAPPER = new EbMerchantOrderRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String OrderNo = "order_no";
    public static final String MerId = "mer_id";
    public static final String Uid = "uid";
    public static final String RealName = "real_name";
    public static final String UserPhone = "user_phone";
    public static final String UserAddress = "user_address";
    public static final String TotalNum = "total_num";
    public static final String ProTotalPrice = "pro_total_price";
    public static final String TotalPostage = "total_postage";
    public static final String TotalPrice = "total_price";
    public static final String PayPrice = "pay_price";
    public static final String PayPostage = "pay_postage";
    public static final String UseIntegral = "use_integral";
    public static final String IntegralPrice = "integral_price";
    public static final String CouponId = "coupon_id";
    public static final String CouponPrice = "coupon_price";
    public static final String PayType = "pay_type";
    public static final String PayChannel = "pay_channel";
    public static final String GainIntegral = "gain_integral";
    public static final String UserRemark = "user_remark";
    public static final String MerchantRemark = "merchant_remark";
    public static final String ShippingType = "shipping_type";
    public static final String FirstBrokerage = "first_brokerage";
    public static final String SecondBrokerage = "second_brokerage";
    public static final String CommissionCharge = "commission_charge";
    public static final String VerifyCode = "verify_code";
    public static final String DeliveryType = "delivery_type";
    public static final String IsSplitDelivery = "is_split_delivery";
    public static final String SeckillId = "seckill_id";
    public static final String BargainUserId = "bargain_user_id";
    public static final String BargainId = "bargain_id";
    public static final String PinkId = "pink_id";
    public static final String CombinationId = "combination_id";
    public static final String ClerkId = "clerk_id";
    public static final String Type = "type";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbMerchantOrder_mapper(EbMerchantOrder ebMerchantOrder) {
        if (ebMerchantOrder == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebMerchantOrder.isset_id) {
            this.setId(ebMerchantOrder.getId());
        }
        //普通属性
        if (ebMerchantOrder.isset_orderNo) {
            this.setOrderNo(ebMerchantOrder.getOrderNo());
        }
        if (ebMerchantOrder.isset_merId) {
            this.setMerId(ebMerchantOrder.getMerId());
        }
        if (ebMerchantOrder.isset_uid) {
            this.setUid(ebMerchantOrder.getUid());
        }
        if (ebMerchantOrder.isset_realName) {
            this.setRealName(ebMerchantOrder.getRealName());
        }
        if (ebMerchantOrder.isset_userPhone) {
            this.setUserPhone(ebMerchantOrder.getUserPhone());
        }
        if (ebMerchantOrder.isset_userAddress) {
            this.setUserAddress(ebMerchantOrder.getUserAddress());
        }
        if (ebMerchantOrder.isset_totalNum) {
            this.setTotalNum(ebMerchantOrder.getTotalNum());
        }
        if (ebMerchantOrder.isset_proTotalPrice) {
            this.setProTotalPrice(ebMerchantOrder.getProTotalPrice());
        }
        if (ebMerchantOrder.isset_totalPostage) {
            this.setTotalPostage(ebMerchantOrder.getTotalPostage());
        }
        if (ebMerchantOrder.isset_totalPrice) {
            this.setTotalPrice(ebMerchantOrder.getTotalPrice());
        }
        if (ebMerchantOrder.isset_payPrice) {
            this.setPayPrice(ebMerchantOrder.getPayPrice());
        }
        if (ebMerchantOrder.isset_payPostage) {
            this.setPayPostage(ebMerchantOrder.getPayPostage());
        }
        if (ebMerchantOrder.isset_useIntegral) {
            this.setUseIntegral(ebMerchantOrder.getUseIntegral());
        }
        if (ebMerchantOrder.isset_integralPrice) {
            this.setIntegralPrice(ebMerchantOrder.getIntegralPrice());
        }
        if (ebMerchantOrder.isset_couponId) {
            this.setCouponId(ebMerchantOrder.getCouponId());
        }
        if (ebMerchantOrder.isset_couponPrice) {
            this.setCouponPrice(ebMerchantOrder.getCouponPrice());
        }
        if (ebMerchantOrder.isset_payType) {
            this.setPayType(ebMerchantOrder.getPayType());
        }
        if (ebMerchantOrder.isset_payChannel) {
            this.setPayChannel(ebMerchantOrder.getPayChannel());
        }
        if (ebMerchantOrder.isset_gainIntegral) {
            this.setGainIntegral(ebMerchantOrder.getGainIntegral());
        }
        if (ebMerchantOrder.isset_userRemark) {
            this.setUserRemark(ebMerchantOrder.getUserRemark());
        }
        if (ebMerchantOrder.isset_merchantRemark) {
            this.setMerchantRemark(ebMerchantOrder.getMerchantRemark());
        }
        if (ebMerchantOrder.isset_shippingType) {
            this.setShippingType(ebMerchantOrder.getShippingType());
        }
        if (ebMerchantOrder.isset_firstBrokerage) {
            this.setFirstBrokerage(ebMerchantOrder.getFirstBrokerage());
        }
        if (ebMerchantOrder.isset_secondBrokerage) {
            this.setSecondBrokerage(ebMerchantOrder.getSecondBrokerage());
        }
        if (ebMerchantOrder.isset_commissionCharge) {
            this.setCommissionCharge(ebMerchantOrder.getCommissionCharge());
        }
        if (ebMerchantOrder.isset_verifyCode) {
            this.setVerifyCode(ebMerchantOrder.getVerifyCode());
        }
        if (ebMerchantOrder.isset_deliveryType) {
            this.setDeliveryType(ebMerchantOrder.getDeliveryType());
        }
        if (ebMerchantOrder.isset_isSplitDelivery) {
            this.setIsSplitDelivery(ebMerchantOrder.getIsSplitDelivery());
        }
        if (ebMerchantOrder.isset_seckillId) {
            this.setSeckillId(ebMerchantOrder.getSeckillId());
        }
        if (ebMerchantOrder.isset_bargainUserId) {
            this.setBargainUserId(ebMerchantOrder.getBargainUserId());
        }
        if (ebMerchantOrder.isset_bargainId) {
            this.setBargainId(ebMerchantOrder.getBargainId());
        }
        if (ebMerchantOrder.isset_pinkId) {
            this.setPinkId(ebMerchantOrder.getPinkId());
        }
        if (ebMerchantOrder.isset_combinationId) {
            this.setCombinationId(ebMerchantOrder.getCombinationId());
        }
        if (ebMerchantOrder.isset_clerkId) {
            this.setClerkId(ebMerchantOrder.getClerkId());
        }
        if (ebMerchantOrder.isset_type) {
            this.setType(ebMerchantOrder.getType());
        }
        if (ebMerchantOrder.isset_createTime) {
            this.setCreateTime(ebMerchantOrder.getCreateTime());
        }
        if (ebMerchantOrder.isset_updateTime) {
            this.setUpdateTime(ebMerchantOrder.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_merchant_order.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_merchant_order";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(RealName, this.getRealName(), this.isset_realName);
        ib.set(UserPhone, this.getUserPhone(), this.isset_userPhone);
        ib.set(UserAddress, this.getUserAddress(), this.isset_userAddress);
        ib.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ib.set(ProTotalPrice, this.getProTotalPrice(), this.isset_proTotalPrice);
        ib.set(TotalPostage, this.getTotalPostage(), this.isset_totalPostage);
        ib.set(TotalPrice, this.getTotalPrice(), this.isset_totalPrice);
        ib.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ib.set(PayPostage, this.getPayPostage(), this.isset_payPostage);
        ib.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ib.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ib.set(CouponId, this.getCouponId(), this.isset_couponId);
        ib.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ib.set(PayType, this.getPayType(), this.isset_payType);
        ib.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ib.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ib.set(UserRemark, this.getUserRemark(), this.isset_userRemark);
        ib.set(MerchantRemark, this.getMerchantRemark(), this.isset_merchantRemark);
        ib.set(ShippingType, this.getShippingType(), this.isset_shippingType);
        ib.set(FirstBrokerage, this.getFirstBrokerage(), this.isset_firstBrokerage);
        ib.set(SecondBrokerage, this.getSecondBrokerage(), this.isset_secondBrokerage);
        ib.set(CommissionCharge, this.getCommissionCharge(), this.isset_commissionCharge);
        ib.set(VerifyCode, this.getVerifyCode(), this.isset_verifyCode);
        ib.set(DeliveryType, this.getDeliveryType(), this.isset_deliveryType);
        ib.set(IsSplitDelivery, this.getIsSplitDelivery(), this.isset_isSplitDelivery);
        ib.set(SeckillId, this.getSeckillId(), this.isset_seckillId);
        ib.set(BargainUserId, this.getBargainUserId(), this.isset_bargainUserId);
        ib.set(BargainId, this.getBargainId(), this.isset_bargainId);
        ib.set(PinkId, this.getPinkId(), this.isset_pinkId);
        ib.set(CombinationId, this.getCombinationId(), this.isset_combinationId);
        ib.set(ClerkId, this.getClerkId(), this.isset_clerkId);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(UserPhone, this.getUserPhone(), this.isset_userPhone);
        ub.set(UserAddress, this.getUserAddress(), this.isset_userAddress);
        ub.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ub.set(ProTotalPrice, this.getProTotalPrice(), this.isset_proTotalPrice);
        ub.set(TotalPostage, this.getTotalPostage(), this.isset_totalPostage);
        ub.set(TotalPrice, this.getTotalPrice(), this.isset_totalPrice);
        ub.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ub.set(PayPostage, this.getPayPostage(), this.isset_payPostage);
        ub.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ub.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ub.set(CouponId, this.getCouponId(), this.isset_couponId);
        ub.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ub.set(PayType, this.getPayType(), this.isset_payType);
        ub.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ub.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ub.set(UserRemark, this.getUserRemark(), this.isset_userRemark);
        ub.set(MerchantRemark, this.getMerchantRemark(), this.isset_merchantRemark);
        ub.set(ShippingType, this.getShippingType(), this.isset_shippingType);
        ub.set(FirstBrokerage, this.getFirstBrokerage(), this.isset_firstBrokerage);
        ub.set(SecondBrokerage, this.getSecondBrokerage(), this.isset_secondBrokerage);
        ub.set(CommissionCharge, this.getCommissionCharge(), this.isset_commissionCharge);
        ub.set(VerifyCode, this.getVerifyCode(), this.isset_verifyCode);
        ub.set(DeliveryType, this.getDeliveryType(), this.isset_deliveryType);
        ub.set(IsSplitDelivery, this.getIsSplitDelivery(), this.isset_isSplitDelivery);
        ub.set(SeckillId, this.getSeckillId(), this.isset_seckillId);
        ub.set(BargainUserId, this.getBargainUserId(), this.isset_bargainUserId);
        ub.set(BargainId, this.getBargainId(), this.isset_bargainId);
        ub.set(PinkId, this.getPinkId(), this.isset_pinkId);
        ub.set(CombinationId, this.getCombinationId(), this.isset_combinationId);
        ub.set(ClerkId, this.getClerkId(), this.isset_clerkId);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(UserPhone, this.getUserPhone(), this.isset_userPhone);
        ub.set(UserAddress, this.getUserAddress(), this.isset_userAddress);
        ub.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ub.set(ProTotalPrice, this.getProTotalPrice(), this.isset_proTotalPrice);
        ub.set(TotalPostage, this.getTotalPostage(), this.isset_totalPostage);
        ub.set(TotalPrice, this.getTotalPrice(), this.isset_totalPrice);
        ub.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ub.set(PayPostage, this.getPayPostage(), this.isset_payPostage);
        ub.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ub.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ub.set(CouponId, this.getCouponId(), this.isset_couponId);
        ub.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ub.set(PayType, this.getPayType(), this.isset_payType);
        ub.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ub.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ub.set(UserRemark, this.getUserRemark(), this.isset_userRemark);
        ub.set(MerchantRemark, this.getMerchantRemark(), this.isset_merchantRemark);
        ub.set(ShippingType, this.getShippingType(), this.isset_shippingType);
        ub.set(FirstBrokerage, this.getFirstBrokerage(), this.isset_firstBrokerage);
        ub.set(SecondBrokerage, this.getSecondBrokerage(), this.isset_secondBrokerage);
        ub.set(CommissionCharge, this.getCommissionCharge(), this.isset_commissionCharge);
        ub.set(VerifyCode, this.getVerifyCode(), this.isset_verifyCode);
        ub.set(DeliveryType, this.getDeliveryType(), this.isset_deliveryType);
        ub.set(IsSplitDelivery, this.getIsSplitDelivery(), this.isset_isSplitDelivery);
        ub.set(SeckillId, this.getSeckillId(), this.isset_seckillId);
        ub.set(BargainUserId, this.getBargainUserId(), this.isset_bargainUserId);
        ub.set(BargainId, this.getBargainId(), this.isset_bargainId);
        ub.set(PinkId, this.getPinkId(), this.isset_pinkId);
        ub.set(CombinationId, this.getCombinationId(), this.isset_combinationId);
        ub.set(ClerkId, this.getClerkId(), this.isset_clerkId);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.set(UserPhone, this.getUserPhone(), this.isset_userPhone);
        ub.set(UserAddress, this.getUserAddress(), this.isset_userAddress);
        ub.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ub.set(ProTotalPrice, this.getProTotalPrice(), this.isset_proTotalPrice);
        ub.set(TotalPostage, this.getTotalPostage(), this.isset_totalPostage);
        ub.set(TotalPrice, this.getTotalPrice(), this.isset_totalPrice);
        ub.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ub.set(PayPostage, this.getPayPostage(), this.isset_payPostage);
        ub.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ub.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ub.set(CouponId, this.getCouponId(), this.isset_couponId);
        ub.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ub.set(PayType, this.getPayType(), this.isset_payType);
        ub.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ub.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ub.set(UserRemark, this.getUserRemark(), this.isset_userRemark);
        ub.set(MerchantRemark, this.getMerchantRemark(), this.isset_merchantRemark);
        ub.set(ShippingType, this.getShippingType(), this.isset_shippingType);
        ub.set(FirstBrokerage, this.getFirstBrokerage(), this.isset_firstBrokerage);
        ub.set(SecondBrokerage, this.getSecondBrokerage(), this.isset_secondBrokerage);
        ub.set(CommissionCharge, this.getCommissionCharge(), this.isset_commissionCharge);
        ub.set(VerifyCode, this.getVerifyCode(), this.isset_verifyCode);
        ub.set(DeliveryType, this.getDeliveryType(), this.isset_deliveryType);
        ub.set(IsSplitDelivery, this.getIsSplitDelivery(), this.isset_isSplitDelivery);
        ub.set(SeckillId, this.getSeckillId(), this.isset_seckillId);
        ub.set(BargainUserId, this.getBargainUserId(), this.isset_bargainUserId);
        ub.set(BargainId, this.getBargainId(), this.isset_bargainId);
        ub.set(PinkId, this.getPinkId(), this.isset_pinkId);
        ub.set(CombinationId, this.getCombinationId(), this.isset_combinationId);
        ub.set(ClerkId, this.getClerkId(), this.isset_clerkId);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, order_no, mer_id, uid, real_name, user_phone, user_address, total_num, pro_total_price, total_postage, total_price, pay_price, pay_postage, use_integral, integral_price, coupon_id, coupon_price, pay_type, pay_channel, gain_integral, user_remark, merchant_remark, shipping_type, first_brokerage, second_brokerage, commission_charge, verify_code, delivery_type, is_split_delivery, seckill_id, bargain_user_id, bargain_id, pink_id, combination_id, clerk_id, type, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, order_no, mer_id, uid, real_name, user_phone, user_address, total_num, pro_total_price, total_postage, total_price, pay_price, pay_postage, use_integral, integral_price, coupon_id, coupon_price, pay_type, pay_channel, gain_integral, user_remark, merchant_remark, shipping_type, first_brokerage, second_brokerage, commission_charge, verify_code, delivery_type, is_split_delivery, seckill_id, bargain_user_id, bargain_id, pink_id, combination_id, clerk_id, type, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbMerchantOrder mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbMerchantOrder toEbMerchantOrder() {
        return super.$clone();
    }
}

/**
 * eb_merchant_order RowMapper
 *
 * @author genrator
 */
class EbMerchantOrderRowMapper implements RowMapper<EbMerchantOrder> {

    @Override
    public EbMerchantOrder mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbMerchantOrder eb_merchant_order = new EbMerchantOrder();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.Id);
        if (columnIndex > 0) {
            eb_merchant_order.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.OrderNo);
        if (columnIndex > 0) {
            eb_merchant_order.setOrderNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setMerId(null);
            } else {
                eb_merchant_order.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setUid(null);
            } else {
                eb_merchant_order.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.RealName);
        if (columnIndex > 0) {
            eb_merchant_order.setRealName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.UserPhone);
        if (columnIndex > 0) {
            eb_merchant_order.setUserPhone(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.UserAddress);
        if (columnIndex > 0) {
            eb_merchant_order.setUserAddress(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.TotalNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setTotalNum(null);
            } else {
                eb_merchant_order.setTotalNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.ProTotalPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setProTotalPrice(null);
            } else {
                eb_merchant_order.setProTotalPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.TotalPostage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setTotalPostage(null);
            } else {
                eb_merchant_order.setTotalPostage(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.TotalPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setTotalPrice(null);
            } else {
                eb_merchant_order.setTotalPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.PayPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setPayPrice(null);
            } else {
                eb_merchant_order.setPayPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.PayPostage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setPayPostage(null);
            } else {
                eb_merchant_order.setPayPostage(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.UseIntegral);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setUseIntegral(null);
            } else {
                eb_merchant_order.setUseIntegral(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.IntegralPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setIntegralPrice(null);
            } else {
                eb_merchant_order.setIntegralPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.CouponId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setCouponId(null);
            } else {
                eb_merchant_order.setCouponId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.CouponPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setCouponPrice(null);
            } else {
                eb_merchant_order.setCouponPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.PayType);
        if (columnIndex > 0) {
            eb_merchant_order.setPayType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.PayChannel);
        if (columnIndex > 0) {
            eb_merchant_order.setPayChannel(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.GainIntegral);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setGainIntegral(null);
            } else {
                eb_merchant_order.setGainIntegral(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.UserRemark);
        if (columnIndex > 0) {
            eb_merchant_order.setUserRemark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.MerchantRemark);
        if (columnIndex > 0) {
            eb_merchant_order.setMerchantRemark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.ShippingType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setShippingType(null);
            } else {
                eb_merchant_order.setShippingType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.FirstBrokerage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setFirstBrokerage(null);
            } else {
                eb_merchant_order.setFirstBrokerage(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.SecondBrokerage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setSecondBrokerage(null);
            } else {
                eb_merchant_order.setSecondBrokerage(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.CommissionCharge);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setCommissionCharge(null);
            } else {
                eb_merchant_order.setCommissionCharge(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.VerifyCode);
        if (columnIndex > 0) {
            eb_merchant_order.setVerifyCode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.DeliveryType);
        if (columnIndex > 0) {
            eb_merchant_order.setDeliveryType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.IsSplitDelivery);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setIsSplitDelivery(null);
            } else {
                eb_merchant_order.setIsSplitDelivery(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.SeckillId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setSeckillId(null);
            } else {
                eb_merchant_order.setSeckillId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.BargainUserId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setBargainUserId(null);
            } else {
                eb_merchant_order.setBargainUserId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.BargainId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setBargainId(null);
            } else {
                eb_merchant_order.setBargainId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.PinkId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setPinkId(null);
            } else {
                eb_merchant_order.setPinkId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.CombinationId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setCombinationId(null);
            } else {
                eb_merchant_order.setCombinationId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.ClerkId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setClerkId(null);
            } else {
                eb_merchant_order.setClerkId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setType(null);
            } else {
                eb_merchant_order.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setCreateTime(null);
            } else {
                eb_merchant_order.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantOrder_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_order.setUpdateTime(null);
            } else {
                eb_merchant_order.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_merchant_order;
    }
}
