package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_MERCHANT_PRODUCT_CATEGORY *
 * @author genrator
 */
public class EbMerchantProductCategory_mapper extends EbMerchantProductCategory implements BaseMapper<EbMerchantProductCategory> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbMerchantProductCategory> ROW_MAPPER = new EbMerchantProductCategoryRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String MerId = "mer_id";
    public static final String Pid = "pid";
    public static final String Name = "name";
    public static final String Icon = "icon";
    public static final String Sort = "sort";
    public static final String IsShow = "is_show";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbMerchantProductCategory_mapper(EbMerchantProductCategory ebMerchantProductCategory) {
        if (ebMerchantProductCategory == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebMerchantProductCategory.isset_id) {
            this.setId(ebMerchantProductCategory.getId());
        }
        //普通属性
        if (ebMerchantProductCategory.isset_merId) {
            this.setMerId(ebMerchantProductCategory.getMerId());
        }
        if (ebMerchantProductCategory.isset_pid) {
            this.setPid(ebMerchantProductCategory.getPid());
        }
        if (ebMerchantProductCategory.isset_name) {
            this.setName(ebMerchantProductCategory.getName());
        }
        if (ebMerchantProductCategory.isset_icon) {
            this.setIcon(ebMerchantProductCategory.getIcon());
        }
        if (ebMerchantProductCategory.isset_sort) {
            this.setSort(ebMerchantProductCategory.getSort());
        }
        if (ebMerchantProductCategory.isset_isShow) {
            this.setIsShow(ebMerchantProductCategory.getIsShow());
        }
        if (ebMerchantProductCategory.isset_isDel) {
            this.setIsDel(ebMerchantProductCategory.getIsDel());
        }
        if (ebMerchantProductCategory.isset_createTime) {
            this.setCreateTime(ebMerchantProductCategory.getCreateTime());
        }
        if (ebMerchantProductCategory.isset_updateTime) {
            this.setUpdateTime(ebMerchantProductCategory.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_merchant_product_category.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_merchant_product_category";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(Pid, this.getPid(), this.isset_pid);
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(Icon, this.getIcon(), this.isset_icon);
        ib.set(Sort, this.getSort(), this.isset_sort);
        ib.set(IsShow, this.getIsShow(), this.isset_isShow);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Pid, this.getPid(), this.isset_pid);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Icon, this.getIcon(), this.isset_icon);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Pid, this.getPid(), this.isset_pid);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Icon, this.getIcon(), this.isset_icon);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Pid, this.getPid(), this.isset_pid);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Icon, this.getIcon(), this.isset_icon);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, mer_id, pid, name, icon, sort, is_show, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, mer_id, pid, name, icon, sort, is_show, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbMerchantProductCategory mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbMerchantProductCategory toEbMerchantProductCategory() {
        return super.$clone();
    }
}

/**
 * eb_merchant_product_category RowMapper
 *
 * @author genrator
 */
class EbMerchantProductCategoryRowMapper implements RowMapper<EbMerchantProductCategory> {

    @Override
    public EbMerchantProductCategory mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbMerchantProductCategory eb_merchant_product_category = new EbMerchantProductCategory();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.Id);
        if (columnIndex > 0) {
            eb_merchant_product_category.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_category.setMerId(null);
            } else {
                eb_merchant_product_category.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.Pid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_category.setPid(null);
            } else {
                eb_merchant_product_category.setPid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.Name);
        if (columnIndex > 0) {
            eb_merchant_product_category.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.Icon);
        if (columnIndex > 0) {
            eb_merchant_product_category.setIcon(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.Sort);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_category.setSort(null);
            } else {
                eb_merchant_product_category.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.IsShow);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_category.setIsShow(null);
            } else {
                eb_merchant_product_category.setIsShow(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_category.setIsDel(null);
            } else {
                eb_merchant_product_category.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_category.setCreateTime(null);
            } else {
                eb_merchant_product_category.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductCategory_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_category.setUpdateTime(null);
            } else {
                eb_merchant_product_category.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_merchant_product_category;
    }
}
