package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_MERCHANT_PRODUCT_GUARANTEE_GROUP *
 * @author genrator
 */
public class EbMerchantProductGuaranteeGroup_mapper extends EbMerchantProductGuaranteeGroup implements BaseMapper<EbMerchantProductGuaranteeGroup> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbMerchantProductGuaranteeGroup> ROW_MAPPER = new EbMerchantProductGuaranteeGroupRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String GroupId = "group_id";
    public static final String Gid = "gid";
    public static final String IsShow = "is_show";

    /**
     * 默认构造函数
     */
    public EbMerchantProductGuaranteeGroup_mapper(EbMerchantProductGuaranteeGroup ebMerchantProductGuaranteeGroup) {
        if (ebMerchantProductGuaranteeGroup == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebMerchantProductGuaranteeGroup.isset_id) {
            this.setId(ebMerchantProductGuaranteeGroup.getId());
        }
        //普通属性
        if (ebMerchantProductGuaranteeGroup.isset_groupId) {
            this.setGroupId(ebMerchantProductGuaranteeGroup.getGroupId());
        }
        if (ebMerchantProductGuaranteeGroup.isset_gid) {
            this.setGid(ebMerchantProductGuaranteeGroup.getGid());
        }
        if (ebMerchantProductGuaranteeGroup.isset_isShow) {
            this.setIsShow(ebMerchantProductGuaranteeGroup.getIsShow());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_merchant_product_guarantee_group.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_merchant_product_guarantee_group";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(GroupId, this.getGroupId(), this.isset_groupId);
        ib.set(Gid, this.getGid(), this.isset_gid);
        ib.set(IsShow, this.getIsShow(), this.isset_isShow);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(GroupId, this.getGroupId(), this.isset_groupId);
        ub.set(Gid, this.getGid(), this.isset_gid);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(GroupId, this.getGroupId(), this.isset_groupId);
        ub.set(Gid, this.getGid(), this.isset_gid);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(GroupId, this.getGroupId(), this.isset_groupId);
        ub.set(Gid, this.getGid(), this.isset_gid);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, group_id, gid, is_show from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, group_id, gid, is_show from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbMerchantProductGuaranteeGroup mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbMerchantProductGuaranteeGroup toEbMerchantProductGuaranteeGroup() {
        return super.$clone();
    }
}

/**
 * eb_merchant_product_guarantee_group RowMapper
 *
 * @author genrator
 */
class EbMerchantProductGuaranteeGroupRowMapper implements RowMapper<EbMerchantProductGuaranteeGroup> {

    @Override
    public EbMerchantProductGuaranteeGroup mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbMerchantProductGuaranteeGroup eb_merchant_product_guarantee_group = new EbMerchantProductGuaranteeGroup();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductGuaranteeGroup_mapper.Id);
        if (columnIndex > 0) {
            eb_merchant_product_guarantee_group.setId(rs.getString(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductGuaranteeGroup_mapper.GroupId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_guarantee_group.setGroupId(null);
            } else {
                eb_merchant_product_guarantee_group.setGroupId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductGuaranteeGroup_mapper.Gid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_guarantee_group.setGid(null);
            } else {
                eb_merchant_product_guarantee_group.setGid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbMerchantProductGuaranteeGroup_mapper.IsShow);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_merchant_product_guarantee_group.setIsShow(null);
            } else {
                eb_merchant_product_guarantee_group.setIsShow(rs.getInt(columnIndex));
            }
        }
        return eb_merchant_product_guarantee_group;
    }
}
