
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_ORDER_INVOICE *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbOrderInvoice extends BasePo<EbOrderInvoice> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String orderNo = null;
    @JsonIgnore
    protected boolean isset_orderNo = false;

    private Integer merId = null;
    @JsonIgnore
    protected boolean isset_merId = false;

    private Long uid = null;
    @JsonIgnore
    protected boolean isset_uid = false;

    private String trackingNumber = null;
    @JsonIgnore
    protected boolean isset_trackingNumber = false;

    private String expressName = null;
    @JsonIgnore
    protected boolean isset_expressName = false;

    private String expressCode = null;
    @JsonIgnore
    protected boolean isset_expressCode = false;

    private Integer totalNum = null;
    @JsonIgnore
    protected boolean isset_totalNum = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbOrderInvoice() {
    }

    /**
     * 根据主键构造对象
     */
    public EbOrderInvoice(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
        this.isset_orderNo = true;
    }

    @JsonIgnore
    public boolean isEmptyOrderNo() {
        return this.orderNo == null || this.orderNo.length() == 0;
    }

    public Integer getMerId() {
        return this.merId;
    }

    public void setMerId(Integer merId) {
        this.merId = merId;
        this.isset_merId = true;
    }

    @JsonIgnore
    public boolean isEmptyMerId() {
        return this.merId == null;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
        this.isset_uid = true;
    }

    @JsonIgnore
    public boolean isEmptyUid() {
        return this.uid == null;
    }

    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        this.isset_trackingNumber = true;
    }

    @JsonIgnore
    public boolean isEmptyTrackingNumber() {
        return this.trackingNumber == null || this.trackingNumber.length() == 0;
    }

    public String getExpressName() {
        return this.expressName;
    }

    public void setExpressName(String expressName) {
        this.expressName = expressName;
        this.isset_expressName = true;
    }

    @JsonIgnore
    public boolean isEmptyExpressName() {
        return this.expressName == null || this.expressName.length() == 0;
    }

    public String getExpressCode() {
        return this.expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
        this.isset_expressCode = true;
    }

    @JsonIgnore
    public boolean isEmptyExpressCode() {
        return this.expressCode == null || this.expressCode.length() == 0;
    }

    public Integer getTotalNum() {
        return this.totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
        this.isset_totalNum = true;
    }

    @JsonIgnore
    public boolean isEmptyTotalNum() {
        return this.totalNum == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("orderNo=").append(this.orderNo)
                .append("merId=").append(this.merId)
                .append("uid=").append(this.uid)
                .append("trackingNumber=").append(this.trackingNumber)
                .append("expressName=").append(this.expressName)
                .append("expressCode=").append(this.expressCode)
                .append("totalNum=").append(this.totalNum)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbOrderInvoice $clone() {
        EbOrderInvoice eb_order_invoice = new EbOrderInvoice();

        // 数据库名称
        //eb_order_invoice.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_order_invoice.setId(this.getId());
        }
        // 普通属性
        if (this.isset_orderNo) {
            eb_order_invoice.setOrderNo(this.getOrderNo());
        }
        if (this.isset_merId) {
            eb_order_invoice.setMerId(this.getMerId());
        }
        if (this.isset_uid) {
            eb_order_invoice.setUid(this.getUid());
        }
        if (this.isset_trackingNumber) {
            eb_order_invoice.setTrackingNumber(this.getTrackingNumber());
        }
        if (this.isset_expressName) {
            eb_order_invoice.setExpressName(this.getExpressName());
        }
        if (this.isset_expressCode) {
            eb_order_invoice.setExpressCode(this.getExpressCode());
        }
        if (this.isset_totalNum) {
            eb_order_invoice.setTotalNum(this.getTotalNum());
        }
        if (this.isset_createTime) {
            eb_order_invoice.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_order_invoice.setUpdateTime(this.getUpdateTime());
        }
        return eb_order_invoice;
    }
}
