package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_ORDER_INVOICE_DETAIL *
 * @author genrator
 */
public class EbOrderInvoiceDetail_mapper extends EbOrderInvoiceDetail implements BaseMapper<EbOrderInvoiceDetail> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbOrderInvoiceDetail> ROW_MAPPER = new EbOrderInvoiceDetailRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String InvoiceId = "invoice_id";
    public static final String ProductId = "product_id";
    public static final String ProductName = "product_name";
    public static final String Image = "image";
    public static final String AttrValueId = "attr_value_id";
    public static final String Sku = "sku";
    public static final String Num = "num";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbOrderInvoiceDetail_mapper(EbOrderInvoiceDetail ebOrderInvoiceDetail) {
        if (ebOrderInvoiceDetail == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebOrderInvoiceDetail.isset_id) {
            this.setId(ebOrderInvoiceDetail.getId());
        }
        //普通属性
        if (ebOrderInvoiceDetail.isset_invoiceId) {
            this.setInvoiceId(ebOrderInvoiceDetail.getInvoiceId());
        }
        if (ebOrderInvoiceDetail.isset_productId) {
            this.setProductId(ebOrderInvoiceDetail.getProductId());
        }
        if (ebOrderInvoiceDetail.isset_productName) {
            this.setProductName(ebOrderInvoiceDetail.getProductName());
        }
        if (ebOrderInvoiceDetail.isset_image) {
            this.setImage(ebOrderInvoiceDetail.getImage());
        }
        if (ebOrderInvoiceDetail.isset_attrValueId) {
            this.setAttrValueId(ebOrderInvoiceDetail.getAttrValueId());
        }
        if (ebOrderInvoiceDetail.isset_sku) {
            this.setSku(ebOrderInvoiceDetail.getSku());
        }
        if (ebOrderInvoiceDetail.isset_num) {
            this.setNum(ebOrderInvoiceDetail.getNum());
        }
        if (ebOrderInvoiceDetail.isset_createTime) {
            this.setCreateTime(ebOrderInvoiceDetail.getCreateTime());
        }
        if (ebOrderInvoiceDetail.isset_updateTime) {
            this.setUpdateTime(ebOrderInvoiceDetail.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_order_invoice_detail.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_order_invoice_detail";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(InvoiceId, this.getInvoiceId(), this.isset_invoiceId);
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(ProductName, this.getProductName(), this.isset_productName);
        ib.set(Image, this.getImage(), this.isset_image);
        ib.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ib.set(Sku, this.getSku(), this.isset_sku);
        ib.set(Num, this.getNum(), this.isset_num);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(InvoiceId, this.getInvoiceId(), this.isset_invoiceId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(ProductName, this.getProductName(), this.isset_productName);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Num, this.getNum(), this.isset_num);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(InvoiceId, this.getInvoiceId(), this.isset_invoiceId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(ProductName, this.getProductName(), this.isset_productName);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Num, this.getNum(), this.isset_num);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(InvoiceId, this.getInvoiceId(), this.isset_invoiceId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(ProductName, this.getProductName(), this.isset_productName);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(AttrValueId, this.getAttrValueId(), this.isset_attrValueId);
        ub.set(Sku, this.getSku(), this.isset_sku);
        ub.set(Num, this.getNum(), this.isset_num);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, invoice_id, product_id, product_name, image, attr_value_id, sku, num, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, invoice_id, product_id, product_name, image, attr_value_id, sku, num, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbOrderInvoiceDetail mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbOrderInvoiceDetail toEbOrderInvoiceDetail() {
        return super.$clone();
    }
}

/**
 * eb_order_invoice_detail RowMapper
 *
 * @author genrator
 */
class EbOrderInvoiceDetailRowMapper implements RowMapper<EbOrderInvoiceDetail> {

    @Override
    public EbOrderInvoiceDetail mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbOrderInvoiceDetail eb_order_invoice_detail = new EbOrderInvoiceDetail();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.Id);
        if (columnIndex > 0) {
            eb_order_invoice_detail.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.InvoiceId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice_detail.setInvoiceId(null);
            } else {
                eb_order_invoice_detail.setInvoiceId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.ProductId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice_detail.setProductId(null);
            } else {
                eb_order_invoice_detail.setProductId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.ProductName);
        if (columnIndex > 0) {
            eb_order_invoice_detail.setProductName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.Image);
        if (columnIndex > 0) {
            eb_order_invoice_detail.setImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.AttrValueId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice_detail.setAttrValueId(null);
            } else {
                eb_order_invoice_detail.setAttrValueId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.Sku);
        if (columnIndex > 0) {
            eb_order_invoice_detail.setSku(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.Num);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice_detail.setNum(null);
            } else {
                eb_order_invoice_detail.setNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice_detail.setCreateTime(null);
            } else {
                eb_order_invoice_detail.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrderInvoiceDetail_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order_invoice_detail.setUpdateTime(null);
            } else {
                eb_order_invoice_detail.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_order_invoice_detail;
    }
}
