package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_ORDER *
 * @author genrator
 */
public class EbOrder_mapper extends EbOrder implements BaseMapper<EbOrder> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbOrder> ROW_MAPPER = new EbOrderRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String OrderNo = "order_no";
    public static final String MerId = "mer_id";
    public static final String Uid = "uid";
    public static final String TotalNum = "total_num";
    public static final String ProTotalPrice = "pro_total_price";
    public static final String TotalPostage = "total_postage";
    public static final String TotalPrice = "total_price";
    public static final String CouponPrice = "coupon_price";
    public static final String UseIntegral = "use_integral";
    public static final String IntegralPrice = "integral_price";
    public static final String PayPrice = "pay_price";
    public static final String PayPostage = "pay_postage";
    public static final String Paid = "paid";
    public static final String PayTime = "pay_time";
    public static final String PayType = "pay_type";
    public static final String PayChannel = "pay_channel";
    public static final String Status = "status";
    public static final String RefundStatus = "refund_status";
    public static final String CancelStatus = "cancel_status";
    public static final String IsUserDel = "is_user_del";
    public static final String IsMerchantDel = "is_merchant_del";
    public static final String GainIntegral = "gain_integral";
    public static final String OutTradeNo = "out_trade_no";
    public static final String Redirect = "redirect";
    public static final String Type = "type";
    public static final String Level = "level";
    public static final String PlatOrderNo = "plat_order_no";
    public static final String IsDel = "is_del";
    public static final String ReceivingTime = "receiving_time";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbOrder_mapper(EbOrder ebOrder) {
        if (ebOrder == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebOrder.isset_id) {
            this.setId(ebOrder.getId());
        }
        //普通属性
        if (ebOrder.isset_orderNo) {
            this.setOrderNo(ebOrder.getOrderNo());
        }
        if (ebOrder.isset_merId) {
            this.setMerId(ebOrder.getMerId());
        }
        if (ebOrder.isset_uid) {
            this.setUid(ebOrder.getUid());
        }
        if (ebOrder.isset_totalNum) {
            this.setTotalNum(ebOrder.getTotalNum());
        }
        if (ebOrder.isset_proTotalPrice) {
            this.setProTotalPrice(ebOrder.getProTotalPrice());
        }
        if (ebOrder.isset_totalPostage) {
            this.setTotalPostage(ebOrder.getTotalPostage());
        }
        if (ebOrder.isset_totalPrice) {
            this.setTotalPrice(ebOrder.getTotalPrice());
        }
        if (ebOrder.isset_couponPrice) {
            this.setCouponPrice(ebOrder.getCouponPrice());
        }
        if (ebOrder.isset_useIntegral) {
            this.setUseIntegral(ebOrder.getUseIntegral());
        }
        if (ebOrder.isset_integralPrice) {
            this.setIntegralPrice(ebOrder.getIntegralPrice());
        }
        if (ebOrder.isset_payPrice) {
            this.setPayPrice(ebOrder.getPayPrice());
        }
        if (ebOrder.isset_payPostage) {
            this.setPayPostage(ebOrder.getPayPostage());
        }
        if (ebOrder.isset_paid) {
            this.setPaid(ebOrder.getPaid());
        }
        if (ebOrder.isset_payTime) {
            this.setPayTime(ebOrder.getPayTime());
        }
        if (ebOrder.isset_payType) {
            this.setPayType(ebOrder.getPayType());
        }
        if (ebOrder.isset_payChannel) {
            this.setPayChannel(ebOrder.getPayChannel());
        }
        if (ebOrder.isset_status) {
            this.setStatus(ebOrder.getStatus());
        }
        if (ebOrder.isset_refundStatus) {
            this.setRefundStatus(ebOrder.getRefundStatus());
        }
        if (ebOrder.isset_cancelStatus) {
            this.setCancelStatus(ebOrder.getCancelStatus());
        }
        if (ebOrder.isset_isUserDel) {
            this.setIsUserDel(ebOrder.getIsUserDel());
        }
        if (ebOrder.isset_isMerchantDel) {
            this.setIsMerchantDel(ebOrder.getIsMerchantDel());
        }
        if (ebOrder.isset_gainIntegral) {
            this.setGainIntegral(ebOrder.getGainIntegral());
        }
        if (ebOrder.isset_outTradeNo) {
            this.setOutTradeNo(ebOrder.getOutTradeNo());
        }
        if (ebOrder.isset_redirect) {
            this.setRedirect(ebOrder.getRedirect());
        }
        if (ebOrder.isset_type) {
            this.setType(ebOrder.getType());
        }
        if (ebOrder.isset_level) {
            this.setLevel(ebOrder.getLevel());
        }
        if (ebOrder.isset_platOrderNo) {
            this.setPlatOrderNo(ebOrder.getPlatOrderNo());
        }
        if (ebOrder.isset_isDel) {
            this.setIsDel(ebOrder.getIsDel());
        }
        if (ebOrder.isset_receivingTime) {
            this.setReceivingTime(ebOrder.getReceivingTime());
        }
        if (ebOrder.isset_createTime) {
            this.setCreateTime(ebOrder.getCreateTime());
        }
        if (ebOrder.isset_updateTime) {
            this.setUpdateTime(ebOrder.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_order.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_order";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ib.set(ProTotalPrice, this.getProTotalPrice(), this.isset_proTotalPrice);
        ib.set(TotalPostage, this.getTotalPostage(), this.isset_totalPostage);
        ib.set(TotalPrice, this.getTotalPrice(), this.isset_totalPrice);
        ib.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ib.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ib.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ib.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ib.set(PayPostage, this.getPayPostage(), this.isset_payPostage);
        ib.set(Paid, this.getPaid(), this.isset_paid);
        ib.set(PayTime, this.getPayTime(), this.isset_payTime);
        ib.set(PayType, this.getPayType(), this.isset_payType);
        ib.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ib.set(Status, this.getStatus(), this.isset_status);
        ib.set(RefundStatus, this.getRefundStatus(), this.isset_refundStatus);
        ib.set(CancelStatus, this.getCancelStatus(), this.isset_cancelStatus);
        ib.set(IsUserDel, this.getIsUserDel(), this.isset_isUserDel);
        ib.set(IsMerchantDel, this.getIsMerchantDel(), this.isset_isMerchantDel);
        ib.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ib.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ib.set(Redirect, this.getRedirect(), this.isset_redirect);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(Level, this.getLevel(), this.isset_level);
        ib.set(PlatOrderNo, this.getPlatOrderNo(), this.isset_platOrderNo);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(ReceivingTime, this.getReceivingTime(), this.isset_receivingTime);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ub.set(ProTotalPrice, this.getProTotalPrice(), this.isset_proTotalPrice);
        ub.set(TotalPostage, this.getTotalPostage(), this.isset_totalPostage);
        ub.set(TotalPrice, this.getTotalPrice(), this.isset_totalPrice);
        ub.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ub.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ub.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ub.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ub.set(PayPostage, this.getPayPostage(), this.isset_payPostage);
        ub.set(Paid, this.getPaid(), this.isset_paid);
        ub.set(PayTime, this.getPayTime(), this.isset_payTime);
        ub.set(PayType, this.getPayType(), this.isset_payType);
        ub.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(RefundStatus, this.getRefundStatus(), this.isset_refundStatus);
        ub.set(CancelStatus, this.getCancelStatus(), this.isset_cancelStatus);
        ub.set(IsUserDel, this.getIsUserDel(), this.isset_isUserDel);
        ub.set(IsMerchantDel, this.getIsMerchantDel(), this.isset_isMerchantDel);
        ub.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ub.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ub.set(Redirect, this.getRedirect(), this.isset_redirect);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Level, this.getLevel(), this.isset_level);
        ub.set(PlatOrderNo, this.getPlatOrderNo(), this.isset_platOrderNo);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(ReceivingTime, this.getReceivingTime(), this.isset_receivingTime);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ub.set(ProTotalPrice, this.getProTotalPrice(), this.isset_proTotalPrice);
        ub.set(TotalPostage, this.getTotalPostage(), this.isset_totalPostage);
        ub.set(TotalPrice, this.getTotalPrice(), this.isset_totalPrice);
        ub.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ub.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ub.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ub.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ub.set(PayPostage, this.getPayPostage(), this.isset_payPostage);
        ub.set(Paid, this.getPaid(), this.isset_paid);
        ub.set(PayTime, this.getPayTime(), this.isset_payTime);
        ub.set(PayType, this.getPayType(), this.isset_payType);
        ub.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(RefundStatus, this.getRefundStatus(), this.isset_refundStatus);
        ub.set(CancelStatus, this.getCancelStatus(), this.isset_cancelStatus);
        ub.set(IsUserDel, this.getIsUserDel(), this.isset_isUserDel);
        ub.set(IsMerchantDel, this.getIsMerchantDel(), this.isset_isMerchantDel);
        ub.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ub.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ub.set(Redirect, this.getRedirect(), this.isset_redirect);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Level, this.getLevel(), this.isset_level);
        ub.set(PlatOrderNo, this.getPlatOrderNo(), this.isset_platOrderNo);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(ReceivingTime, this.getReceivingTime(), this.isset_receivingTime);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(OrderNo, this.getOrderNo(), this.isset_orderNo);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(TotalNum, this.getTotalNum(), this.isset_totalNum);
        ub.set(ProTotalPrice, this.getProTotalPrice(), this.isset_proTotalPrice);
        ub.set(TotalPostage, this.getTotalPostage(), this.isset_totalPostage);
        ub.set(TotalPrice, this.getTotalPrice(), this.isset_totalPrice);
        ub.set(CouponPrice, this.getCouponPrice(), this.isset_couponPrice);
        ub.set(UseIntegral, this.getUseIntegral(), this.isset_useIntegral);
        ub.set(IntegralPrice, this.getIntegralPrice(), this.isset_integralPrice);
        ub.set(PayPrice, this.getPayPrice(), this.isset_payPrice);
        ub.set(PayPostage, this.getPayPostage(), this.isset_payPostage);
        ub.set(Paid, this.getPaid(), this.isset_paid);
        ub.set(PayTime, this.getPayTime(), this.isset_payTime);
        ub.set(PayType, this.getPayType(), this.isset_payType);
        ub.set(PayChannel, this.getPayChannel(), this.isset_payChannel);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(RefundStatus, this.getRefundStatus(), this.isset_refundStatus);
        ub.set(CancelStatus, this.getCancelStatus(), this.isset_cancelStatus);
        ub.set(IsUserDel, this.getIsUserDel(), this.isset_isUserDel);
        ub.set(IsMerchantDel, this.getIsMerchantDel(), this.isset_isMerchantDel);
        ub.set(GainIntegral, this.getGainIntegral(), this.isset_gainIntegral);
        ub.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ub.set(Redirect, this.getRedirect(), this.isset_redirect);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Level, this.getLevel(), this.isset_level);
        ub.set(PlatOrderNo, this.getPlatOrderNo(), this.isset_platOrderNo);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(ReceivingTime, this.getReceivingTime(), this.isset_receivingTime);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, order_no, mer_id, uid, total_num, pro_total_price, total_postage, total_price, coupon_price, use_integral, integral_price, pay_price, pay_postage, paid, pay_time, pay_type, pay_channel, status, refund_status, cancel_status, is_user_del, is_merchant_del, gain_integral, out_trade_no, redirect, type, level, plat_order_no, is_del, receiving_time, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, order_no, mer_id, uid, total_num, pro_total_price, total_postage, total_price, coupon_price, use_integral, integral_price, pay_price, pay_postage, paid, pay_time, pay_type, pay_channel, status, refund_status, cancel_status, is_user_del, is_merchant_del, gain_integral, out_trade_no, redirect, type, level, plat_order_no, is_del, receiving_time, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbOrder mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbOrder toEbOrder() {
        return super.$clone();
    }
}

/**
 * eb_order RowMapper
 *
 * @author genrator
 */
class EbOrderRowMapper implements RowMapper<EbOrder> {

    @Override
    public EbOrder mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbOrder eb_order = new EbOrder();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.Id);
        if (columnIndex > 0) {
            eb_order.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.OrderNo);
        if (columnIndex > 0) {
            eb_order.setOrderNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setMerId(null);
            } else {
                eb_order.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setUid(null);
            } else {
                eb_order.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.TotalNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setTotalNum(null);
            } else {
                eb_order.setTotalNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.ProTotalPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setProTotalPrice(null);
            } else {
                eb_order.setProTotalPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.TotalPostage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setTotalPostage(null);
            } else {
                eb_order.setTotalPostage(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.TotalPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setTotalPrice(null);
            } else {
                eb_order.setTotalPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.CouponPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setCouponPrice(null);
            } else {
                eb_order.setCouponPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.UseIntegral);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setUseIntegral(null);
            } else {
                eb_order.setUseIntegral(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.IntegralPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setIntegralPrice(null);
            } else {
                eb_order.setIntegralPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.PayPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setPayPrice(null);
            } else {
                eb_order.setPayPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.PayPostage);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setPayPostage(null);
            } else {
                eb_order.setPayPostage(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.Paid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setPaid(null);
            } else {
                eb_order.setPaid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.PayTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setPayTime(null);
            } else {
                eb_order.setPayTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.PayType);
        if (columnIndex > 0) {
            eb_order.setPayType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.PayChannel);
        if (columnIndex > 0) {
            eb_order.setPayChannel(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setStatus(null);
            } else {
                eb_order.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.RefundStatus);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setRefundStatus(null);
            } else {
                eb_order.setRefundStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.CancelStatus);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setCancelStatus(null);
            } else {
                eb_order.setCancelStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.IsUserDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setIsUserDel(null);
            } else {
                eb_order.setIsUserDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.IsMerchantDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setIsMerchantDel(null);
            } else {
                eb_order.setIsMerchantDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.GainIntegral);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setGainIntegral(null);
            } else {
                eb_order.setGainIntegral(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.OutTradeNo);
        if (columnIndex > 0) {
            eb_order.setOutTradeNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.Redirect);
        if (columnIndex > 0) {
            eb_order.setRedirect(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setType(null);
            } else {
                eb_order.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.Level);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setLevel(null);
            } else {
                eb_order.setLevel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.PlatOrderNo);
        if (columnIndex > 0) {
            eb_order.setPlatOrderNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setIsDel(null);
            } else {
                eb_order.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.ReceivingTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setReceivingTime(null);
            } else {
                eb_order.setReceivingTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setCreateTime(null);
            } else {
                eb_order.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbOrder_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_order.setUpdateTime(null);
            } else {
                eb_order.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_order;
    }
}
