
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_PRODUCT_ATTR *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbProductAttr extends BasePo<EbProductAttr> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

//    /**
//     * 用于兼容老写法
//     */
//    @JsonIgnore
//    public static final EbProductAttr ROW_MAPPER = new EbProductAttr();

    // 主键
    private Integer id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Long productId = null;
    @JsonIgnore
    protected boolean isset_productId = false;

    private String attrName = null;
    @JsonIgnore
    protected boolean isset_attrName = false;

    private String attrValues = null;
    @JsonIgnore
    protected boolean isset_attrValues = false;

    private Integer type = null;
    @JsonIgnore
    protected boolean isset_type = false;

    private Integer isDel = null;
    @JsonIgnore
    protected boolean isset_isDel = false;

    /**
     * 默认构造函数
     */
    public EbProductAttr() {
    }

    /**
     * 根据主键构造对象
     */
    public EbProductAttr(Integer id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Integer) value);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
        this.isset_productId = true;
    }

    @JsonIgnore
    public boolean isEmptyProductId() {
        return this.productId == null;
    }

    public String getAttrName() {
        return this.attrName;
    }

    public void setAttrName(String attrName) {
        this.attrName = attrName;
        this.isset_attrName = true;
    }

    @JsonIgnore
    public boolean isEmptyAttrName() {
        return this.attrName == null || this.attrName.length() == 0;
    }

    public String getAttrValues() {
        return this.attrValues;
    }

    public void setAttrValues(String attrValues) {
        this.attrValues = attrValues;
        this.isset_attrValues = true;
    }

    @JsonIgnore
    public boolean isEmptyAttrValues() {
        return this.attrValues == null || this.attrValues.length() == 0;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
        this.isset_type = true;
    }

    @JsonIgnore
    public boolean isEmptyType() {
        return this.type == null;
    }

    public Integer getIsDel() {
        return this.isDel;
    }

    public void setIsDel(Integer isDel) {
        this.isDel = isDel;
        this.isset_isDel = true;
    }

    @JsonIgnore
    public boolean isEmptyIsDel() {
        return this.isDel == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("productId=").append(this.productId)
                .append("attrName=").append(this.attrName)
                .append("attrValues=").append(this.attrValues)
                .append("type=").append(this.type)
                .append("isDel=").append(this.isDel)
                .toString();
    }

    /**
     * 克隆
     */
    public EbProductAttr $clone() {
        EbProductAttr eb_product_attr = new EbProductAttr();

        // 数据库名称
        //eb_product_attr.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_product_attr.setId(this.getId());
        }
        // 普通属性
        if (this.isset_productId) {
            eb_product_attr.setProductId(this.getProductId());
        }
        if (this.isset_attrName) {
            eb_product_attr.setAttrName(this.getAttrName());
        }
        if (this.isset_attrValues) {
            eb_product_attr.setAttrValues(this.getAttrValues());
        }
        if (this.isset_type) {
            eb_product_attr.setType(this.getType());
        }
        if (this.isset_isDel) {
            eb_product_attr.setIsDel(this.getIsDel());
        }
        return eb_product_attr;
    }

    /**
     * 缓存在Redis 中，删除需要重写下面方法。
     * @param obj
     * @return
     * @date 2023-06-14
     */
    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(obj instanceof EbProductAttr){
            EbProductAttr attr = (EbProductAttr) obj;
            if(attr.getId().intValue() == this.getId().intValue()){
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode(){
        return this.getId().hashCode();
    }
}
