
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_PRODUCT_COUPON *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbProductCoupon extends BasePo<EbProductCoupon> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbProductCoupon ROW_MAPPER = new EbProductCoupon();

    // 主键
    private Long id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Long productId = null;
    @JsonIgnore
    protected boolean isset_productId = false;

    private Integer couponId = null;
    @JsonIgnore
    protected boolean isset_couponId = false;

    private Integer addTime = null;
    @JsonIgnore
    protected boolean isset_addTime = false;

    /**
     * 默认构造函数
     */
    public EbProductCoupon() {
    }

    /**
     * 根据主键构造对象
     */
    public EbProductCoupon(Long id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Long) value);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
        this.isset_productId = true;
    }

    @JsonIgnore
    public boolean isEmptyProductId() {
        return this.productId == null;
    }

    public Integer getCouponId() {
        return this.couponId;
    }

    public void setCouponId(Integer couponId) {
        this.couponId = couponId;
        this.isset_couponId = true;
    }

    @JsonIgnore
    public boolean isEmptyCouponId() {
        return this.couponId == null;
    }

    public Integer getAddTime() {
        return this.addTime;
    }

    public void setAddTime(Integer addTime) {
        this.addTime = addTime;
        this.isset_addTime = true;
    }

    @JsonIgnore
    public boolean isEmptyAddTime() {
        return this.addTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("productId=").append(this.productId)
                .append("couponId=").append(this.couponId)
                .append("addTime=").append(this.addTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbProductCoupon $clone() {
        EbProductCoupon eb_product_coupon = new EbProductCoupon();

        // 数据库名称
        //eb_product_coupon.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_product_coupon.setId(this.getId());
        }
        // 普通属性
        if (this.isset_productId) {
            eb_product_coupon.setProductId(this.getProductId());
        }
        if (this.isset_couponId) {
            eb_product_coupon.setCouponId(this.getCouponId());
        }
        if (this.isset_addTime) {
            eb_product_coupon.setAddTime(this.getAddTime());
        }
        return eb_product_coupon;
    }
}
