package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_PRODUCT_RULE *
 * @author genrator
 */
public class EbProductRule_mapper extends EbProductRule implements BaseMapper<EbProductRule> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbProductRule> ROW_MAPPER = new EbProductRuleRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String MerId = "mer_id";
    public static final String RuleName = "rule_name";
    public static final String RuleValue = "rule_value";

    /**
     * 默认构造函数
     */
    public EbProductRule_mapper(EbProductRule ebProductRule) {
        if (ebProductRule == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebProductRule.isset_id) {
            this.setId(ebProductRule.getId());
        }
        //普通属性
        if (ebProductRule.isset_merId) {
            this.setMerId(ebProductRule.getMerId());
        }
        if (ebProductRule.isset_ruleName) {
            this.setRuleName(ebProductRule.getRuleName());
        }
        if (ebProductRule.isset_ruleValue) {
            this.setRuleValue(ebProductRule.getRuleValue());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_product_rule.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_product_rule";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(RuleName, this.getRuleName(), this.isset_ruleName);
        ib.set(RuleValue, this.getRuleValue(), this.isset_ruleValue);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(RuleName, this.getRuleName(), this.isset_ruleName);
        ub.set(RuleValue, this.getRuleValue(), this.isset_ruleValue);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(RuleName, this.getRuleName(), this.isset_ruleName);
        ub.set(RuleValue, this.getRuleValue(), this.isset_ruleValue);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(RuleName, this.getRuleName(), this.isset_ruleName);
        ub.set(RuleValue, this.getRuleValue(), this.isset_ruleValue);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, mer_id, rule_name, rule_value from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, mer_id, rule_name, rule_value from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbProductRule mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbProductRule toEbProductRule() {
        return super.$clone();
    }
}

/**
 * eb_product_rule RowMapper
 *
 * @author genrator
 */
class EbProductRuleRowMapper implements RowMapper<EbProductRule> {

    @Override
    public EbProductRule mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbProductRule eb_product_rule = new EbProductRule();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbProductRule_mapper.Id);
        if (columnIndex > 0) {
            eb_product_rule.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbProductRule_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product_rule.setMerId(null);
            } else {
                eb_product_rule.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductRule_mapper.RuleName);
        if (columnIndex > 0) {
            eb_product_rule.setRuleName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProductRule_mapper.RuleValue);
        if (columnIndex > 0) {
            eb_product_rule.setRuleValue(rs.getString(columnIndex));
        }
        return eb_product_rule;
    }
}
