package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_PRODUCT *
 * @author genrator
 */
public class EbProduct_mapper extends EbProduct implements BaseMapper<EbProduct> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbProduct> ROW_MAPPER = new EbProductRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String MerId = "mer_id";
    public static final String Image = "image";
    public static final String FlatPattern = "flat_pattern";
    public static final String SliderImage = "slider_image";
    public static final String Name = "name";
    public static final String Intro = "intro";
    public static final String Keyword = "keyword";
    public static final String CateId = "cate_id";
    public static final String BrandId = "brand_id";
    public static final String CategoryId = "category_id";
    public static final String GuaranteeIds = "guarantee_ids";
    public static final String Price = "price";
    public static final String VipPrice = "vip_price";
    public static final String OtPrice = "ot_price";
    public static final String UnitName = "unit_name";
    public static final String Sales = "sales";
    public static final String Stock = "stock";
    public static final String Cost = "cost";
    public static final String Ficti = "ficti";
    public static final String Browse = "browse";
    public static final String CodePath = "code_path";
    public static final String SoureLink = "soure_link";
    public static final String VideoLink = "video_link";
    public static final String TempId = "temp_id";
    public static final String Sort = "sort";
    public static final String RankNum = "rank_num";
    public static final String SpecType = "spec_type";
    public static final String IsRecycle = "is_recycle";
    public static final String IsSub = "is_sub";
    public static final String IsShow = "is_show";
    public static final String AuditStatus = "audit_status";
    public static final String IsAudit = "is_audit";
    public static final String Reason = "reason";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbProduct_mapper(EbProduct ebProduct) {
        if (ebProduct == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebProduct.isset_id) {
            this.setId(ebProduct.getId());
        }
        //普通属性
        if (ebProduct.isset_merId) {
            this.setMerId(ebProduct.getMerId());
        }
        if (ebProduct.isset_image) {
            this.setImage(ebProduct.getImage());
        }
        if (ebProduct.isset_flatPattern) {
            this.setFlatPattern(ebProduct.getFlatPattern());
        }
        if (ebProduct.isset_sliderImage) {
            this.setSliderImage(ebProduct.getSliderImage());
        }
        if (ebProduct.isset_name) {
            this.setName(ebProduct.getName());
        }
        if (ebProduct.isset_intro) {
            this.setIntro(ebProduct.getIntro());
        }
        if (ebProduct.isset_keyword) {
            this.setKeyword(ebProduct.getKeyword());
        }
        if (ebProduct.isset_cateId) {
            this.setCateId(ebProduct.getCateId());
        }
        if (ebProduct.isset_brandId) {
            this.setBrandId(ebProduct.getBrandId());
        }
        if (ebProduct.isset_categoryId) {
            this.setCategoryId(ebProduct.getCategoryId());
        }
        if (ebProduct.isset_guaranteeIds) {
            this.setGuaranteeIds(ebProduct.getGuaranteeIds());
        }
        if (ebProduct.isset_price) {
            this.setPrice(ebProduct.getPrice());
        }
        if (ebProduct.isset_vipPrice) {
            this.setVipPrice(ebProduct.getVipPrice());
        }
        if (ebProduct.isset_otPrice) {
            this.setOtPrice(ebProduct.getOtPrice());
        }
        if (ebProduct.isset_unitName) {
            this.setUnitName(ebProduct.getUnitName());
        }
        if (ebProduct.isset_sales) {
            this.setSales(ebProduct.getSales());
        }
        if (ebProduct.isset_stock) {
            this.setStock(ebProduct.getStock());
        }
        if (ebProduct.isset_cost) {
            this.setCost(ebProduct.getCost());
        }
        if (ebProduct.isset_ficti) {
            this.setFicti(ebProduct.getFicti());
        }
        if (ebProduct.isset_browse) {
            this.setBrowse(ebProduct.getBrowse());
        }
        if (ebProduct.isset_codePath) {
            this.setCodePath(ebProduct.getCodePath());
        }
        if (ebProduct.isset_soureLink) {
            this.setSoureLink(ebProduct.getSoureLink());
        }
        if (ebProduct.isset_videoLink) {
            this.setVideoLink(ebProduct.getVideoLink());
        }
        if (ebProduct.isset_tempId) {
            this.setTempId(ebProduct.getTempId());
        }
        if (ebProduct.isset_sort) {
            this.setSort(ebProduct.getSort());
        }
        if (ebProduct.isset_rankNum) {
            this.setRankNum(ebProduct.getRankNum());
        }
        if (ebProduct.isset_specType) {
            this.setSpecType(ebProduct.getSpecType());
        }
        if (ebProduct.isset_isRecycle) {
            this.setIsRecycle(ebProduct.getIsRecycle());
        }
        if (ebProduct.isset_isSub) {
            this.setIsSub(ebProduct.getIsSub());
        }
        if (ebProduct.isset_isShow) {
            this.setIsShow(ebProduct.getIsShow());
        }
        if (ebProduct.isset_auditStatus) {
            this.setAuditStatus(ebProduct.getAuditStatus());
        }
        if (ebProduct.isset_isAudit) {
            this.setIsAudit(ebProduct.getIsAudit());
        }
        if (ebProduct.isset_reason) {
            this.setReason(ebProduct.getReason());
        }
        if (ebProduct.isset_isDel) {
            this.setIsDel(ebProduct.getIsDel());
        }
        if (ebProduct.isset_createTime) {
            this.setCreateTime(ebProduct.getCreateTime());
        }
        if (ebProduct.isset_updateTime) {
            this.setUpdateTime(ebProduct.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_product.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_product";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(Image, this.getImage(), this.isset_image);
        ib.set(FlatPattern, this.getFlatPattern(), this.isset_flatPattern);
        ib.set(SliderImage, this.getSliderImage(), this.isset_sliderImage);
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(Intro, this.getIntro(), this.isset_intro);
        ib.set(Keyword, this.getKeyword(), this.isset_keyword);
        ib.set(CateId, this.getCateId(), this.isset_cateId);
        ib.set(BrandId, this.getBrandId(), this.isset_brandId);
        ib.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ib.set(GuaranteeIds, this.getGuaranteeIds(), this.isset_guaranteeIds);
        ib.set(Price, this.getPrice(), this.isset_price);
        ib.set(VipPrice, this.getVipPrice(), this.isset_vipPrice);
        ib.set(OtPrice, this.getOtPrice(), this.isset_otPrice);
        ib.set(UnitName, this.getUnitName(), this.isset_unitName);
        ib.set(Sales, this.getSales(), this.isset_sales);
        ib.set(Stock, this.getStock(), this.isset_stock);
        ib.set(Cost, this.getCost(), this.isset_cost);
        ib.set(Ficti, this.getFicti(), this.isset_ficti);
        ib.set(Browse, this.getBrowse(), this.isset_browse);
        ib.set(CodePath, this.getCodePath(), this.isset_codePath);
        ib.set(SoureLink, this.getSoureLink(), this.isset_soureLink);
        ib.set(VideoLink, this.getVideoLink(), this.isset_videoLink);
        ib.set(TempId, this.getTempId(), this.isset_tempId);
        ib.set(Sort, this.getSort(), this.isset_sort);
        ib.set(RankNum, this.getRankNum(), this.isset_rankNum);
        ib.set(SpecType, this.getSpecType(), this.isset_specType);
        ib.set(IsRecycle, this.getIsRecycle(), this.isset_isRecycle);
        ib.set(IsSub, this.getIsSub(), this.isset_isSub);
        ib.set(IsShow, this.getIsShow(), this.isset_isShow);
        ib.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ib.set(IsAudit, this.getIsAudit(), this.isset_isAudit);
        ib.set(Reason, this.getReason(), this.isset_reason);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(FlatPattern, this.getFlatPattern(), this.isset_flatPattern);
        ub.set(SliderImage, this.getSliderImage(), this.isset_sliderImage);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Intro, this.getIntro(), this.isset_intro);
        ub.set(Keyword, this.getKeyword(), this.isset_keyword);
        ub.set(CateId, this.getCateId(), this.isset_cateId);
        ub.set(BrandId, this.getBrandId(), this.isset_brandId);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(GuaranteeIds, this.getGuaranteeIds(), this.isset_guaranteeIds);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(VipPrice, this.getVipPrice(), this.isset_vipPrice);
        ub.set(OtPrice, this.getOtPrice(), this.isset_otPrice);
        ub.set(UnitName, this.getUnitName(), this.isset_unitName);
        ub.set(Sales, this.getSales(), this.isset_sales);
        ub.set(Stock, this.getStock(), this.isset_stock);
        ub.set(Cost, this.getCost(), this.isset_cost);
        ub.set(Ficti, this.getFicti(), this.isset_ficti);
        ub.set(Browse, this.getBrowse(), this.isset_browse);
        ub.set(CodePath, this.getCodePath(), this.isset_codePath);
        ub.set(SoureLink, this.getSoureLink(), this.isset_soureLink);
        ub.set(VideoLink, this.getVideoLink(), this.isset_videoLink);
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(RankNum, this.getRankNum(), this.isset_rankNum);
        ub.set(SpecType, this.getSpecType(), this.isset_specType);
        ub.set(IsRecycle, this.getIsRecycle(), this.isset_isRecycle);
        ub.set(IsSub, this.getIsSub(), this.isset_isSub);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(IsAudit, this.getIsAudit(), this.isset_isAudit);
        ub.set(Reason, this.getReason(), this.isset_reason);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(FlatPattern, this.getFlatPattern(), this.isset_flatPattern);
        ub.set(SliderImage, this.getSliderImage(), this.isset_sliderImage);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Intro, this.getIntro(), this.isset_intro);
        ub.set(Keyword, this.getKeyword(), this.isset_keyword);
        ub.set(CateId, this.getCateId(), this.isset_cateId);
        ub.set(BrandId, this.getBrandId(), this.isset_brandId);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(GuaranteeIds, this.getGuaranteeIds(), this.isset_guaranteeIds);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(VipPrice, this.getVipPrice(), this.isset_vipPrice);
        ub.set(OtPrice, this.getOtPrice(), this.isset_otPrice);
        ub.set(UnitName, this.getUnitName(), this.isset_unitName);
        ub.set(Sales, this.getSales(), this.isset_sales);
        ub.set(Stock, this.getStock(), this.isset_stock);
        ub.set(Cost, this.getCost(), this.isset_cost);
        ub.set(Ficti, this.getFicti(), this.isset_ficti);
        ub.set(Browse, this.getBrowse(), this.isset_browse);
        ub.set(CodePath, this.getCodePath(), this.isset_codePath);
        ub.set(SoureLink, this.getSoureLink(), this.isset_soureLink);
        ub.set(VideoLink, this.getVideoLink(), this.isset_videoLink);
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(RankNum, this.getRankNum(), this.isset_rankNum);
        ub.set(SpecType, this.getSpecType(), this.isset_specType);
        ub.set(IsRecycle, this.getIsRecycle(), this.isset_isRecycle);
        ub.set(IsSub, this.getIsSub(), this.isset_isSub);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(IsAudit, this.getIsAudit(), this.isset_isAudit);
        ub.set(Reason, this.getReason(), this.isset_reason);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(FlatPattern, this.getFlatPattern(), this.isset_flatPattern);
        ub.set(SliderImage, this.getSliderImage(), this.isset_sliderImage);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Intro, this.getIntro(), this.isset_intro);
        ub.set(Keyword, this.getKeyword(), this.isset_keyword);
        ub.set(CateId, this.getCateId(), this.isset_cateId);
        ub.set(BrandId, this.getBrandId(), this.isset_brandId);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(GuaranteeIds, this.getGuaranteeIds(), this.isset_guaranteeIds);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(VipPrice, this.getVipPrice(), this.isset_vipPrice);
        ub.set(OtPrice, this.getOtPrice(), this.isset_otPrice);
        ub.set(UnitName, this.getUnitName(), this.isset_unitName);
        ub.set(Sales, this.getSales(), this.isset_sales);
        ub.set(Stock, this.getStock(), this.isset_stock);
        ub.set(Cost, this.getCost(), this.isset_cost);
        ub.set(Ficti, this.getFicti(), this.isset_ficti);
        ub.set(Browse, this.getBrowse(), this.isset_browse);
        ub.set(CodePath, this.getCodePath(), this.isset_codePath);
        ub.set(SoureLink, this.getSoureLink(), this.isset_soureLink);
        ub.set(VideoLink, this.getVideoLink(), this.isset_videoLink);
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(RankNum, this.getRankNum(), this.isset_rankNum);
        ub.set(SpecType, this.getSpecType(), this.isset_specType);
        ub.set(IsRecycle, this.getIsRecycle(), this.isset_isRecycle);
        ub.set(IsSub, this.getIsSub(), this.isset_isSub);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(IsAudit, this.getIsAudit(), this.isset_isAudit);
        ub.set(Reason, this.getReason(), this.isset_reason);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, mer_id, image, flat_pattern, slider_image, name, intro, keyword, cate_id, brand_id, category_id, guarantee_ids, price, vip_price, ot_price, unit_name, sales, stock, cost, ficti, browse, code_path, soure_link, video_link, temp_id, sort, rank_num, spec_type, is_recycle, is_sub, is_show, audit_status, is_audit, reason, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, mer_id, image, flat_pattern, slider_image, name, intro, keyword, cate_id, brand_id, category_id, guarantee_ids, price, vip_price, ot_price, unit_name, sales, stock, cost, ficti, browse, code_path, soure_link, video_link, temp_id, sort, rank_num, spec_type, is_recycle, is_sub, is_show, audit_status, is_audit, reason, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbProduct mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbProduct toEbProduct() {
        return super.$clone();
    }
}

/**
 * eb_product RowMapper
 *
 * @author genrator
 */
class EbProductRowMapper implements RowMapper<EbProduct> {

    @Override
    public EbProduct mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbProduct eb_product = new EbProduct();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Id);
        if (columnIndex > 0) {
            eb_product.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setMerId(null);
            } else {
                eb_product.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Image);
        if (columnIndex > 0) {
            eb_product.setImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.FlatPattern);
        if (columnIndex > 0) {
            eb_product.setFlatPattern(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.SliderImage);
        if (columnIndex > 0) {
            eb_product.setSliderImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Name);
        if (columnIndex > 0) {
            eb_product.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Intro);
        if (columnIndex > 0) {
            eb_product.setIntro(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Keyword);
        if (columnIndex > 0) {
            eb_product.setKeyword(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.CateId);
        if (columnIndex > 0) {
            eb_product.setCateId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.BrandId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setBrandId(null);
            } else {
                eb_product.setBrandId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.CategoryId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setCategoryId(null);
            } else {
                eb_product.setCategoryId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.GuaranteeIds);
        if (columnIndex > 0) {
            eb_product.setGuaranteeIds(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Price);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setPrice(null);
            } else {
                eb_product.setPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.VipPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setVipPrice(null);
            } else {
                eb_product.setVipPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.OtPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setOtPrice(null);
            } else {
                eb_product.setOtPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.UnitName);
        if (columnIndex > 0) {
            eb_product.setUnitName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Sales);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setSales(null);
            } else {
                eb_product.setSales(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Stock);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setStock(null);
            } else {
                eb_product.setStock(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Cost);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setCost(null);
            } else {
                eb_product.setCost(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Ficti);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setFicti(null);
            } else {
                eb_product.setFicti(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Browse);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setBrowse(null);
            } else {
                eb_product.setBrowse(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.CodePath);
        if (columnIndex > 0) {
            eb_product.setCodePath(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.SoureLink);
        if (columnIndex > 0) {
            eb_product.setSoureLink(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.VideoLink);
        if (columnIndex > 0) {
            eb_product.setVideoLink(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.TempId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setTempId(null);
            } else {
                eb_product.setTempId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Sort);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setSort(null);
            } else {
                eb_product.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.RankNum);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setRankNum(null);
            } else {
                eb_product.setRankNum(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.SpecType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setSpecType(null);
            } else {
                eb_product.setSpecType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.IsRecycle);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setIsRecycle(null);
            } else {
                eb_product.setIsRecycle(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.IsSub);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setIsSub(null);
            } else {
                eb_product.setIsSub(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.IsShow);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setIsShow(null);
            } else {
                eb_product.setIsShow(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.AuditStatus);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setAuditStatus(null);
            } else {
                eb_product.setAuditStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.IsAudit);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setIsAudit(null);
            } else {
                eb_product.setIsAudit(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.Reason);
        if (columnIndex > 0) {
            eb_product.setReason(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setIsDel(null);
            } else {
                eb_product.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setCreateTime(null);
            } else {
                eb_product.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbProduct_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_product.setUpdateTime(null);
            } else {
                eb_product.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_product;
    }
}
