package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_SECKILL_PRODUCT *
 * @author genrator
 */
public class EbSeckillProduct_mapper extends EbSeckillProduct implements BaseMapper<EbSeckillProduct> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbSeckillProduct> ROW_MAPPER = new EbSeckillProductRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String ActivityId = "activity_id";
    public static final String ProductId = "product_id";
    public static final String MerId = "mer_id";
    public static final String Image = "image";
    public static final String FlatPattern = "flat_pattern";
    public static final String SliderImage = "slider_image";
    public static final String Name = "name";
    public static final String Intro = "intro";
    public static final String Keyword = "keyword";
    public static final String BrandId = "brand_id";
    public static final String CategoryId = "category_id";
    public static final String GuaranteeIds = "guarantee_ids";
    public static final String Price = "price";
    public static final String SeckillPrice = "seckill_price";
    public static final String UnitName = "unit_name";
    public static final String Sales = "sales";
    public static final String TempId = "temp_id";
    public static final String Sort = "sort";
    public static final String SpecType = "spec_type";
    public static final String IsShow = "is_show";
    public static final String AuditStatus = "audit_status";
    public static final String Reason = "reason";
    public static final String QuotaShow = "quota_show";
    public static final String Quota = "quota";
    public static final String IsDel = "is_del";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbSeckillProduct_mapper(EbSeckillProduct ebSeckillProduct) {
        if (ebSeckillProduct == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebSeckillProduct.isset_id) {
            this.setId(ebSeckillProduct.getId());
        }
        //普通属性
        if (ebSeckillProduct.isset_activityId) {
            this.setActivityId(ebSeckillProduct.getActivityId());
        }
        if (ebSeckillProduct.isset_productId) {
            this.setProductId(ebSeckillProduct.getProductId());
        }
        if (ebSeckillProduct.isset_merId) {
            this.setMerId(ebSeckillProduct.getMerId());
        }
        if (ebSeckillProduct.isset_image) {
            this.setImage(ebSeckillProduct.getImage());
        }
        if (ebSeckillProduct.isset_flatPattern) {
            this.setFlatPattern(ebSeckillProduct.getFlatPattern());
        }
        if (ebSeckillProduct.isset_sliderImage) {
            this.setSliderImage(ebSeckillProduct.getSliderImage());
        }
        if (ebSeckillProduct.isset_name) {
            this.setName(ebSeckillProduct.getName());
        }
        if (ebSeckillProduct.isset_intro) {
            this.setIntro(ebSeckillProduct.getIntro());
        }
        if (ebSeckillProduct.isset_keyword) {
            this.setKeyword(ebSeckillProduct.getKeyword());
        }
        if (ebSeckillProduct.isset_brandId) {
            this.setBrandId(ebSeckillProduct.getBrandId());
        }
        if (ebSeckillProduct.isset_categoryId) {
            this.setCategoryId(ebSeckillProduct.getCategoryId());
        }
        if (ebSeckillProduct.isset_guaranteeIds) {
            this.setGuaranteeIds(ebSeckillProduct.getGuaranteeIds());
        }
        if (ebSeckillProduct.isset_price) {
            this.setPrice(ebSeckillProduct.getPrice());
        }
        if (ebSeckillProduct.isset_seckillPrice) {
            this.setSeckillPrice(ebSeckillProduct.getSeckillPrice());
        }
        if (ebSeckillProduct.isset_unitName) {
            this.setUnitName(ebSeckillProduct.getUnitName());
        }
        if (ebSeckillProduct.isset_sales) {
            this.setSales(ebSeckillProduct.getSales());
        }
        if (ebSeckillProduct.isset_tempId) {
            this.setTempId(ebSeckillProduct.getTempId());
        }
        if (ebSeckillProduct.isset_sort) {
            this.setSort(ebSeckillProduct.getSort());
        }
        if (ebSeckillProduct.isset_specType) {
            this.setSpecType(ebSeckillProduct.getSpecType());
        }
        if (ebSeckillProduct.isset_isShow) {
            this.setIsShow(ebSeckillProduct.getIsShow());
        }
        if (ebSeckillProduct.isset_auditStatus) {
            this.setAuditStatus(ebSeckillProduct.getAuditStatus());
        }
        if (ebSeckillProduct.isset_reason) {
            this.setReason(ebSeckillProduct.getReason());
        }
        if (ebSeckillProduct.isset_quotaShow) {
            this.setQuotaShow(ebSeckillProduct.getQuotaShow());
        }
        if (ebSeckillProduct.isset_quota) {
            this.setQuota(ebSeckillProduct.getQuota());
        }
        if (ebSeckillProduct.isset_isDel) {
            this.setIsDel(ebSeckillProduct.getIsDel());
        }
        if (ebSeckillProduct.isset_createTime) {
            this.setCreateTime(ebSeckillProduct.getCreateTime());
        }
        if (ebSeckillProduct.isset_updateTime) {
            this.setUpdateTime(ebSeckillProduct.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_seckill_product.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_seckill_product";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(ActivityId, this.getActivityId(), this.isset_activityId);
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(MerId, this.getMerId(), this.isset_merId);
        ib.set(Image, this.getImage(), this.isset_image);
        ib.set(FlatPattern, this.getFlatPattern(), this.isset_flatPattern);
        ib.set(SliderImage, this.getSliderImage(), this.isset_sliderImage);
        ib.set(Name, this.getName(), this.isset_name);
        ib.set(Intro, this.getIntro(), this.isset_intro);
        ib.set(Keyword, this.getKeyword(), this.isset_keyword);
        ib.set(BrandId, this.getBrandId(), this.isset_brandId);
        ib.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ib.set(GuaranteeIds, this.getGuaranteeIds(), this.isset_guaranteeIds);
        ib.set(Price, this.getPrice(), this.isset_price);
        ib.set(SeckillPrice, this.getSeckillPrice(), this.isset_seckillPrice);
        ib.set(UnitName, this.getUnitName(), this.isset_unitName);
        ib.set(Sales, this.getSales(), this.isset_sales);
        ib.set(TempId, this.getTempId(), this.isset_tempId);
        ib.set(Sort, this.getSort(), this.isset_sort);
        ib.set(SpecType, this.getSpecType(), this.isset_specType);
        ib.set(IsShow, this.getIsShow(), this.isset_isShow);
        ib.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ib.set(Reason, this.getReason(), this.isset_reason);
        ib.set(QuotaShow, this.getQuotaShow(), this.isset_quotaShow);
        ib.set(Quota, this.getQuota(), this.isset_quota);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ActivityId, this.getActivityId(), this.isset_activityId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(FlatPattern, this.getFlatPattern(), this.isset_flatPattern);
        ub.set(SliderImage, this.getSliderImage(), this.isset_sliderImage);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Intro, this.getIntro(), this.isset_intro);
        ub.set(Keyword, this.getKeyword(), this.isset_keyword);
        ub.set(BrandId, this.getBrandId(), this.isset_brandId);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(GuaranteeIds, this.getGuaranteeIds(), this.isset_guaranteeIds);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(SeckillPrice, this.getSeckillPrice(), this.isset_seckillPrice);
        ub.set(UnitName, this.getUnitName(), this.isset_unitName);
        ub.set(Sales, this.getSales(), this.isset_sales);
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(SpecType, this.getSpecType(), this.isset_specType);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(Reason, this.getReason(), this.isset_reason);
        ub.set(QuotaShow, this.getQuotaShow(), this.isset_quotaShow);
        ub.set(Quota, this.getQuota(), this.isset_quota);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ActivityId, this.getActivityId(), this.isset_activityId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(FlatPattern, this.getFlatPattern(), this.isset_flatPattern);
        ub.set(SliderImage, this.getSliderImage(), this.isset_sliderImage);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Intro, this.getIntro(), this.isset_intro);
        ub.set(Keyword, this.getKeyword(), this.isset_keyword);
        ub.set(BrandId, this.getBrandId(), this.isset_brandId);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(GuaranteeIds, this.getGuaranteeIds(), this.isset_guaranteeIds);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(SeckillPrice, this.getSeckillPrice(), this.isset_seckillPrice);
        ub.set(UnitName, this.getUnitName(), this.isset_unitName);
        ub.set(Sales, this.getSales(), this.isset_sales);
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(SpecType, this.getSpecType(), this.isset_specType);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(Reason, this.getReason(), this.isset_reason);
        ub.set(QuotaShow, this.getQuotaShow(), this.isset_quotaShow);
        ub.set(Quota, this.getQuota(), this.isset_quota);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ActivityId, this.getActivityId(), this.isset_activityId);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(MerId, this.getMerId(), this.isset_merId);
        ub.set(Image, this.getImage(), this.isset_image);
        ub.set(FlatPattern, this.getFlatPattern(), this.isset_flatPattern);
        ub.set(SliderImage, this.getSliderImage(), this.isset_sliderImage);
        ub.set(Name, this.getName(), this.isset_name);
        ub.set(Intro, this.getIntro(), this.isset_intro);
        ub.set(Keyword, this.getKeyword(), this.isset_keyword);
        ub.set(BrandId, this.getBrandId(), this.isset_brandId);
        ub.set(CategoryId, this.getCategoryId(), this.isset_categoryId);
        ub.set(GuaranteeIds, this.getGuaranteeIds(), this.isset_guaranteeIds);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(SeckillPrice, this.getSeckillPrice(), this.isset_seckillPrice);
        ub.set(UnitName, this.getUnitName(), this.isset_unitName);
        ub.set(Sales, this.getSales(), this.isset_sales);
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(Sort, this.getSort(), this.isset_sort);
        ub.set(SpecType, this.getSpecType(), this.isset_specType);
        ub.set(IsShow, this.getIsShow(), this.isset_isShow);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(Reason, this.getReason(), this.isset_reason);
        ub.set(QuotaShow, this.getQuotaShow(), this.isset_quotaShow);
        ub.set(Quota, this.getQuota(), this.isset_quota);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, activity_id, product_id, mer_id, image, flat_pattern, slider_image, name, intro, keyword, brand_id, category_id, guarantee_ids, price, seckill_price, unit_name, sales, temp_id, sort, spec_type, is_show, audit_status, reason, quota_show, quota, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, activity_id, product_id, mer_id, image, flat_pattern, slider_image, name, intro, keyword, brand_id, category_id, guarantee_ids, price, seckill_price, unit_name, sales, temp_id, sort, spec_type, is_show, audit_status, reason, quota_show, quota, is_del, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbSeckillProduct mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbSeckillProduct toEbSeckillProduct() {
        return super.$clone();
    }
}

/**
 * eb_seckill_product RowMapper
 *
 * @author genrator
 */
class EbSeckillProductRowMapper implements RowMapper<EbSeckillProduct> {

    @Override
    public EbSeckillProduct mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbSeckillProduct eb_seckill_product = new EbSeckillProduct();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Id);
        if (columnIndex > 0) {
            eb_seckill_product.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.ActivityId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setActivityId(null);
            } else {
                eb_seckill_product.setActivityId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.ProductId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setProductId(null);
            } else {
                eb_seckill_product.setProductId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.MerId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setMerId(null);
            } else {
                eb_seckill_product.setMerId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Image);
        if (columnIndex > 0) {
            eb_seckill_product.setImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.FlatPattern);
        if (columnIndex > 0) {
            eb_seckill_product.setFlatPattern(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.SliderImage);
        if (columnIndex > 0) {
            eb_seckill_product.setSliderImage(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Name);
        if (columnIndex > 0) {
            eb_seckill_product.setName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Intro);
        if (columnIndex > 0) {
            eb_seckill_product.setIntro(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Keyword);
        if (columnIndex > 0) {
            eb_seckill_product.setKeyword(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.BrandId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setBrandId(null);
            } else {
                eb_seckill_product.setBrandId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.CategoryId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setCategoryId(null);
            } else {
                eb_seckill_product.setCategoryId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.GuaranteeIds);
        if (columnIndex > 0) {
            eb_seckill_product.setGuaranteeIds(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Price);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setPrice(null);
            } else {
                eb_seckill_product.setPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.SeckillPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setSeckillPrice(null);
            } else {
                eb_seckill_product.setSeckillPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.UnitName);
        if (columnIndex > 0) {
            eb_seckill_product.setUnitName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Sales);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setSales(null);
            } else {
                eb_seckill_product.setSales(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.TempId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setTempId(null);
            } else {
                eb_seckill_product.setTempId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Sort);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setSort(null);
            } else {
                eb_seckill_product.setSort(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.SpecType);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setSpecType(null);
            } else {
                eb_seckill_product.setSpecType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.IsShow);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setIsShow(null);
            } else {
                eb_seckill_product.setIsShow(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.AuditStatus);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setAuditStatus(null);
            } else {
                eb_seckill_product.setAuditStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Reason);
        if (columnIndex > 0) {
            eb_seckill_product.setReason(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.QuotaShow);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setQuotaShow(null);
            } else {
                eb_seckill_product.setQuotaShow(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.Quota);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setQuota(null);
            } else {
                eb_seckill_product.setQuota(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setIsDel(null);
            } else {
                eb_seckill_product.setIsDel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setCreateTime(null);
            } else {
                eb_seckill_product.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbSeckillProduct_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_seckill_product.setUpdateTime(null);
            } else {
                eb_seckill_product.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_seckill_product;
    }
}
