
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_SHIPPING_TEMPLATES *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbShippingTemplates extends BasePo<EbShippingTemplates> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbShippingTemplates ROW_MAPPER = new EbShippingTemplates();

    // 主键
    private Integer id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private Integer merId = null;
    @JsonIgnore
    protected boolean isset_merId = false;

    private String name = null;
    @JsonIgnore
    protected boolean isset_name = false;

    private Integer type = null;
    @JsonIgnore
    protected boolean isset_type = false;

    private Integer appoint = null;
    @JsonIgnore
    protected boolean isset_appoint = false;

    private Integer sort = null;
    @JsonIgnore
    protected boolean isset_sort = false;

    private Long createTime = null;
    @JsonIgnore
    protected boolean isset_createTime = false;

    private Long updateTime = null;
    @JsonIgnore
    protected boolean isset_updateTime = false;

    /**
     * 默认构造函数
     */
    public EbShippingTemplates() {
    }

    /**
     * 根据主键构造对象
     */
    public EbShippingTemplates(Integer id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Integer) value);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public Integer getMerId() {
        return this.merId;
    }

    public void setMerId(Integer merId) {
        this.merId = merId;
        this.isset_merId = true;
    }

    @JsonIgnore
    public boolean isEmptyMerId() {
        return this.merId == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.isset_name = true;
    }

    @JsonIgnore
    public boolean isEmptyName() {
        return this.name == null || this.name.length() == 0;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
        this.isset_type = true;
    }

    @JsonIgnore
    public boolean isEmptyType() {
        return this.type == null;
    }

    public Integer getAppoint() {
        return this.appoint;
    }

    public void setAppoint(Integer appoint) {
        this.appoint = appoint;
        this.isset_appoint = true;
    }

    @JsonIgnore
    public boolean isEmptyAppoint() {
        return this.appoint == null;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
        this.isset_sort = true;
    }

    @JsonIgnore
    public boolean isEmptySort() {
        return this.sort == null;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
        this.isset_createTime = true;
    }

    @JsonIgnore
    public boolean isEmptyCreateTime() {
        return this.createTime == null;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Long updateTime) {
        this.updateTime = updateTime;
        this.isset_updateTime = true;
    }

    @JsonIgnore
    public boolean isEmptyUpdateTime() {
        return this.updateTime == null;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("merId=").append(this.merId)
                .append("name=").append(this.name)
                .append("type=").append(this.type)
                .append("appoint=").append(this.appoint)
                .append("sort=").append(this.sort)
                .append("createTime=").append(this.createTime)
                .append("updateTime=").append(this.updateTime)
                .toString();
    }

    /**
     * 克隆
     */
    public EbShippingTemplates $clone() {
        EbShippingTemplates eb_shipping_templates = new EbShippingTemplates();

        // 数据库名称
        //eb_shipping_templates.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_shipping_templates.setId(this.getId());
        }
        // 普通属性
        if (this.isset_merId) {
            eb_shipping_templates.setMerId(this.getMerId());
        }
        if (this.isset_name) {
            eb_shipping_templates.setName(this.getName());
        }
        if (this.isset_type) {
            eb_shipping_templates.setType(this.getType());
        }
        if (this.isset_appoint) {
            eb_shipping_templates.setAppoint(this.getAppoint());
        }
        if (this.isset_sort) {
            eb_shipping_templates.setSort(this.getSort());
        }
        if (this.isset_createTime) {
            eb_shipping_templates.setCreateTime(this.getCreateTime());
        }
        if (this.isset_updateTime) {
            eb_shipping_templates.setUpdateTime(this.getUpdateTime());
        }
        return eb_shipping_templates;
    }
}
