package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import com.walker.jdbc.util.StringUtils;

import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_SHIPPING_TEMPLATES_REGION *
 * @author genrator
 */
public class EbShippingTemplatesRegion_mapper extends EbShippingTemplatesRegion implements BaseMapper<EbShippingTemplatesRegion> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbShippingTemplatesRegion> ROW_MAPPER = new EbShippingTemplatesRegionRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String TempId = "temp_id";
    public static final String CityId = "city_id";
    public static final String Title = "title";
    public static final String First = "first";
    public static final String FirstPrice = "first_price";
    public static final String Renewal = "renewal";
    public static final String RenewalPrice = "renewal_price";
    public static final String Type = "type";
    public static final String Uniqid = "uniqid";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbShippingTemplatesRegion_mapper(EbShippingTemplatesRegion ebShippingTemplatesRegion) {
        if (ebShippingTemplatesRegion == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebShippingTemplatesRegion.isset_id) {
            this.setId(ebShippingTemplatesRegion.getId());
        }
        //普通属性
        if (ebShippingTemplatesRegion.isset_tempId) {
            this.setTempId(ebShippingTemplatesRegion.getTempId());
        }
        if (ebShippingTemplatesRegion.isset_cityId) {
            this.setCityId(ebShippingTemplatesRegion.getCityId());
        }
        if (ebShippingTemplatesRegion.isset_title) {
            this.setTitle(ebShippingTemplatesRegion.getTitle());
        }
        if (ebShippingTemplatesRegion.isset_first) {
            this.setFirst(ebShippingTemplatesRegion.getFirst());
        }
        if (ebShippingTemplatesRegion.isset_firstPrice) {
            this.setFirstPrice(ebShippingTemplatesRegion.getFirstPrice());
        }
        if (ebShippingTemplatesRegion.isset_renewal) {
            this.setRenewal(ebShippingTemplatesRegion.getRenewal());
        }
        if (ebShippingTemplatesRegion.isset_renewalPrice) {
            this.setRenewalPrice(ebShippingTemplatesRegion.getRenewalPrice());
        }
        if (ebShippingTemplatesRegion.isset_type) {
            this.setType(ebShippingTemplatesRegion.getType());
        }
        if (ebShippingTemplatesRegion.isset_uniqid) {
            this.setUniqid(ebShippingTemplatesRegion.getUniqid());
        }
        if (ebShippingTemplatesRegion.isset_createTime) {
            this.setCreateTime(ebShippingTemplatesRegion.getCreateTime());
        }
        if (ebShippingTemplatesRegion.isset_updateTime) {
            this.setUpdateTime(ebShippingTemplatesRegion.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_shipping_templates_region.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_shipping_templates_region";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(TempId, this.getTempId(), this.isset_tempId);
        ib.set(CityId, this.getCityId(), this.isset_cityId);
        ib.set(Title, this.getTitle(), this.isset_title);
        ib.set(First, this.getFirst(), this.isset_first);
        ib.set(FirstPrice, this.getFirstPrice(), this.isset_firstPrice);
        ib.set(Renewal, this.getRenewal(), this.isset_renewal);
        ib.set(RenewalPrice, this.getRenewalPrice(), this.isset_renewalPrice);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(Uniqid, this.getUniqid(), this.isset_uniqid);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(CityId, this.getCityId(), this.isset_cityId);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(First, this.getFirst(), this.isset_first);
        ub.set(FirstPrice, this.getFirstPrice(), this.isset_firstPrice);
        ub.set(Renewal, this.getRenewal(), this.isset_renewal);
        ub.set(RenewalPrice, this.getRenewalPrice(), this.isset_renewalPrice);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Uniqid, this.getUniqid(), this.isset_uniqid);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(CityId, this.getCityId(), this.isset_cityId);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(First, this.getFirst(), this.isset_first);
        ub.set(FirstPrice, this.getFirstPrice(), this.isset_firstPrice);
        ub.set(Renewal, this.getRenewal(), this.isset_renewal);
        ub.set(RenewalPrice, this.getRenewalPrice(), this.isset_renewalPrice);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Uniqid, this.getUniqid(), this.isset_uniqid);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(TempId, this.getTempId(), this.isset_tempId);
        ub.set(CityId, this.getCityId(), this.isset_cityId);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(First, this.getFirst(), this.isset_first);
        ub.set(FirstPrice, this.getFirstPrice(), this.isset_firstPrice);
        ub.set(Renewal, this.getRenewal(), this.isset_renewal);
        ub.set(RenewalPrice, this.getRenewalPrice(), this.isset_renewalPrice);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Uniqid, this.getUniqid(), this.isset_uniqid);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, temp_id, city_id, title, first, first_price, renewal, renewal_price, type, uniqid, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, temp_id, city_id, title, first, first_price, renewal, renewal_price, type, uniqid, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbShippingTemplatesRegion mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbShippingTemplatesRegion toEbShippingTemplatesRegion() {
        return super.$clone();
    }
}

/**
 * eb_shipping_templates_region RowMapper
 *
 * @author genrator
 */
class EbShippingTemplatesRegionRowMapper implements RowMapper<EbShippingTemplatesRegion> {

    @Override
    public EbShippingTemplatesRegion mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbShippingTemplatesRegion eb_shipping_templates_region = new EbShippingTemplatesRegion();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.Id);
        if (columnIndex > 0) {
            eb_shipping_templates_region.setId(rs.getInt(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.TempId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_region.setTempId(null);
            } else {
                eb_shipping_templates_region.setTempId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.CityId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_region.setCityId(null);
            } else {
                eb_shipping_templates_region.setCityId(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.Title);
        if (columnIndex > 0) {
            eb_shipping_templates_region.setTitle(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.First);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_region.setFirst(null);
            } else {
                eb_shipping_templates_region.setFirst(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.FirstPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_region.setFirstPrice(null);
            } else {
                eb_shipping_templates_region.setFirstPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.Renewal);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_region.setRenewal(null);
            } else {
                eb_shipping_templates_region.setRenewal(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.RenewalPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_region.setRenewalPrice(null);
            } else {
                eb_shipping_templates_region.setRenewalPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_region.setType(null);
            } else {
                eb_shipping_templates_region.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.Uniqid);
        if (columnIndex > 0) {
            eb_shipping_templates_region.setUniqid(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_region.setCreateTime(null);
            } else {
                eb_shipping_templates_region.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbShippingTemplatesRegion_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_shipping_templates_region.setUpdateTime(null);
            } else {
                eb_shipping_templates_region.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_shipping_templates_region;
    }
}
