package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_USER_BROKERAGE_RECORD *
 * @author genrator
 */
public class EbUserBrokerageRecord_mapper extends EbUserBrokerageRecord implements BaseMapper<EbUserBrokerageRecord> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbUserBrokerageRecord> ROW_MAPPER = new EbUserBrokerageRecordRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Uid = "uid";
    public static final String SubUid = "sub_uid";
    public static final String LinkNo = "link_no";
    public static final String LinkType = "link_type";
    public static final String Type = "type";
    public static final String Title = "title";
    public static final String Price = "price";
    public static final String Balance = "balance";
    public static final String Mark = "mark";
    public static final String Status = "status";
    public static final String FrozenTime = "frozen_time";
    public static final String ThawTime = "thaw_time";
    public static final String BrokerageLevel = "brokerage_level";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbUserBrokerageRecord_mapper(EbUserBrokerageRecord ebUserBrokerageRecord) {
        if (ebUserBrokerageRecord == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebUserBrokerageRecord.isset_id) {
            this.setId(ebUserBrokerageRecord.getId());
        }
        //普通属性
        if (ebUserBrokerageRecord.isset_uid) {
            this.setUid(ebUserBrokerageRecord.getUid());
        }
        if (ebUserBrokerageRecord.isset_subUid) {
            this.setSubUid(ebUserBrokerageRecord.getSubUid());
        }
        if (ebUserBrokerageRecord.isset_linkNo) {
            this.setLinkNo(ebUserBrokerageRecord.getLinkNo());
        }
        if (ebUserBrokerageRecord.isset_linkType) {
            this.setLinkType(ebUserBrokerageRecord.getLinkType());
        }
        if (ebUserBrokerageRecord.isset_type) {
            this.setType(ebUserBrokerageRecord.getType());
        }
        if (ebUserBrokerageRecord.isset_title) {
            this.setTitle(ebUserBrokerageRecord.getTitle());
        }
        if (ebUserBrokerageRecord.isset_price) {
            this.setPrice(ebUserBrokerageRecord.getPrice());
        }
        if (ebUserBrokerageRecord.isset_balance) {
            this.setBalance(ebUserBrokerageRecord.getBalance());
        }
        if (ebUserBrokerageRecord.isset_mark) {
            this.setMark(ebUserBrokerageRecord.getMark());
        }
        if (ebUserBrokerageRecord.isset_status) {
            this.setStatus(ebUserBrokerageRecord.getStatus());
        }
        if (ebUserBrokerageRecord.isset_frozenTime) {
            this.setFrozenTime(ebUserBrokerageRecord.getFrozenTime());
        }
        if (ebUserBrokerageRecord.isset_thawTime) {
            this.setThawTime(ebUserBrokerageRecord.getThawTime());
        }
        if (ebUserBrokerageRecord.isset_brokerageLevel) {
            this.setBrokerageLevel(ebUserBrokerageRecord.getBrokerageLevel());
        }
        if (ebUserBrokerageRecord.isset_createTime) {
            this.setCreateTime(ebUserBrokerageRecord.getCreateTime());
        }
        if (ebUserBrokerageRecord.isset_updateTime) {
            this.setUpdateTime(ebUserBrokerageRecord.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_user_brokerage_record.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_user_brokerage_record";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(SubUid, this.getSubUid(), this.isset_subUid);
        ib.set(LinkNo, this.getLinkNo(), this.isset_linkNo);
        ib.set(LinkType, this.getLinkType(), this.isset_linkType);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(Title, this.getTitle(), this.isset_title);
        ib.set(Price, this.getPrice(), this.isset_price);
        ib.set(Balance, this.getBalance(), this.isset_balance);
        ib.set(Mark, this.getMark(), this.isset_mark);
        ib.set(Status, this.getStatus(), this.isset_status);
        ib.set(FrozenTime, this.getFrozenTime(), this.isset_frozenTime);
        ib.set(ThawTime, this.getThawTime(), this.isset_thawTime);
        ib.set(BrokerageLevel, this.getBrokerageLevel(), this.isset_brokerageLevel);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(SubUid, this.getSubUid(), this.isset_subUid);
        ub.set(LinkNo, this.getLinkNo(), this.isset_linkNo);
        ub.set(LinkType, this.getLinkType(), this.isset_linkType);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(FrozenTime, this.getFrozenTime(), this.isset_frozenTime);
        ub.set(ThawTime, this.getThawTime(), this.isset_thawTime);
        ub.set(BrokerageLevel, this.getBrokerageLevel(), this.isset_brokerageLevel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(SubUid, this.getSubUid(), this.isset_subUid);
        ub.set(LinkNo, this.getLinkNo(), this.isset_linkNo);
        ub.set(LinkType, this.getLinkType(), this.isset_linkType);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(FrozenTime, this.getFrozenTime(), this.isset_frozenTime);
        ub.set(ThawTime, this.getThawTime(), this.isset_thawTime);
        ub.set(BrokerageLevel, this.getBrokerageLevel(), this.isset_brokerageLevel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(SubUid, this.getSubUid(), this.isset_subUid);
        ub.set(LinkNo, this.getLinkNo(), this.isset_linkNo);
        ub.set(LinkType, this.getLinkType(), this.isset_linkType);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(Title, this.getTitle(), this.isset_title);
        ub.set(Price, this.getPrice(), this.isset_price);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(Status, this.getStatus(), this.isset_status);
        ub.set(FrozenTime, this.getFrozenTime(), this.isset_frozenTime);
        ub.set(ThawTime, this.getThawTime(), this.isset_thawTime);
        ub.set(BrokerageLevel, this.getBrokerageLevel(), this.isset_brokerageLevel);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, uid, sub_uid, link_no, link_type, type, title, price, balance, mark, status, frozen_time, thaw_time, brokerage_level, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, uid, sub_uid, link_no, link_type, type, title, price, balance, mark, status, frozen_time, thaw_time, brokerage_level, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbUserBrokerageRecord mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbUserBrokerageRecord toEbUserBrokerageRecord() {
        return super.$clone();
    }
}

/**
 * eb_user_brokerage_record RowMapper
 *
 * @author genrator
 */
class EbUserBrokerageRecordRowMapper implements RowMapper<EbUserBrokerageRecord> {

    @Override
    public EbUserBrokerageRecord mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbUserBrokerageRecord eb_user_brokerage_record = new EbUserBrokerageRecord();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.Id);
        if (columnIndex > 0) {
            eb_user_brokerage_record.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setUid(null);
            } else {
                eb_user_brokerage_record.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.SubUid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setSubUid(null);
            } else {
                eb_user_brokerage_record.setSubUid(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.LinkNo);
        if (columnIndex > 0) {
            eb_user_brokerage_record.setLinkNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.LinkType);
        if (columnIndex > 0) {
            eb_user_brokerage_record.setLinkType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setType(null);
            } else {
                eb_user_brokerage_record.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.Title);
        if (columnIndex > 0) {
            eb_user_brokerage_record.setTitle(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.Price);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setPrice(null);
            } else {
                eb_user_brokerage_record.setPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.Balance);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setBalance(null);
            } else {
                eb_user_brokerage_record.setBalance(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.Mark);
        if (columnIndex > 0) {
            eb_user_brokerage_record.setMark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.Status);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setStatus(null);
            } else {
                eb_user_brokerage_record.setStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.FrozenTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setFrozenTime(null);
            } else {
                eb_user_brokerage_record.setFrozenTime(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.ThawTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setThawTime(null);
            } else {
                eb_user_brokerage_record.setThawTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.BrokerageLevel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setBrokerageLevel(null);
            } else {
                eb_user_brokerage_record.setBrokerageLevel(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setCreateTime(null);
            } else {
                eb_user_brokerage_record.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserBrokerageRecord_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_brokerage_record.setUpdateTime(null);
            } else {
                eb_user_brokerage_record.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_user_brokerage_record;
    }
}
