package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_USER_CLOSING *
 * @author genrator
 */
public class EbUserClosing_mapper extends EbUserClosing implements BaseMapper<EbUserClosing> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbUserClosing> ROW_MAPPER = new EbUserClosingRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String ClosingNo = "closing_no";
    public static final String Uid = "uid";
    public static final String ClosingType = "closing_type";
    public static final String Cardholder = "cardholder";
    public static final String BankCardNo = "bank_card_no";
    public static final String BankName = "bank_name";
    public static final String BankAddress = "bank_address";
    public static final String AlipayAccount = "alipay_account";
    public static final String WechatNo = "wechat_no";
    public static final String PaymentCode = "payment_code";
    public static final String ClosingPrice = "closing_price";
    public static final String Balance = "balance";
    public static final String Mark = "mark";
    public static final String AuditStatus = "audit_status";
    public static final String RefusalReason = "refusal_reason";
    public static final String AuditId = "audit_id";
    public static final String AuditTime = "audit_time";
    public static final String AccountStatus = "account_status";
    public static final String ClosingProof = "closing_proof";
    public static final String ClosingTime = "closing_time";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";
    public static final String RealName = "real_name";

    /**
     * 默认构造函数
     */
    public EbUserClosing_mapper(EbUserClosing ebUserClosing) {
        if (ebUserClosing == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebUserClosing.isset_id) {
            this.setId(ebUserClosing.getId());
        }
        //普通属性
        if (ebUserClosing.isset_closingNo) {
            this.setClosingNo(ebUserClosing.getClosingNo());
        }
        if (ebUserClosing.isset_uid) {
            this.setUid(ebUserClosing.getUid());
        }
        if (ebUserClosing.isset_closingType) {
            this.setClosingType(ebUserClosing.getClosingType());
        }
        if (ebUserClosing.isset_cardholder) {
            this.setCardholder(ebUserClosing.getCardholder());
        }
        if (ebUserClosing.isset_bankCardNo) {
            this.setBankCardNo(ebUserClosing.getBankCardNo());
        }
        if (ebUserClosing.isset_bankName) {
            this.setBankName(ebUserClosing.getBankName());
        }
        if (ebUserClosing.isset_bankAddress) {
            this.setBankAddress(ebUserClosing.getBankAddress());
        }
        if (ebUserClosing.isset_alipayAccount) {
            this.setAlipayAccount(ebUserClosing.getAlipayAccount());
        }
        if (ebUserClosing.isset_wechatNo) {
            this.setWechatNo(ebUserClosing.getWechatNo());
        }
        if (ebUserClosing.isset_paymentCode) {
            this.setPaymentCode(ebUserClosing.getPaymentCode());
        }
        if (ebUserClosing.isset_closingPrice) {
            this.setClosingPrice(ebUserClosing.getClosingPrice());
        }
        if (ebUserClosing.isset_balance) {
            this.setBalance(ebUserClosing.getBalance());
        }
        if (ebUserClosing.isset_mark) {
            this.setMark(ebUserClosing.getMark());
        }
        if (ebUserClosing.isset_auditStatus) {
            this.setAuditStatus(ebUserClosing.getAuditStatus());
        }
        if (ebUserClosing.isset_refusalReason) {
            this.setRefusalReason(ebUserClosing.getRefusalReason());
        }
        if (ebUserClosing.isset_auditId) {
            this.setAuditId(ebUserClosing.getAuditId());
        }
        if (ebUserClosing.isset_auditTime) {
            this.setAuditTime(ebUserClosing.getAuditTime());
        }
        if (ebUserClosing.isset_accountStatus) {
            this.setAccountStatus(ebUserClosing.getAccountStatus());
        }
        if (ebUserClosing.isset_closingProof) {
            this.setClosingProof(ebUserClosing.getClosingProof());
        }
        if (ebUserClosing.isset_closingTime) {
            this.setClosingTime(ebUserClosing.getClosingTime());
        }
        if (ebUserClosing.isset_createTime) {
            this.setCreateTime(ebUserClosing.getCreateTime());
        }
        if (ebUserClosing.isset_updateTime) {
            this.setUpdateTime(ebUserClosing.getUpdateTime());
        }
        if (ebUserClosing.isset_realName) {
            this.setRealName(ebUserClosing.getRealName());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_user_closing.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_user_closing";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(ClosingNo, this.getClosingNo(), this.isset_closingNo);
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(ClosingType, this.getClosingType(), this.isset_closingType);
        ib.set(Cardholder, this.getCardholder(), this.isset_cardholder);
        ib.set(BankCardNo, this.getBankCardNo(), this.isset_bankCardNo);
        ib.set(BankName, this.getBankName(), this.isset_bankName);
        ib.set(BankAddress, this.getBankAddress(), this.isset_bankAddress);
        ib.set(AlipayAccount, this.getAlipayAccount(), this.isset_alipayAccount);
        ib.set(WechatNo, this.getWechatNo(), this.isset_wechatNo);
        ib.set(PaymentCode, this.getPaymentCode(), this.isset_paymentCode);
        ib.set(ClosingPrice, this.getClosingPrice(), this.isset_closingPrice);
        ib.set(Balance, this.getBalance(), this.isset_balance);
        ib.set(Mark, this.getMark(), this.isset_mark);
        ib.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ib.set(RefusalReason, this.getRefusalReason(), this.isset_refusalReason);
        ib.set(AuditId, this.getAuditId(), this.isset_auditId);
        ib.set(AuditTime, this.getAuditTime(), this.isset_auditTime);
        ib.set(AccountStatus, this.getAccountStatus(), this.isset_accountStatus);
        ib.set(ClosingProof, this.getClosingProof(), this.isset_closingProof);
        ib.set(ClosingTime, this.getClosingTime(), this.isset_closingTime);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ib.set(RealName, this.getRealName(), this.isset_realName);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ClosingNo, this.getClosingNo(), this.isset_closingNo);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(ClosingType, this.getClosingType(), this.isset_closingType);
        ub.set(Cardholder, this.getCardholder(), this.isset_cardholder);
        ub.set(BankCardNo, this.getBankCardNo(), this.isset_bankCardNo);
        ub.set(BankName, this.getBankName(), this.isset_bankName);
        ub.set(BankAddress, this.getBankAddress(), this.isset_bankAddress);
        ub.set(AlipayAccount, this.getAlipayAccount(), this.isset_alipayAccount);
        ub.set(WechatNo, this.getWechatNo(), this.isset_wechatNo);
        ub.set(PaymentCode, this.getPaymentCode(), this.isset_paymentCode);
        ub.set(ClosingPrice, this.getClosingPrice(), this.isset_closingPrice);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(RefusalReason, this.getRefusalReason(), this.isset_refusalReason);
        ub.set(AuditId, this.getAuditId(), this.isset_auditId);
        ub.set(AuditTime, this.getAuditTime(), this.isset_auditTime);
        ub.set(AccountStatus, this.getAccountStatus(), this.isset_accountStatus);
        ub.set(ClosingProof, this.getClosingProof(), this.isset_closingProof);
        ub.set(ClosingTime, this.getClosingTime(), this.isset_closingTime);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ClosingNo, this.getClosingNo(), this.isset_closingNo);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(ClosingType, this.getClosingType(), this.isset_closingType);
        ub.set(Cardholder, this.getCardholder(), this.isset_cardholder);
        ub.set(BankCardNo, this.getBankCardNo(), this.isset_bankCardNo);
        ub.set(BankName, this.getBankName(), this.isset_bankName);
        ub.set(BankAddress, this.getBankAddress(), this.isset_bankAddress);
        ub.set(AlipayAccount, this.getAlipayAccount(), this.isset_alipayAccount);
        ub.set(WechatNo, this.getWechatNo(), this.isset_wechatNo);
        ub.set(PaymentCode, this.getPaymentCode(), this.isset_paymentCode);
        ub.set(ClosingPrice, this.getClosingPrice(), this.isset_closingPrice);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(RefusalReason, this.getRefusalReason(), this.isset_refusalReason);
        ub.set(AuditId, this.getAuditId(), this.isset_auditId);
        ub.set(AuditTime, this.getAuditTime(), this.isset_auditTime);
        ub.set(AccountStatus, this.getAccountStatus(), this.isset_accountStatus);
        ub.set(ClosingProof, this.getClosingProof(), this.isset_closingProof);
        ub.set(ClosingTime, this.getClosingTime(), this.isset_closingTime);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ClosingNo, this.getClosingNo(), this.isset_closingNo);
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(ClosingType, this.getClosingType(), this.isset_closingType);
        ub.set(Cardholder, this.getCardholder(), this.isset_cardholder);
        ub.set(BankCardNo, this.getBankCardNo(), this.isset_bankCardNo);
        ub.set(BankName, this.getBankName(), this.isset_bankName);
        ub.set(BankAddress, this.getBankAddress(), this.isset_bankAddress);
        ub.set(AlipayAccount, this.getAlipayAccount(), this.isset_alipayAccount);
        ub.set(WechatNo, this.getWechatNo(), this.isset_wechatNo);
        ub.set(PaymentCode, this.getPaymentCode(), this.isset_paymentCode);
        ub.set(ClosingPrice, this.getClosingPrice(), this.isset_closingPrice);
        ub.set(Balance, this.getBalance(), this.isset_balance);
        ub.set(Mark, this.getMark(), this.isset_mark);
        ub.set(AuditStatus, this.getAuditStatus(), this.isset_auditStatus);
        ub.set(RefusalReason, this.getRefusalReason(), this.isset_refusalReason);
        ub.set(AuditId, this.getAuditId(), this.isset_auditId);
        ub.set(AuditTime, this.getAuditTime(), this.isset_auditTime);
        ub.set(AccountStatus, this.getAccountStatus(), this.isset_accountStatus);
        ub.set(ClosingProof, this.getClosingProof(), this.isset_closingProof);
        ub.set(ClosingTime, this.getClosingTime(), this.isset_closingTime);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.set(RealName, this.getRealName(), this.isset_realName);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, closing_no, uid, closing_type, cardholder, bank_card_no, bank_name, bank_address, alipay_account, wechat_no, payment_code, closing_price, balance, mark, audit_status, refusal_reason, audit_id, audit_time, account_status, closing_proof, closing_time, create_time, update_time, real_name from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, closing_no, uid, closing_type, cardholder, bank_card_no, bank_name, bank_address, alipay_account, wechat_no, payment_code, closing_price, balance, mark, audit_status, refusal_reason, audit_id, audit_time, account_status, closing_proof, closing_time, create_time, update_time, real_name from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbUserClosing mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbUserClosing toEbUserClosing() {
        return super.$clone();
    }
}

/**
 * eb_user_closing RowMapper
 *
 * @author genrator
 */
class EbUserClosingRowMapper implements RowMapper<EbUserClosing> {

    @Override
    public EbUserClosing mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbUserClosing eb_user_closing = new EbUserClosing();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.Id);
        if (columnIndex > 0) {
            eb_user_closing.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.ClosingNo);
        if (columnIndex > 0) {
            eb_user_closing.setClosingNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setUid(null);
            } else {
                eb_user_closing.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.ClosingType);
        if (columnIndex > 0) {
            eb_user_closing.setClosingType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.Cardholder);
        if (columnIndex > 0) {
            eb_user_closing.setCardholder(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.BankCardNo);
        if (columnIndex > 0) {
            eb_user_closing.setBankCardNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.BankName);
        if (columnIndex > 0) {
            eb_user_closing.setBankName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.BankAddress);
        if (columnIndex > 0) {
            eb_user_closing.setBankAddress(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.AlipayAccount);
        if (columnIndex > 0) {
            eb_user_closing.setAlipayAccount(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.WechatNo);
        if (columnIndex > 0) {
            eb_user_closing.setWechatNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.PaymentCode);
        if (columnIndex > 0) {
            eb_user_closing.setPaymentCode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.ClosingPrice);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setClosingPrice(null);
            } else {
                eb_user_closing.setClosingPrice(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.Balance);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setBalance(null);
            } else {
                eb_user_closing.setBalance(rs.getDouble(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.Mark);
        if (columnIndex > 0) {
            eb_user_closing.setMark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.AuditStatus);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setAuditStatus(null);
            } else {
                eb_user_closing.setAuditStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.RefusalReason);
        if (columnIndex > 0) {
            eb_user_closing.setRefusalReason(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.AuditId);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setAuditId(null);
            } else {
                eb_user_closing.setAuditId(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.AuditTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setAuditTime(null);
            } else {
                eb_user_closing.setAuditTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.AccountStatus);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setAccountStatus(null);
            } else {
                eb_user_closing.setAccountStatus(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.ClosingProof);
        if (columnIndex > 0) {
            eb_user_closing.setClosingProof(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.ClosingTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setClosingTime(null);
            } else {
                eb_user_closing.setClosingTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setCreateTime(null);
            } else {
                eb_user_closing.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_closing.setUpdateTime(null);
            } else {
                eb_user_closing.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserClosing_mapper.RealName);
        if (columnIndex > 0) {
            eb_user_closing.setRealName(rs.getString(columnIndex));
        }
        return eb_user_closing;
    }
}
