
package com.ishop.model.po;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.jdbc.BasePo;

/**
 * 表名:EB_USER_TAG *
 * @author genrator
 */
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY)
public class EbUserTag extends BasePo<EbUserTag> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    /**
     * 用于兼容老写法
     */
    @JsonIgnore
    public static final EbUserTag ROW_MAPPER = new EbUserTag();

    // 主键
    private Integer id = null;
    @JsonIgnore
    protected boolean isset_id = false;

    // 属性列表
    private String name = null;
    @JsonIgnore
    protected boolean isset_name = false;

    /**
     * 默认构造函数
     */
    public EbUserTag() {
    }

    /**
     * 根据主键构造对象
     */
    public EbUserTag(Integer id) {
        this.setId(id);
    }

    /**
     * 设置主键值
     */
    @Override
    public void setPkValue(Object value) {
        this.setId((Integer) value);
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.isset_id = true;
    }

    @JsonIgnore
    public boolean isEmptyId() {
        return this.id == null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.isset_name = true;
    }

    @JsonIgnore
    public boolean isEmptyName() {
        return this.name == null || this.name.length() == 0;
    }

    /**
     * 重写 toString() 方法
     */
    @Override
    public String toString() {
        return new StringBuilder()
                .append("id=").append(this.id)
                .append("name=").append(this.name)
                .toString();
    }

    /**
     * 克隆
     */
    public EbUserTag $clone() {
        EbUserTag eb_user_tag = new EbUserTag();

        // 数据库名称
        //eb_user_tag.setDatabaseName_(this.getDatabaseName_());

        // 主键
        if (this.isset_id) {
            eb_user_tag.setId(this.getId());
        }
        // 普通属性
        if (this.isset_name) {
            eb_user_tag.setName(this.getName());
        }
        return eb_user_tag;
    }
}
